/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.businessobject;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurApItemUseTax;
import org.kuali.kfs.module.purap.businessobject.PurApSummaryItem;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.sys.util.ObjectPopulationUtils;

public abstract class PurApItemBase
extends PersistableBusinessObjectBase
implements PurApItem {
    private Integer itemIdentifier;
    private Integer itemLineNumber;
    private String itemUnitOfMeasureCode;
    private String itemCatalogNumber;
    private String itemDescription;
    private BigDecimal itemUnitPrice;
    private String itemTypeCode = "ITEM";
    private String itemAuxiliaryPartIdentifier;
    private String externalOrganizationB2bProductReferenceNumber;
    private String externalOrganizationB2bProductTypeName;
    private boolean itemAssignedToTradeInIndicator;
    private KualiDecimal extendedPrice;
    private KualiDecimal itemSalesTaxAmount;
    private List<PurApItemUseTax> useTaxItems;
    private List<PurApAccountingLine> sourceAccountingLines = new ArrayList<PurApAccountingLine>();
    private List<PurApAccountingLine> baselineSourceAccountingLines = new ArrayList<PurApAccountingLine>();
    private PurApAccountingLine newSourceLine;
    private ItemType itemType;
    private Integer purapDocumentIdentifier;
    private KualiDecimal itemQuantity;
    private PurchasingAccountsPayableDocument purapDocument;

    public PurApItemBase() {
        this.useTaxItems = new ArrayList<PurApItemUseTax>();
        this.resetAccount();
    }

    @Override
    public String getItemIdentifierString() {
        String itemLineNumberString = this.getItemLineNumber() != null ? this.getItemLineNumber().toString() : "";
        return this.getItemType().isLineItemIndicator() ? "Item " + itemLineNumberString : this.getItemType().getItemTypeDescription();
    }

    @Override
    public Integer getItemIdentifier() {
        return this.itemIdentifier;
    }

    @Override
    public void setItemIdentifier(Integer ItemIdentifier) {
        this.itemIdentifier = ItemIdentifier;
    }

    @Override
    public Integer getItemLineNumber() {
        return this.itemLineNumber;
    }

    @Override
    public void setItemLineNumber(Integer itemLineNumber) {
        this.itemLineNumber = itemLineNumber;
    }

    @Override
    public String getItemUnitOfMeasureCode() {
        return this.itemUnitOfMeasureCode;
    }

    @Override
    public void setItemUnitOfMeasureCode(String itemUnitOfMeasureCode) {
        this.itemUnitOfMeasureCode = StringUtils.isNotBlank((CharSequence)itemUnitOfMeasureCode) ? itemUnitOfMeasureCode.toUpperCase(Locale.US) : itemUnitOfMeasureCode;
    }

    @Override
    public String getItemCatalogNumber() {
        return this.itemCatalogNumber;
    }

    @Override
    public void setItemCatalogNumber(String itemCatalogNumber) {
        this.itemCatalogNumber = itemCatalogNumber;
    }

    @Override
    public String getItemDescription() {
        return this.itemDescription;
    }

    @Override
    public void setItemDescription(String itemDescription) {
        this.itemDescription = itemDescription;
    }

    @Override
    public BigDecimal getItemUnitPrice() {
        if (this.itemUnitPrice != null) {
            if (this.itemUnitPrice.scale() < 2) {
                this.itemUnitPrice = this.itemUnitPrice.setScale(2, KualiDecimal.ROUND_BEHAVIOR);
            } else if (this.itemUnitPrice.scale() > 4) {
                this.itemUnitPrice = this.itemUnitPrice.setScale(4, KualiDecimal.ROUND_BEHAVIOR);
            }
        }
        return this.itemUnitPrice;
    }

    @Override
    public void setItemUnitPrice(BigDecimal itemUnitPrice) {
        if (itemUnitPrice != null) {
            if (itemUnitPrice.scale() < 2) {
                itemUnitPrice = itemUnitPrice.setScale(2, KualiDecimal.ROUND_BEHAVIOR);
            } else if (itemUnitPrice.scale() > 4) {
                itemUnitPrice = itemUnitPrice.setScale(4, KualiDecimal.ROUND_BEHAVIOR);
            }
        }
        this.itemUnitPrice = itemUnitPrice;
    }

    @Override
    public String getItemTypeCode() {
        return this.itemTypeCode;
    }

    @Override
    public void setItemTypeCode(String itemTypeCode) {
        this.itemTypeCode = itemTypeCode;
    }

    @Override
    public String getItemAuxiliaryPartIdentifier() {
        return this.itemAuxiliaryPartIdentifier;
    }

    @Override
    public void setItemAuxiliaryPartIdentifier(String itemAuxiliaryPartIdentifier) {
        this.itemAuxiliaryPartIdentifier = itemAuxiliaryPartIdentifier;
    }

    @Override
    public String getExternalOrganizationB2bProductReferenceNumber() {
        return this.externalOrganizationB2bProductReferenceNumber;
    }

    @Override
    public void setExternalOrganizationB2bProductReferenceNumber(String externalOrganizationB2bProductReferenceNumber) {
        this.externalOrganizationB2bProductReferenceNumber = externalOrganizationB2bProductReferenceNumber;
    }

    @Override
    public String getExternalOrganizationB2bProductTypeName() {
        return this.externalOrganizationB2bProductTypeName;
    }

    @Override
    public void setExternalOrganizationB2bProductTypeName(String externalOrganizationB2bProductTypeName) {
        this.externalOrganizationB2bProductTypeName = externalOrganizationB2bProductTypeName;
    }

    @Override
    public boolean getItemAssignedToTradeInIndicator() {
        return this.itemAssignedToTradeInIndicator;
    }

    @Override
    public void setItemAssignedToTradeInIndicator(boolean itemAssignedToTradeInIndicator) {
        this.itemAssignedToTradeInIndicator = itemAssignedToTradeInIndicator;
    }

    @Override
    public ItemType getItemType() {
        if (ObjectUtils.isNull((Object)((Object)this.itemType)) || !this.itemType.getItemTypeCode().equals(this.itemTypeCode)) {
            this.refreshReferenceObject("itemType");
        }
        return this.itemType;
    }

    @Override
    @Deprecated
    public void setItemType(ItemType itemType) {
        this.itemType = itemType;
    }

    @Override
    public KualiDecimal getItemTaxAmount() {
        KualiDecimal taxAmount = KualiDecimal.ZERO;
        if (ObjectUtils.isNull((Object)this.purapDocument)) {
            this.refreshReferenceObject("purapDocument");
        }
        if (!this.purapDocument.isUseTaxIndicator()) {
            taxAmount = this.itemSalesTaxAmount;
        } else {
            for (PurApItemUseTax useTaxItem : this.getUseTaxItems()) {
                taxAmount = (KualiDecimal)taxAmount.add((AbstractKualiDecimal)useTaxItem.getTaxAmount());
            }
        }
        return taxAmount;
    }

    @Override
    public void setItemTaxAmount(KualiDecimal itemTaxAmount) {
        if (this.purapDocument == null) {
            this.refreshReferenceObject("purapDocument");
        }
        if (!this.purapDocument.isUseTaxIndicator()) {
            this.itemSalesTaxAmount = itemTaxAmount;
        }
    }

    public final KualiDecimal getItemSalesTaxAmount() {
        return this.itemSalesTaxAmount;
    }

    public final void setItemSalesTaxAmount(KualiDecimal itemSalesTaxAmount) {
        this.itemSalesTaxAmount = itemSalesTaxAmount;
    }

    @Override
    public KualiDecimal getExtendedPrice() {
        return this.calculateExtendedPrice();
    }

    @Override
    public KualiDecimal getTotalAmount() {
        KualiDecimal taxAmount;
        KualiDecimal totalAmount = this.getExtendedPrice();
        if (ObjectUtils.isNull((Object)totalAmount)) {
            totalAmount = KualiDecimal.ZERO;
        }
        if (ObjectUtils.isNull((Object)(taxAmount = this.getItemTaxAmount()))) {
            taxAmount = KualiDecimal.ZERO;
        }
        totalAmount = (KualiDecimal)totalAmount.add((AbstractKualiDecimal)taxAmount);
        return totalAmount;
    }

    @Override
    public void setTotalAmount(KualiDecimal totalAmount) {
    }

    @Override
    public KualiDecimal calculateExtendedPrice() {
        KualiDecimal extendedPrice = KualiDecimal.ZERO;
        if (ObjectUtils.isNotNull((Object)this.itemUnitPrice)) {
            if (this.itemType.isAmountBasedGeneralLedgerIndicator()) {
                extendedPrice = new KualiDecimal(this.itemUnitPrice.toString());
            } else if (ObjectUtils.isNotNull((Object)this.getItemQuantity())) {
                BigDecimal calcExtendedPrice = this.itemUnitPrice.multiply(this.itemQuantity.bigDecimalValue());
                extendedPrice = new KualiDecimal(calcExtendedPrice.setScale(2, KualiDecimal.ROUND_BEHAVIOR));
            }
        }
        return extendedPrice;
    }

    @Override
    public void setExtendedPrice(KualiDecimal extendedPrice) {
        this.extendedPrice = extendedPrice;
    }

    @Override
    public List<PurApAccountingLine> getSourceAccountingLines() {
        return this.sourceAccountingLines;
    }

    @Override
    public void setSourceAccountingLines(List<PurApAccountingLine> accountingLines) {
        this.sourceAccountingLines = accountingLines;
    }

    @Override
    public List<PurApAccountingLine> getBaselineSourceAccountingLines() {
        return this.baselineSourceAccountingLines;
    }

    public void setBaselineSourceAccountingLines(List<PurApAccountingLine> baselineSourceLines) {
        this.baselineSourceAccountingLines = baselineSourceLines;
    }

    public PurApAccountingLine getSourceAccountingLine(int index) {
        while (this.getSourceAccountingLines().size() <= index) {
            PurApAccountingLine newAccount = this.getNewAccount();
            this.getSourceAccountingLines().add(newAccount);
        }
        return this.getSourceAccountingLines().get(index);
    }

    public PurApAccountingLine getBaselineSourceAccountingLine(int index) {
        while (this.getBaselineSourceAccountingLines().size() <= index) {
            PurApAccountingLine newAccount = this.getNewAccount();
            this.getBaselineSourceAccountingLines().add(newAccount);
        }
        return this.getBaselineSourceAccountingLines().get(index);
    }

    private PurApAccountingLine getNewAccount() throws RuntimeException {
        PurApAccountingLine newAccount;
        Class accountingLineClass = this.getAccountingLineClass();
        if (accountingLineClass == null) {
            throw new RuntimeException("Can't instantiate Purchasing Account from base");
        }
        try {
            newAccount = (PurApAccountingLine)accountingLineClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Unable to get class");
        }
        return newAccount;
    }

    @Override
    public abstract Class getAccountingLineClass();

    @Override
    public abstract Class getUseTaxClass();

    @Override
    public void resetAccount() {
        PurApAccountingLine purApAccountingLine = this.getNewAccount();
        purApAccountingLine.setItemIdentifier(this.itemIdentifier);
        purApAccountingLine.setPurapItem(this);
        purApAccountingLine.setSequenceNumber(0);
        this.setNewSourceLine(purApAccountingLine);
    }

    public List buildListOfDeletionAwareLists() {
        ArrayList<List<PurApAccountingLine>> managedLists = new ArrayList<List<PurApAccountingLine>>();
        managedLists.add(this.getSourceAccountingLines());
        return managedLists;
    }

    @Override
    public PurApAccountingLine getNewSourceLine() {
        return this.newSourceLine;
    }

    @Override
    public void setNewSourceLine(PurApAccountingLine newAccountingLine) {
        this.newSourceLine = newAccountingLine;
    }

    @Override
    public Integer getPurapDocumentIdentifier() {
        return this.purapDocumentIdentifier;
    }

    @Override
    public void setPurapDocumentIdentifier(Integer purapDocumentIdentifier) {
        this.purapDocumentIdentifier = purapDocumentIdentifier;
    }

    @Override
    public List<PurApItemUseTax> getUseTaxItems() {
        return this.useTaxItems;
    }

    @Override
    public void setUseTaxItems(List<PurApItemUseTax> useTaxItems) {
        this.useTaxItems = useTaxItems;
    }

    @Override
    public KualiDecimal getItemQuantity() {
        return this.itemQuantity;
    }

    @Override
    public void setItemQuantity(KualiDecimal itemQuantity) {
        this.itemQuantity = itemQuantity;
    }

    public boolean isAccountListEmpty() {
        List<PurApAccountingLine> accounts = this.getSourceAccountingLines();
        if (ObjectUtils.isNotNull(accounts)) {
            for (PurApAccountingLine element : accounts) {
                if (element.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public PurApSummaryItem getSummaryItem() {
        PurApSummaryItem summaryItem = new PurApSummaryItem();
        ObjectPopulationUtils.populateFromBaseClass(PurApItemBase.class, (BusinessObject)this, (BusinessObject)summaryItem, new HashMap());
        summaryItem.getItemType().setItemTypeDescription(this.itemType.getItemTypeDescription());
        return summaryItem;
    }

    @Override
    public final <T extends PurchasingAccountsPayableDocument> T getPurapDocument() {
        return (T)this.purapDocument;
    }

    @Override
    public final void setPurapDocument(PurchasingAccountsPayableDocument purapDoc) {
        this.purapDocument = purapDoc;
    }

    @Override
    public void fixAccountReferences() {
        if (ObjectUtils.isNull((Object)this.getItemIdentifier())) {
            for (PurApAccountingLine account : this.getSourceAccountingLines()) {
                account.setSequenceNumber(0);
                account.setPurapItem(this);
            }
        }
    }

    public void refreshNonUpdateableReferences() {
        Integer tempDocumentIdentifier;
        PurchasingAccountsPayableDocument document = null;
        Object tempDocument = this.getPurapDocument();
        if (tempDocument != null && (tempDocumentIdentifier = tempDocument.getPurapDocumentIdentifier()) != null) {
            document = (PurchasingAccountsPayableDocument)this.getPurapDocument();
        }
        super.refreshNonUpdateableReferences();
        if (ObjectUtils.isNotNull(document)) {
            this.setPurapDocument(document);
        }
    }

    @Override
    public KualiDecimal getTotalRemitAmount() {
        if (!this.purapDocument.isUseTaxIndicator()) {
            return this.getTotalAmount();
        }
        return this.getExtendedPrice();
    }

    public String toString() {
        return "Line " + (this.itemLineNumber == null ? "(null)" : this.itemLineNumber.toString()) + ": [" + this.itemTypeCode + "] Unit:" + (this.itemUnitPrice == null ? "(null)" : this.itemUnitPrice.toString()) + " Tax:" + (this.itemSalesTaxAmount == null ? "(null)" : this.itemSalesTaxAmount.toString()) + " *" + this.itemDescription + "*";
    }
}

