/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.dataaccess.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.kuali.kfs.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderSensitiveData;
import org.kuali.kfs.module.purap.businessobject.SensitiveData;
import org.kuali.kfs.module.purap.businessobject.SensitiveDataAssignment;
import org.kuali.kfs.module.purap.dataaccess.SensitiveDataDao;

public class SensitiveDataDaoOjb
extends PlatformAwareDaoBaseOjb
implements SensitiveDataDao {
    private static final Logger LOG = LogManager.getLogger();

    @Override
    public List<SensitiveData> getSensitiveDatasAssignedByPoId(Integer poId) {
        LOG.debug("getSensitiveDatasAssignedByPoId(Integer) started");
        Criteria criteria = new Criteria();
        criteria.addEqualTo("purapDocumentIdentifier", (Object)poId);
        Collection posdColl = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(PurchaseOrderSensitiveData.class, criteria));
        ArrayList<SensitiveData> sdList = new ArrayList<SensitiveData>();
        for (PurchaseOrderSensitiveData posd : posdColl) {
            sdList.add(posd.getSensitiveData());
        }
        return sdList;
    }

    @Override
    public List<SensitiveData> getSensitiveDatasAssignedByReqId(Integer reqId) {
        LOG.debug("getSensitiveDatasAssignedByReqId(Integer) started");
        Criteria criteria = new Criteria();
        criteria.addEqualTo("requisitionIdentifier", (Object)reqId);
        Collection posdColl = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(PurchaseOrderSensitiveData.class, criteria));
        ArrayList<SensitiveData> sdList = new ArrayList<SensitiveData>();
        for (PurchaseOrderSensitiveData posd : posdColl) {
            sdList.add(posd.getSensitiveData());
        }
        return sdList;
    }

    @Override
    public void deletePurchaseOrderSensitiveDatas(Integer poId) {
        LOG.debug("deletePurchaseOrderSensitiveDatas(Integer) started");
        Criteria criteria = new Criteria();
        criteria.addEqualTo("purapDocumentIdentifier", (Object)poId);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)new QueryByCriteria(PurchaseOrderSensitiveData.class, criteria));
    }

    @Override
    public SensitiveDataAssignment getLastSensitiveDataAssignment(Integer poId) {
        LOG.debug("getLastSensitiveDataAssignment(Integer) started");
        Criteria criteria = new Criteria();
        criteria.addEqualTo("purapDocumentIdentifier", (Object)poId);
        Collection sdaColl = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(SensitiveDataAssignment.class, criteria));
        int max = 0;
        SensitiveDataAssignment lastsda = null;
        for (SensitiveDataAssignment sda : sdaColl) {
            if (sda.getSensitiveDataAssignmentIdentifier() < max) continue;
            max = sda.getSensitiveDataAssignmentIdentifier();
            lastsda = sda;
        }
        return lastsda;
    }
}

