/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service.impl;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kew.actionrequest.ActionRequest;
import org.kuali.kfs.kew.api.KewApiServiceLocator;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kew.api.action.WorkflowDocumentActionsService;
import org.kuali.kfs.kew.api.document.WorkflowDocumentService;
import org.kuali.kfs.kew.engine.node.RouteNodeInstance;
import org.kuali.kfs.kew.engine.simulation.SimulationCriteria;
import org.kuali.kfs.kim.api.identity.PersonService;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.service.PurApWorkflowIntegrationService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class PurApWorkflowIntegrationServiceImpl
implements PurApWorkflowIntegrationService {
    private static final Logger LOG = LogManager.getLogger();
    private WorkflowDocumentService workflowDocumentService;
    private PersonService personService;
    private WorkflowDocumentActionsService workflowDocumentActionsService;

    public void setWorkflowDocumentService(WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }

    @Override
    public void takeAllActionsForGivenCriteria(Document document, String potentialAnnotation, String nodeName, Person userToCheck) {
        String documentNumber = document.getDocumentNumber();
        String networkIdString = ObjectUtils.isNotNull((Object)userToCheck) ? userToCheck.getPrincipalName() : "none";
        List<ActionRequest> activeActionRequests = this.getActiveActionRequestsForCriteria(documentNumber, nodeName, userToCheck);
        if (activeActionRequests.isEmpty()) {
            LOG.debug("takeAllActionsForGivenCriteria(...) - No action requests found on document id {} for given criteria:  principalName={}; nodeName={}", (Object)documentNumber, (Object)networkIdString, (Object)nodeName);
            return;
        }
        if (ObjectUtils.isNotNull((Object)userToCheck)) {
            WorkflowDocument workflowDocument = this.workflowDocumentService.loadWorkflowDocument(documentNumber, userToCheck);
            boolean containsFyiRequest = false;
            boolean containsAckRequest = false;
            boolean containsApproveRequest = false;
            boolean containsCompleteRequest = false;
            if (StringUtils.isBlank((CharSequence)nodeName)) {
                containsCompleteRequest = workflowDocument.isCompletionRequested();
                containsApproveRequest = workflowDocument.isApprovalRequested();
                containsAckRequest = workflowDocument.isAcknowledgeRequested();
                containsFyiRequest = workflowDocument.isFYIRequested();
            } else {
                for (ActionRequest actionRequest : activeActionRequests) {
                    containsFyiRequest |= actionRequest.isFYIRequest();
                    containsAckRequest |= actionRequest.isAcknowledgeRequest();
                    containsApproveRequest |= actionRequest.isApproveRequest();
                    containsCompleteRequest |= actionRequest.isCompleteRequest();
                }
            }
            if (containsCompleteRequest || containsApproveRequest) {
                this.workflowDocumentService.approve(workflowDocument, potentialAnnotation, new ArrayList());
            } else if (containsAckRequest) {
                this.workflowDocumentService.acknowledge(workflowDocument, potentialAnnotation, new ArrayList());
            } else if (containsFyiRequest) {
                this.workflowDocumentService.clearFyi(workflowDocument, new ArrayList());
            }
        } else {
            String errorMessage = "No user to check given.";
            LOG.error(errorMessage);
            throw new RuntimeException(errorMessage);
        }
    }

    protected List<ActionRequest> getActiveActionRequestsForCriteria(String documentNumber, String nodeName, Person user) {
        WorkflowDocumentService workflowDocService = KewApiServiceLocator.getWorkflowDocumentService();
        List actionRequests = workflowDocService.getActionRequestsForPrincipalAtNode(documentNumber, nodeName, user.getPrincipalId());
        ArrayList<ActionRequest> activeRequests = new ArrayList<ActionRequest>();
        for (ActionRequest actionRequest : actionRequests) {
            if (!actionRequest.isActive()) continue;
            activeRequests.add(actionRequest);
        }
        return activeRequests;
    }

    @Override
    public boolean willDocumentStopAtGivenFutureRouteNode(PurchasingAccountsPayableDocument document, String givenNodeName) {
        if (givenNodeName == null) {
            throw new InvalidParameterException("Given Node Detail object was null");
        }
        try {
            String[] nodeNames;
            String activeNode = null;
            Set currentNodes = document.getDocumentHeader().getWorkflowDocument().getCurrentNodeNames();
            if (CollectionUtils.isNotEmpty((Collection)currentNodes) && (nodeNames = currentNodes.toArray(new String[0])).length == 1) {
                activeNode = nodeNames[0];
            }
            if (this.isGivenNodeAfterCurrentNode((Document)document, activeNode, givenNodeName)) {
                SimulationCriteria criteria;
                if (document.getDocumentHeader().getWorkflowDocument().isInitiated()) {
                    criteria = SimulationCriteria.createSimulationCritUsingDocTypeName((String)document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
                    criteria.setRoutingUser(GlobalVariables.getUserSession().getPerson());
                    criteria.setDestinationNodeName(givenNodeName);
                    return this.workflowDocumentActionsService.documentWillHaveAtLeastOneActionRequest(criteria, Arrays.asList("A", "C"), false);
                }
                criteria = SimulationCriteria.createSimulationCritUsingDocumentId((String)document.getDocumentNumber());
                criteria.setDestinationNodeName(givenNodeName);
                return this.workflowDocumentActionsService.documentWillHaveAtLeastOneActionRequest(criteria, Arrays.asList("A", "C"), false);
            }
            return false;
        }
        catch (Exception e) {
            String errorMessage = "Error trying to test document id '" + document.getDocumentNumber() + "' for action requests at node name '" + givenNodeName + "'";
            LOG.error("isDocumentStoppingAtRouteLevel() {}", (Object)errorMessage, (Object)e);
            throw new RuntimeException(errorMessage, e);
        }
    }

    protected boolean isGivenNodeAfterCurrentNode(Document document, String currentNodeName, String givenNodeName) {
        if (ObjectUtils.isNull((Object)givenNodeName)) {
            return false;
        }
        if (ObjectUtils.isNull((Object)currentNodeName)) {
            return true;
        }
        List routeNodes = KewApiServiceLocator.getWorkflowDocumentService().getRouteNodeInstances(document.getDocumentNumber());
        int currentNodeIndex = 0;
        int givenNodeIndex = 0;
        for (int i = 0; i < routeNodes.size(); ++i) {
            RouteNodeInstance node = (RouteNodeInstance)routeNodes.get(i);
            if (node.getName().equals(currentNodeName)) {
                currentNodeIndex = i;
            }
            if (!node.getName().equals(givenNodeName)) continue;
            givenNodeIndex = i;
        }
        return givenNodeIndex > currentNodeIndex;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setWorkflowDocumentActionsService(WorkflowDocumentActionsService workflowDocumentActionsService) {
        this.workflowDocumentActionsService = workflowDocumentActionsService;
    }
}

