/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.coa.service.ChartService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.ReceivingThreshold;
import org.kuali.kfs.module.purap.util.ThresholdField;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.vnd.VendorUtils;
import org.kuali.kfs.vnd.businessobject.VendorDetail;

public class ThresholdRule
extends MaintenanceDocumentRuleBase {
    protected ChartService chartService = (ChartService)SpringContext.getBean(ChartService.class);
    protected AccountService accountService = (AccountService)SpringContext.getBean(AccountService.class);
    protected ReceivingThreshold newThreshold;
    protected ReceivingThreshold oldThreshold;

    protected boolean isValidDocument(ReceivingThreshold newThreshold, boolean checkDuplicate) {
        boolean valid = this.isValidThresholdCriteria(newThreshold);
        if (valid) {
            valid = this.isValidVendorNumber(newThreshold);
            if (valid && checkDuplicate) {
                valid = !this.isDuplicateEntry(newThreshold);
            }
        } else {
            this.constructFieldError(newThreshold);
        }
        return valid;
    }

    protected void constructFieldError(ReceivingThreshold threshold) {
        if (StringUtils.isNotBlank((CharSequence)threshold.getAccountTypeCode())) {
            this.putFieldError(ThresholdField.ACCOUNT_TYPE_CODE.getName(), "errors.threshold.criteria.invalid");
        }
        if (StringUtils.isNotBlank((CharSequence)threshold.getSubFundGroupCode())) {
            this.putFieldError(ThresholdField.SUBFUND_GROUP_CODE.getName(), "errors.threshold.criteria.invalid");
        }
        if (StringUtils.isNotBlank((CharSequence)threshold.getPurchasingCommodityCode())) {
            this.putFieldError(ThresholdField.COMMODITY_CODE.getName(), "errors.threshold.criteria.invalid");
        }
        if (StringUtils.isNotBlank((CharSequence)threshold.getFinancialObjectCode())) {
            this.putFieldError(ThresholdField.FINANCIAL_OBJECT_CODE.getName(), "errors.threshold.criteria.invalid");
        }
        if (StringUtils.isNotBlank((CharSequence)threshold.getOrganizationCode())) {
            this.putFieldError(ThresholdField.ORGANIZATION_CODE.getName(), "errors.threshold.criteria.invalid");
        }
        if (StringUtils.isNotBlank((CharSequence)threshold.getVendorNumber())) {
            this.putFieldError(ThresholdField.VENDOR_NUMBER.getName(), "errors.threshold.criteria.invalid");
        }
    }

    protected boolean isValidVendorNumber(ReceivingThreshold threshold) {
        if (StringUtils.isNotBlank((CharSequence)threshold.getVendorNumber())) {
            String vendorNumber = threshold.getVendorNumber();
            if (StringUtils.isNotBlank((CharSequence)vendorNumber)) {
                HashMap<String, Integer> keys = new HashMap<String, Integer>();
                Integer headerId = VendorUtils.getVendorHeaderId((String)vendorNumber);
                Integer detailId = VendorUtils.getVendorDetailId((String)vendorNumber);
                keys.put("vendorHeaderGeneratedIdentifier", headerId);
                keys.put("vendorDetailAssignedIdentifier", detailId);
                VendorDetail vendorDetail = (VendorDetail)this.getBoService().findByPrimaryKey(VendorDetail.class, keys);
                if (ObjectUtils.isNull((Object)vendorDetail)) {
                    this.putFieldError("vendorNumber", "errors.threshold.field.invalid", "Vendor Number " + vendorNumber);
                    return false;
                }
                VendorDetail vendor = threshold.getVendorDetail();
                vendor.setVendorHeaderGeneratedIdentifier(headerId);
                vendor.setVendorDetailAssignedIdentifier(detailId);
            }
            return true;
        }
        return true;
    }

    protected boolean isValidThresholdCriteria(ReceivingThreshold threshold) {
        if (StringUtils.isBlank((CharSequence)threshold.getAccountTypeCode()) && StringUtils.isBlank((CharSequence)threshold.getSubFundGroupCode()) && StringUtils.isBlank((CharSequence)threshold.getPurchasingCommodityCode()) && StringUtils.isBlank((CharSequence)threshold.getFinancialObjectCode()) && StringUtils.isBlank((CharSequence)threshold.getOrganizationCode()) && StringUtils.isBlank((CharSequence)threshold.getVendorNumber())) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)threshold.getAccountTypeCode()) && StringUtils.isBlank((CharSequence)threshold.getSubFundGroupCode()) && StringUtils.isBlank((CharSequence)threshold.getPurchasingCommodityCode()) && StringUtils.isBlank((CharSequence)threshold.getFinancialObjectCode()) && StringUtils.isBlank((CharSequence)threshold.getOrganizationCode()) && StringUtils.isBlank((CharSequence)threshold.getVendorNumber())) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)threshold.getAccountTypeCode()) && StringUtils.isNotBlank((CharSequence)threshold.getSubFundGroupCode()) && StringUtils.isBlank((CharSequence)threshold.getPurchasingCommodityCode()) && StringUtils.isBlank((CharSequence)threshold.getFinancialObjectCode()) && StringUtils.isBlank((CharSequence)threshold.getOrganizationCode()) && StringUtils.isBlank((CharSequence)threshold.getVendorNumber())) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)threshold.getAccountTypeCode()) && StringUtils.isBlank((CharSequence)threshold.getSubFundGroupCode()) && StringUtils.isNotBlank((CharSequence)threshold.getPurchasingCommodityCode()) && StringUtils.isBlank((CharSequence)threshold.getFinancialObjectCode()) && StringUtils.isBlank((CharSequence)threshold.getOrganizationCode()) && StringUtils.isBlank((CharSequence)threshold.getVendorNumber())) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)threshold.getAccountTypeCode()) && StringUtils.isBlank((CharSequence)threshold.getSubFundGroupCode()) && StringUtils.isBlank((CharSequence)threshold.getPurchasingCommodityCode()) && StringUtils.isNotBlank((CharSequence)threshold.getFinancialObjectCode()) && StringUtils.isBlank((CharSequence)threshold.getOrganizationCode()) && StringUtils.isBlank((CharSequence)threshold.getVendorNumber())) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)threshold.getAccountTypeCode()) && StringUtils.isBlank((CharSequence)threshold.getSubFundGroupCode()) && StringUtils.isBlank((CharSequence)threshold.getPurchasingCommodityCode()) && StringUtils.isBlank((CharSequence)threshold.getFinancialObjectCode()) && StringUtils.isNotBlank((CharSequence)threshold.getOrganizationCode()) && StringUtils.isBlank((CharSequence)threshold.getVendorNumber())) {
            return true;
        }
        return StringUtils.isBlank((CharSequence)threshold.getAccountTypeCode()) && StringUtils.isBlank((CharSequence)threshold.getSubFundGroupCode()) && StringUtils.isBlank((CharSequence)threshold.getPurchasingCommodityCode()) && StringUtils.isBlank((CharSequence)threshold.getFinancialObjectCode()) && StringUtils.isBlank((CharSequence)threshold.getOrganizationCode()) && StringUtils.isNotBlank((CharSequence)threshold.getVendorNumber());
    }

    protected boolean isDuplicateEntry(ReceivingThreshold newThreshold) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put(ThresholdField.CHART_OF_ACCOUNTS_CODE.getName(), newThreshold.getChartOfAccountsCode());
        if (StringUtils.isNotBlank((CharSequence)newThreshold.getAccountTypeCode())) {
            fieldValues.put(ThresholdField.ACCOUNT_TYPE_CODE.getName(), newThreshold.getAccountTypeCode());
        } else if (StringUtils.isNotBlank((CharSequence)newThreshold.getSubFundGroupCode())) {
            fieldValues.put(ThresholdField.SUBFUND_GROUP_CODE.getName(), newThreshold.getSubFundGroupCode());
        } else if (StringUtils.isNotBlank((CharSequence)newThreshold.getPurchasingCommodityCode())) {
            fieldValues.put(ThresholdField.COMMODITY_CODE.getName(), newThreshold.getPurchasingCommodityCode());
        } else if (StringUtils.isNotBlank((CharSequence)newThreshold.getFinancialObjectCode())) {
            fieldValues.put(ThresholdField.FINANCIAL_OBJECT_CODE.getName(), newThreshold.getFinancialObjectCode());
        } else if (StringUtils.isNotBlank((CharSequence)newThreshold.getOrganizationCode())) {
            fieldValues.put(ThresholdField.ORGANIZATION_CODE.getName(), newThreshold.getOrganizationCode());
        } else if (StringUtils.isNotBlank((CharSequence)newThreshold.getVendorNumber())) {
            fieldValues.put(ThresholdField.VENDOR_HEADER_GENERATED_ID.getName(), newThreshold.getVendorHeaderGeneratedIdentifier());
            fieldValues.put(ThresholdField.VENDOR_DETAIL_ASSIGNED_ID.getName(), newThreshold.getVendorDetailAssignedIdentifier());
        }
        Collection result = this.getBoService().findMatching(ReceivingThreshold.class, fieldValues);
        if (result != null && result.size() > 0) {
            this.putGlobalError("error.document.purap.potentialDuplicate");
            return true;
        }
        return false;
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        boolean valid = true;
        if (document.isNew() || document.isEdit() || document.isNewWithExisting()) {
            this.newThreshold = (ReceivingThreshold)document.getNewMaintainableObject().getBusinessObject();
            this.oldThreshold = document.getOldMaintainableObject() != null ? (ReceivingThreshold)document.getOldMaintainableObject().getBusinessObject() : null;
            boolean checkDuplicate = this.oldThreshold == null;
            checkDuplicate |= !StringUtils.equals((CharSequence)this.newThreshold.getChartOfAccountsCode(), (CharSequence)this.oldThreshold.getChartOfAccountsCode());
            checkDuplicate |= !StringUtils.equals((CharSequence)this.newThreshold.getAccountTypeCode(), (CharSequence)this.oldThreshold.getAccountTypeCode());
            checkDuplicate |= !StringUtils.equals((CharSequence)this.newThreshold.getSubFundGroupCode(), (CharSequence)this.oldThreshold.getSubFundGroupCode());
            checkDuplicate |= !StringUtils.equals((CharSequence)this.newThreshold.getPurchasingCommodityCode(), (CharSequence)this.oldThreshold.getPurchasingCommodityCode());
            checkDuplicate |= !StringUtils.equals((CharSequence)this.newThreshold.getFinancialObjectCode(), (CharSequence)this.oldThreshold.getFinancialObjectCode());
            checkDuplicate |= !StringUtils.equals((CharSequence)this.newThreshold.getOrganizationCode(), (CharSequence)this.oldThreshold.getOrganizationCode());
            valid = this.isValidDocument(this.newThreshold, checkDuplicate |= !StringUtils.equals((CharSequence)this.newThreshold.getVendorNumber(), (CharSequence)this.oldThreshold.getVendorNumber()));
        }
        return valid && super.processCustomRouteDocumentBusinessRules(document);
    }
}

