/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.identity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kim.api.role.RoleService;
import org.kuali.kfs.kns.kim.role.DerivedRoleTypeServiceBase;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.purap.document.AccountsPayableDocument;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;

public class AccountsPayableDocumentDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase {
    private static final Logger LOG = LogManager.getLogger();
    private DocumentService documentService;
    private RoleService roleService;

    public boolean hasDerivedRole(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        String docId = qualification.get("documentNumber");
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add(this.roleService.getRoleIdByNamespaceCodeAndName("KFS-SYS", "Fiscal Officer"));
        roleIds.add(this.roleService.getRoleIdByNamespaceCodeAndName("KFS-PURAP", "Sub-Account Reviewer"));
        roleIds.add(this.roleService.getRoleIdByNamespaceCodeAndName("KFS-SYS", "Accounting Reviewer"));
        AccountsPayableDocument apDocument = (AccountsPayableDocument)this.documentService.getByDocumentHeaderId(docId);
        for (Object line : apDocument.getSourceAccountingLines()) {
            SourceAccountingLine accountingLine = (SourceAccountingLine)line;
            HashMap<String, String> roleQualifier = new HashMap<String, String>();
            roleQualifier.put("documentTypeName", apDocument.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
            roleQualifier.put("financialDocumentTotalAmount", apDocument.getDocumentHeader().getFinancialDocumentTotalAmount().toString());
            roleQualifier.put("chartOfAccountsCode", accountingLine.getChartOfAccountsCode());
            roleQualifier.put("organizationCode", accountingLine.getAccount().getOrganizationCode());
            roleQualifier.put("accountNumber", accountingLine.getAccountNumber());
            roleQualifier.put("subAccountNumber", accountingLine.getSubAccountNumber());
            roleQualifier.put("accountingLineOverrideCode", accountingLine.getOverrideCode());
            if (!this.roleService.principalHasRole(principalId, roleIds, roleQualifier)) continue;
            return true;
        }
        return false;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setRoleService(RoleService roleService) {
        this.roleService = roleService;
    }
}

