/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoice;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceItem;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceItemMapping;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceOrder;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoicePostalAddress;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceRejectItem;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceRejectReason;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.ElectronicInvoiceRejectDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.service.impl.ElectronicInvoiceItemHolder;
import org.kuali.kfs.module.purap.util.ElectronicInvoiceUtils;
import org.kuali.kfs.sys.context.SpringContext;

public class ElectronicInvoiceOrderHolder {
    private static final Logger LOG = LogManager.getLogger();
    private ElectronicInvoiceRejectDocument rejectDocument;
    private ElectronicInvoiceOrder invoiceOrder;
    private ElectronicInvoice eInvoice;
    private PurchaseOrderDocument poDocument;
    private Map<String, ElectronicInvoiceItemMapping> itemTypeMappings;
    private Map<String, ItemType> kualiItemTypes;
    private Map<String, FieldErrorHelper> errorFieldDetails = new HashMap<String, FieldErrorHelper>();
    private List<ElectronicInvoiceItemHolder> items = new ArrayList<ElectronicInvoiceItemHolder>();
    private boolean isRejected = false;
    private boolean isRejectDocumentHolder;
    private boolean validateHeader;
    private String[] summaryRejectCodes = new String[]{"TSAM", "SHSA", "SSAM", "DSAM"};

    public ElectronicInvoiceOrderHolder(ElectronicInvoiceRejectDocument rejectDocument, Map itemTypeMappings, Map itemTypes) {
        if (rejectDocument == null) {
            throw new NullPointerException("ElectronicInvoiceRejectDocument should not be null");
        }
        this.rejectDocument = rejectDocument;
        this.itemTypeMappings = itemTypeMappings;
        this.poDocument = rejectDocument.getCurrentPurchaseOrderDocument();
        this.kualiItemTypes = itemTypes;
        this.isRejectDocumentHolder = true;
        this.validateHeader = true;
        rejectDocument.getInvoiceRejectItems().forEach(invoiceRejectItem -> {
            if (this.poDocument != null && invoiceRejectItem != null) {
                PurApItem poItem = this.poDocument.getItemByLineNumber(invoiceRejectItem.getInvoiceReferenceItemLineNumber());
                this.items.add(new ElectronicInvoiceItemHolder((ElectronicInvoiceRejectItem)((Object)invoiceRejectItem), itemTypeMappings, (PurchaseOrderItem)poItem, this));
            } else {
                this.items.add(new ElectronicInvoiceItemHolder((ElectronicInvoiceRejectItem)((Object)invoiceRejectItem), itemTypeMappings, null, this));
            }
        });
        this.retainSummaryRejects(rejectDocument);
    }

    public ElectronicInvoiceOrderHolder(ElectronicInvoice eInvoice, ElectronicInvoiceOrder invoiceOrder, PurchaseOrderDocument poDocument, Map itemTypeMappings, Map itemTypes, boolean validateHeader) {
        if (eInvoice == null) {
            throw new NullPointerException("ElectronicInvoice should not be null");
        }
        if (invoiceOrder == null) {
            throw new NullPointerException("ElectronicInvoiceOrder should not be null");
        }
        this.eInvoice = eInvoice;
        this.invoiceOrder = invoiceOrder;
        this.itemTypeMappings = itemTypeMappings;
        this.validateHeader = validateHeader;
        this.kualiItemTypes = itemTypes;
        this.poDocument = poDocument;
        this.isRejectDocumentHolder = false;
        invoiceOrder.getInvoiceItems().forEach(orderItem -> {
            if (poDocument != null && orderItem != null) {
                PurApItem poItem = poDocument.getItemByLineNumber(orderItem.getReferenceLineNumberInteger());
                this.items.add(new ElectronicInvoiceItemHolder((ElectronicInvoiceItem)orderItem, itemTypeMappings, (PurchaseOrderItem)poItem, this));
            } else {
                this.items.add(new ElectronicInvoiceItemHolder((ElectronicInvoiceItem)orderItem, itemTypeMappings, null, this));
            }
        });
    }

    protected void retainSummaryRejects(ElectronicInvoiceRejectDocument rejectDocument) {
        LOG.info("Searching for summary rejects");
        ArrayList<ElectronicInvoiceRejectReason> retainList = new ArrayList<ElectronicInvoiceRejectReason>();
        List<ElectronicInvoiceRejectReason> rejectReasons = rejectDocument.getInvoiceRejectReasons();
        for (ElectronicInvoiceRejectReason rejectReason : rejectReasons) {
            if (!ArrayUtils.contains((Object[])this.summaryRejectCodes, (Object)rejectReason.getInvoiceRejectReasonTypeCode())) continue;
            retainList.add(rejectReason);
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = rejectReason::getInvoiceRejectReasonTypeCode;
            supplierArray[1] = rejectReason::getInvoiceRejectReasonDescription;
            LOG.info("Retaining Reject [Code={},Desc={}", supplierArray);
        }
        if (retainList.size() == 0) {
            LOG.info("No summary rejects found");
        }
        rejectDocument.getInvoiceRejectReasons().clear();
        for (ElectronicInvoiceRejectReason aRetainList : retainList) {
            rejectDocument.addRejectReason(aRetainList);
        }
    }

    public String getFileName() {
        if (this.isRejectDocumentHolder()) {
            return this.rejectDocument.getInvoiceFileName();
        }
        return this.eInvoice.getFileName();
    }

    public String getDunsNumber() {
        if (this.isRejectDocumentHolder()) {
            return this.rejectDocument.getVendorDunsNumber();
        }
        return this.eInvoice.getDunsNumber();
    }

    public String getCustomerNumber() {
        if (this.isRejectDocumentHolder()) {
            return this.rejectDocument.getInvoiceCustomerNumber();
        }
        return this.eInvoice.getCustomerNumber();
    }

    public Integer getVendorHeaderId() {
        if (this.isRejectDocumentHolder()) {
            return this.rejectDocument.getVendorHeaderGeneratedIdentifier();
        }
        return this.eInvoice.getVendorHeaderID();
    }

    public Integer getVendorDetailId() {
        if (this.isRejectDocumentHolder()) {
            return this.rejectDocument.getVendorDetailAssignedIdentifier();
        }
        return this.eInvoice.getVendorDetailID();
    }

    public String getVendorName() {
        if (this.isRejectDocumentHolder()) {
            if (this.rejectDocument.getVendorDetail() != null) {
                return this.rejectDocument.getVendorDetail().getVendorName();
            }
            return "";
        }
        return this.eInvoice.getVendorName();
    }

    public String getInvoiceNumber() {
        if (this.isRejectDocumentHolder()) {
            return this.rejectDocument.getInvoiceFileNumber();
        }
        return this.eInvoice.getInvoiceDetailRequestHeader().getInvoiceId();
    }

    public Date getInvoiceDate() {
        if (this.isRejectDocumentHolder()) {
            return ElectronicInvoiceUtils.getDate(this.rejectDocument.getInvoiceFileDate());
        }
        return this.eInvoice.getInvoiceDetailRequestHeader().getInvoiceDate();
    }

    public String getInvoiceDateString() {
        if (this.isRejectDocumentHolder()) {
            return this.rejectDocument.getInvoiceFileDate();
        }
        return this.eInvoice.getInvoiceDetailRequestHeader().getInvoiceDateString();
    }

    public boolean isInformationOnly() {
        if (this.isRejectDocumentHolder()) {
            return this.rejectDocument.isInvoiceFileInformationOnlyIndicator();
        }
        return this.eInvoice.getInvoiceDetailRequestHeader().isInformationOnly();
    }

    public String getInvoicePurchaseOrderID() {
        if (this.isRejectDocumentHolder()) {
            return this.rejectDocument.getInvoicePurchaseOrderNumber();
        }
        return this.invoiceOrder.getOrderReferenceOrderID();
    }

    public boolean isTaxInLine() {
        if (this.isRejectDocumentHolder()) {
            return this.rejectDocument.isInvoiceFileTaxInLineIndicator();
        }
        return this.eInvoice.getInvoiceDetailRequestHeader().isTaxInLine();
    }

    public BigDecimal getTaxAmount() {
        if (this.isRejectDocumentHolder()) {
            return this.rejectDocument.getInvoiceItemTaxAmount();
        }
        return this.eInvoice.getInvoiceTaxAmount(this.invoiceOrder);
    }

    public String getTaxDescription() {
        if (this.isRejectDocumentHolder()) {
            return this.rejectDocument.getInvoiceItemTaxDescription();
        }
        return this.eInvoice.getInvoiceTaxDescription(this.invoiceOrder);
    }

    public boolean isSpecialHandlingInLine() {
        if (this.isRejectDocumentHolder()) {
            return this.rejectDocument.isInvoiceFileSpecialHandlingInLineIndicator();
        }
        return this.eInvoice.getInvoiceDetailRequestHeader().isSpecialHandlingInLine();
    }

    public BigDecimal getInvoiceSpecialHandlingAmount() {
        if (this.isRejectDocumentHolder()) {
            return this.rejectDocument.getInvoiceItemSpecialHandlingAmount();
        }
        return this.eInvoice.getInvoiceSpecialHandlingAmount(this.invoiceOrder);
    }

    public String getInvoiceSpecialHandlingDescription() {
        if (this.isRejectDocumentHolder()) {
            return this.rejectDocument.getInvoiceItemSpecialHandlingDescription();
        }
        return this.eInvoice.getInvoiceSpecialHandlingDescription(this.invoiceOrder);
    }

    public boolean isShippingInLine() {
        if (this.isRejectDocumentHolder()) {
            return this.rejectDocument.isInvoiceFileShippingInLineIndicator();
        }
        return this.eInvoice.getInvoiceDetailRequestHeader().isShippingInLine();
    }

    public BigDecimal getInvoiceShippingAmount() {
        if (this.isRejectDocumentHolder()) {
            return this.rejectDocument.getInvoiceItemShippingAmount();
        }
        return this.eInvoice.getInvoiceShippingAmount(this.invoiceOrder);
    }

    public String getInvoiceShippingDescription() {
        if (this.isRejectDocumentHolder()) {
            return this.rejectDocument.getInvoiceItemShippingDescription();
        }
        return this.eInvoice.getInvoiceShippingDescription(this.invoiceOrder);
    }

    public boolean isDiscountInLine() {
        if (this.isRejectDocumentHolder()) {
            return this.rejectDocument.isInvoiceFileDiscountInLineIndicator();
        }
        return this.eInvoice.getInvoiceDetailRequestHeader().isDiscountInLine();
    }

    public BigDecimal getInvoiceDiscountAmount() {
        if (this.isRejectDocumentHolder()) {
            return this.rejectDocument.getInvoiceItemDiscountAmount();
        }
        return this.eInvoice.getInvoiceDiscountAmount(this.invoiceOrder);
    }

    public BigDecimal getInvoiceDepositAmount() {
        if (this.isRejectDocumentHolder()) {
            throw new UnsupportedOperationException("Deposit amount not available for the reject document");
        }
        return this.eInvoice.getInvoiceDepositAmount();
    }

    public BigDecimal getInvoiceDueAmount() {
        if (this.isRejectDocumentHolder()) {
            throw new UnsupportedOperationException("Deposit amount not available for the reject document");
        }
        return this.eInvoice.getInvoiceDueAmount();
    }

    public PurchaseOrderDocument getPurchaseOrderDocument() {
        return this.poDocument;
    }

    public ElectronicInvoiceItemHolder[] getItems() {
        if (this.items != null) {
            ElectronicInvoiceItemHolder[] returnItems = new ElectronicInvoiceItemHolder[this.items.size()];
            this.items.toArray(returnItems);
            return returnItems;
        }
        return null;
    }

    public ElectronicInvoiceItemHolder getItemByLineNumber(int lineNumber) {
        if (this.items != null) {
            for (ElectronicInvoiceItemHolder itemHolder : this.items) {
                if (itemHolder.getInvoiceItemLineNumber() == null || itemHolder.getInvoiceItemLineNumber() != lineNumber) continue;
                return itemHolder;
            }
        }
        return null;
    }

    public void addInvoiceHeaderRejectReason(ElectronicInvoiceRejectReason rejectReason) {
        this.addInvoiceHeaderRejectReason(rejectReason, null, null);
    }

    public void addInvoiceHeaderRejectReason(ElectronicInvoiceRejectReason rejectReason, String fieldName, String applnResourceKey) {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = rejectReason::getInvoiceRejectReasonDescription;
        LOG.info("Adding reject reason - {}", supplierArray);
        if (this.isRejectDocumentHolder()) {
            this.rejectDocument.addRejectReason(rejectReason);
            if (fieldName != null && applnResourceKey != null) {
                GlobalVariables.getMessageMap().putError(fieldName, applnResourceKey, new String[0]);
            }
        } else {
            this.eInvoice.addFileRejectReasonToList(rejectReason);
            this.eInvoice.setFileRejected(true);
        }
    }

    public void addInvoiceOrderRejectReason(ElectronicInvoiceRejectReason rejectReason, String fieldName) {
        this.addInvoiceOrderRejectReason(rejectReason, fieldName, null);
    }

    public void addInvoiceOrderRejectReason(ElectronicInvoiceRejectReason rejectReason, String fieldName, String applnResourceKey) {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = rejectReason::getInvoiceRejectReasonDescription;
        LOG.info("Adding reject reason - {}", supplierArray);
        if (this.isRejectDocumentHolder()) {
            this.rejectDocument.addRejectReason(rejectReason);
            if (fieldName != null && applnResourceKey != null) {
                GlobalVariables.getMessageMap().putError(fieldName, applnResourceKey, new String[0]);
            }
        } else {
            this.invoiceOrder.addRejectReasonToList(rejectReason);
            this.eInvoice.setFileRejected(true);
        }
    }

    public void addInvoiceOrderRejectReason(ElectronicInvoiceRejectReason rejectReason) {
        this.addInvoiceOrderRejectReason(rejectReason, null, null);
    }

    public boolean isValidateHeaderInformation() {
        return this.validateHeader;
    }

    public boolean isRejectDocumentHolder() {
        return this.isRejectDocumentHolder;
    }

    public ElectronicInvoiceItemMapping getInvoiceItemMapping(String invoiceItemTypeCode) {
        if (this.itemTypeMappings == null) {
            return null;
        }
        return this.itemTypeMappings.get(invoiceItemTypeCode);
    }

    public boolean isItemTypeAvailableInItemMapping(String invoiceItemTypeCode) {
        if (this.itemTypeMappings == null) {
            return false;
        }
        return this.itemTypeMappings.containsKey(invoiceItemTypeCode);
    }

    public boolean isInvoiceRejected() {
        if (this.isRejectDocumentHolder()) {
            return this.rejectDocument.getInvoiceRejectReasons() != null && this.rejectDocument.getInvoiceRejectReasons().size() > 0;
        }
        return this.eInvoice.isFileRejected();
    }

    public String getKualiItemTypeCodeFromMappings(String invoiceItemTypeCode) {
        ElectronicInvoiceItemMapping itemMapping = this.getInvoiceItemMapping(invoiceItemTypeCode);
        if (itemMapping != null) {
            return itemMapping.getItemTypeCode();
        }
        return null;
    }

    public ElectronicInvoiceItemMapping[] getInvoiceItemTypeMappings() {
        if (this.itemTypeMappings != null) {
            ElectronicInvoiceItemMapping[] itemMappings = new ElectronicInvoiceItemMapping[this.itemTypeMappings.size()];
            this.itemTypeMappings.values().toArray(itemMappings);
            return itemMappings;
        }
        return null;
    }

    public boolean isInvoiceNumberAcceptIndicatorEnabled() {
        if (this.isRejectDocumentHolder()) {
            return this.rejectDocument.isInvoiceNumberAcceptIndicator();
        }
        return false;
    }

    public ElectronicInvoice getElectronicInvoice() {
        if (this.isRejectDocumentHolder()) {
            throw new UnsupportedOperationException("ElectronicInvoice object not available for ElectronicInvoiceRejectDocument");
        }
        return this.eInvoice;
    }

    public BigDecimal getInvoiceNetAmount() {
        if (this.isRejectDocumentHolder()) {
            return this.rejectDocument.getInvoiceItemNetAmount();
        }
        return this.eInvoice.getInvoiceNetAmount(this.invoiceOrder);
    }

    public Date getInvoiceProcessedDate() {
        DateTimeService dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
        if (this.isRejectDocumentHolder()) {
            return dateTimeService.convertToSqlDate(this.rejectDocument.getInvoiceProcessTimestamp());
        }
        return dateTimeService.getCurrentSqlDate();
    }

    public String getInvoiceShipToAddressAsString() {
        StringBuffer noteBuffer = new StringBuffer();
        noteBuffer.append("Shipping Address from Electronic Invoice:\n\n");
        if (!this.isRejectDocumentHolder()) {
            ElectronicInvoicePostalAddress shipToAddress = this.eInvoice.getCxmlPostalAddress(this.invoiceOrder, PurapConstants.ElectronicInvoice.CXML_ADDRESS_SHIP_TO_ROLE_ID, PurapConstants.ElectronicInvoice.CXML_ADDRESS_SHIP_TO_NAME);
            if (shipToAddress != null) {
                if (StringUtils.isNotEmpty((CharSequence)shipToAddress.getName())) {
                    noteBuffer.append(shipToAddress.getName()).append("\n");
                }
                noteBuffer.append(shipToAddress.getLine1()).append("\n");
                if (StringUtils.isNotEmpty((CharSequence)shipToAddress.getLine2())) {
                    noteBuffer.append(shipToAddress.getLine2()).append("\n");
                }
                if (StringUtils.isNotEmpty((CharSequence)shipToAddress.getLine3())) {
                    noteBuffer.append(shipToAddress.getLine3()).append("\n");
                }
                noteBuffer.append(shipToAddress.getCityName()).append(", ").append(shipToAddress.getStateCode()).append(" ").append(shipToAddress.getPostalCode()).append("\n");
                noteBuffer.append(shipToAddress.getCountryName());
            }
        } else {
            if (StringUtils.isNotEmpty((CharSequence)this.rejectDocument.getInvoiceShipToAddressName())) {
                noteBuffer.append(this.rejectDocument.getInvoiceShipToAddressName()).append("\n");
            }
            noteBuffer.append(this.rejectDocument.getInvoiceShipToAddressLine1()).append("\n");
            if (StringUtils.isNotEmpty((CharSequence)this.rejectDocument.getInvoiceShipToAddressLine2())) {
                noteBuffer.append(this.rejectDocument.getInvoiceShipToAddressLine2()).append("\n");
            }
            if (StringUtils.isNotEmpty((CharSequence)this.rejectDocument.getInvoiceShipToAddressLine3())) {
                noteBuffer.append(this.rejectDocument.getInvoiceShipToAddressLine3()).append("\n");
            }
            noteBuffer.append(this.rejectDocument.getInvoiceShipToAddressCityName()).append(", ").append(this.rejectDocument.getInvoiceShipToAddressStateCode()).append(" ").append(this.rejectDocument.getInvoiceShipToAddressPostalCode()).append("\n");
            noteBuffer.append(this.rejectDocument.getInvoiceShipToAddressCountryName());
        }
        return noteBuffer.toString();
    }

    public String getInvoiceBillToAddressAsString() {
        StringBuffer noteBuffer = new StringBuffer();
        noteBuffer.append("Billing Address from Electronic Invoice:\n\n");
        if (!this.isRejectDocumentHolder()) {
            ElectronicInvoicePostalAddress billToAddress = this.eInvoice.getCxmlPostalAddress(this.invoiceOrder, PurapConstants.ElectronicInvoice.CXML_ADDRESS_BILL_TO_ROLE_ID, PurapConstants.ElectronicInvoice.CXML_ADDRESS_BILL_TO_NAME);
            if (billToAddress != null) {
                if (StringUtils.isNotEmpty((CharSequence)billToAddress.getName())) {
                    noteBuffer.append(billToAddress.getName()).append("\n");
                }
                noteBuffer.append(billToAddress.getLine1()).append("\n");
                if (StringUtils.isNotEmpty((CharSequence)billToAddress.getLine2())) {
                    noteBuffer.append(billToAddress.getLine2()).append("\n");
                }
                if (StringUtils.isNotEmpty((CharSequence)billToAddress.getLine3())) {
                    noteBuffer.append(billToAddress.getLine3()).append("\n");
                }
                noteBuffer.append(billToAddress.getCityName()).append(", ").append(billToAddress.getStateCode()).append(" ").append(billToAddress.getPostalCode()).append("\n");
                noteBuffer.append(billToAddress.getCountryName());
            }
        } else {
            if (StringUtils.isNotEmpty((CharSequence)this.rejectDocument.getInvoiceBillToAddressName())) {
                noteBuffer.append(this.rejectDocument.getInvoiceBillToAddressName()).append("\n");
            }
            noteBuffer.append(this.rejectDocument.getInvoiceBillToAddressLine1()).append("\n");
            if (StringUtils.isNotEmpty((CharSequence)this.rejectDocument.getInvoiceBillToAddressLine2())) {
                noteBuffer.append(this.rejectDocument.getInvoiceBillToAddressLine2()).append("\n");
            }
            if (StringUtils.isNotEmpty((CharSequence)this.rejectDocument.getInvoiceBillToAddressLine3())) {
                noteBuffer.append(this.rejectDocument.getInvoiceBillToAddressLine3()).append("\n");
            }
            noteBuffer.append(this.rejectDocument.getInvoiceBillToAddressCityName()).append(", ").append(this.rejectDocument.getInvoiceBillToAddressStateCode()).append(" ").append(this.rejectDocument.getInvoiceBillToAddressPostalCode()).append("\n");
            noteBuffer.append(this.rejectDocument.getInvoiceBillToAddressCountryName());
        }
        return noteBuffer.toString();
    }

    public Integer getAccountsPayablePurchasingDocumentLinkIdentifier() {
        if (this.isRejectDocumentHolder()) {
            return this.rejectDocument.getAccountsPayablePurchasingDocumentLinkIdentifier();
        }
        if (this.poDocument != null) {
            return this.poDocument.getAccountsPayablePurchasingDocumentLinkIdentifier();
        }
        return null;
    }

    protected class FieldErrorHelper {
        private String fieldName;
        private String applicationResourceKeyName;
        private String rejectReasonTypeCode;

        FieldErrorHelper(String fieldName, String applicationResourceKeyName, String rejectReasonTypeCode) {
            if (StringUtils.isEmpty((CharSequence)fieldName) || StringUtils.isEmpty((CharSequence)applicationResourceKeyName) || StringUtils.isEmpty((CharSequence)rejectReasonTypeCode)) {
                throw new NullPointerException("Invalid field Values [fieldName=" + fieldName + ",applicationResourceKeyName=" + applicationResourceKeyName + ",rejectReasonTypeCode=" + rejectReasonTypeCode + "]");
            }
            this.fieldName = fieldName;
            this.applicationResourceKeyName = applicationResourceKeyName;
            this.rejectReasonTypeCode = rejectReasonTypeCode;
        }

        public String getApplicationResourceKeyName() {
            return this.applicationResourceKeyName;
        }

        public void setApplicationResourceKeyName(String applicationResourceKeyName) {
            this.applicationResourceKeyName = applicationResourceKeyName;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getRejectReasonTypeCode() {
            return this.rejectReasonTypeCode;
        }

        public void setRejectReasonTypeCode(String rejectReasonTypeCode) {
            this.rejectReasonTypeCode = rejectReasonTypeCode;
        }

        public String toString() {
            ToStringBuilder toString = new ToStringBuilder((Object)this);
            toString.append("fieldName", (Object)this.fieldName);
            toString.append("applicationResourceKeyName", (Object)this.applicationResourceKeyName);
            toString.append("rejectReasonTypeCode", (Object)this.rejectReasonTypeCode);
            return toString.toString();
        }
    }
}

