/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.upload.FormFile;
import org.kuali.kfs.core.web.format.FormatException;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.krad.exception.InfrastructureException;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.exception.ItemParserException;
import org.kuali.kfs.module.purap.util.ItemParser;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;

public class ItemParserBase
implements ItemParser {
    protected static final String[] DEFAULT_FORMAT = new String[]{"itemQuantity", "itemUnitOfMeasureCode", "itemCatalogNumber", "purchasingCommodityCode", "itemDescription", "itemUnitPrice"};
    protected static final String[] COMMODITY_CODE_DISABLED_FORMAT = new String[]{"itemQuantity", "itemUnitOfMeasureCode", "itemCatalogNumber", "itemDescription", "itemUnitPrice"};
    private Integer lineNo = 0;

    @Override
    public String[] getItemFormat() {
        boolean enableCommodityCode = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsBoolean(KfsParameterConstants.PURCHASING_DOCUMENT.class, "ENABLE_COMMODITY_CODE_IND");
        if (enableCommodityCode) {
            return DEFAULT_FORMAT;
        }
        return COMMODITY_CODE_DISABLED_FORMAT;
    }

    @Override
    public String getExpectedItemFormatAsString(Class<? extends PurApItem> itemClass) {
        this.checkItemClass(itemClass);
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (String attributeName : this.getItemFormat()) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append(this.getAttributeLabel(itemClass, attributeName));
        }
        return sb.toString();
    }

    protected String getAttributeLabel(Class clazz, String attributeName) {
        String label = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getAttributeLabel(clazz, attributeName);
        if (StringUtils.isBlank((CharSequence)label)) {
            label = attributeName;
        }
        return label;
    }

    protected void checkItemClass(Class<? extends PurApItem> itemClass) {
        if (!PurApItem.class.isAssignableFrom(itemClass)) {
            throw new IllegalArgumentException("unknown item class: " + itemClass);
        }
    }

    protected void checkItemFile(FormFile itemFile) {
        if (itemFile == null) {
            throw new ItemParserException("invalid (null) item import file", "error.uploadFile.null", new String[0]);
        }
        String fileName = itemFile.getFileName();
        if (StringUtils.isNotBlank((CharSequence)fileName) && !StringUtils.lowerCase((String)fileName).endsWith(".csv") && !StringUtils.lowerCase((String)fileName).endsWith(".xls")) {
            throw new ItemParserException("unsupported item import file format: " + fileName, "error.itemParser.invalidFileFormat", fileName);
        }
    }

    protected Map<String, String> retrieveItemAttributes(String itemLine) {
        String[] attributeValues;
        String[] attributeNames = this.getItemFormat();
        if (attributeNames.length != (attributeValues = StringUtils.splitPreserveAllTokens((String)itemLine, (char)',')).length) {
            String[] errorParams = new String[]{"" + attributeNames.length, "" + attributeValues.length, "" + this.lineNo};
            GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "error.itemParser.wrongPropertyNumber", errorParams);
            throw new ItemParserException("wrong number of item properties: " + attributeValues.length + " exist, " + attributeNames.length + " expected (line " + this.lineNo + ")", "error.itemParser.wrongPropertyNumber", errorParams);
        }
        HashMap<String, String> itemMap = new HashMap<String, String>();
        for (int i = 0; i < attributeNames.length; ++i) {
            itemMap.put(attributeNames[i], attributeValues[i]);
        }
        return itemMap;
    }

    protected PurApItem genItemWithRetrievedAttributes(Map<String, String> itemMap, Class<? extends PurApItem> itemClass) {
        PurApItem item;
        try {
            item = itemClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new InfrastructureException("unable to complete item line population.", (Exception)e);
        }
        boolean failed = false;
        for (Map.Entry<String, String> entry : itemMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            try {
                if (key.equals("itemUnitOfMeasureCode")) {
                    value = value.toUpperCase(Locale.US);
                }
                try {
                    ObjectUtils.setObjectProperty((Object)item, (String)key, (Object)value);
                }
                catch (FormatException e) {
                    String[] errorParams = new String[]{value, key, "" + this.lineNo};
                    throw new ItemParserException("invalid numeric property value: " + key + " = " + value + " (line " + this.lineNo + ")", "error.itemParser.invalidNumericValue", errorParams);
                }
            }
            catch (ItemParserException e) {
                GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", e.getErrorKey(), e.getErrorParameters());
                failed = true;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new InfrastructureException("unable to complete item line population.", (Exception)e);
            }
        }
        if (failed) {
            throw new ItemParserException("empty or invalid item properties in line " + this.lineNo + ")", "error.itemParser.itemProperty", "" + this.lineNo);
        }
        return item;
    }

    protected void populateExtraAttributes(PurApItem item, String documentNumber) {
        if (item.getItemQuantity() != null) {
            String paramName = "DEFAULT_QUANTITY_ITEM_TYPE";
            String itemTypeCode = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString("KFS-PURAP", "Document", paramName);
            item.setItemTypeCode(itemTypeCode);
        } else {
            String paramName = "DEFAULT_NON_QUANTITY_ITEM_TYPE";
            String itemTypeCode = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString("KFS-PURAP", "Document", paramName);
            item.setItemTypeCode(itemTypeCode);
        }
        if (item instanceof RequisitionItem) {
            ((RequisitionItem)item).setItemRestrictedIndicator(false);
        }
        if (item instanceof PurchaseOrderItem) {
            ((PurchaseOrderItem)item).setDocumentNumber(documentNumber);
        }
    }

    @Override
    public PurApItem parseItem(String itemLine, Class<? extends PurApItem> itemClass, String documentNumber) {
        Map<String, String> itemMap = this.retrieveItemAttributes(itemLine);
        PurApItem item = this.genItemWithRetrievedAttributes(itemMap, itemClass);
        this.populateExtraAttributes(item, documentNumber);
        item.refresh();
        return item;
    }

    @Override
    public List<PurApItem> importItems(FormFile itemFile, Class<? extends PurApItem> itemClass, String documentNumber) {
        try {
            this.checkItemClass(itemClass);
            this.checkItemFile(itemFile);
        }
        catch (IllegalArgumentException e) {
            throw new InfrastructureException("unable to import items.", (Exception)e);
        }
        ArrayList<PurApItem> importedItems = new ArrayList<PurApItem>();
        this.lineNo = 0;
        boolean failed = false;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(itemFile.getInputStream(), StandardCharsets.UTF_8));){
            String itemLine;
            while ((itemLine = br.readLine()) != null) {
                Integer n = this.lineNo;
                Integer n2 = this.lineNo = Integer.valueOf(this.lineNo + 1);
                if (StringUtils.isBlank((CharSequence)StringUtils.remove((String)StringUtils.deleteWhitespace((String)itemLine), (String)","))) continue;
                try {
                    PurApItem item = this.parseItem(itemLine, itemClass, documentNumber);
                    importedItems.add(item);
                }
                catch (ItemParserException e) {
                    failed = true;
                }
            }
            if (failed) {
                throw new ItemParserException("errors in parsing item lines in file " + itemFile.getFileName(), "error.itemParser.itemLine", itemFile.getFileName());
            }
        }
        catch (IOException e) {
            throw new InfrastructureException("Unable to open/read file", (Exception)e);
        }
        return importedItems;
    }
}

