/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.util.cxml;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import java.util.ArrayList;
import java.util.List;
import org.kuali.kfs.module.purap.businessobject.B2BShoppingCartItem;
import org.kuali.kfs.module.purap.util.cxml.ItemDetail;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"itemID", "itemDetail", "supplierID"})
public class ItemIn {
    @XmlElement(name="ItemDetail", namespace="http://www.kuali.org/kfs/purap/b2bPunchOutOrder", required=true)
    private ItemDetail itemDetail;
    @XmlElement(name="ItemID", namespace="http://www.kuali.org/kfs/purap/b2bPunchOutOrder", required=true)
    private ItemID itemID;
    @XmlAttribute(name="quantity")
    @XmlSchemaType(name="unsignedInt")
    private Long quantity;
    @XmlElement(name="SupplierID", namespace="http://www.kuali.org/kfs/purap/b2bPunchOutOrder")
    private List<SupplierID> supplierID;

    public ItemDetail getItemDetail() {
        return this.itemDetail;
    }

    public void setItemDetail(ItemDetail itemDetail) {
        this.itemDetail = itemDetail;
    }

    public ItemID getItemID() {
        return this.itemID;
    }

    public void setItemID(ItemID itemID) {
        this.itemID = itemID;
    }

    public Long getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Long quantity) {
        this.quantity = quantity;
    }

    public List<SupplierID> getSupplierID() {
        if (this.supplierID == null) {
            this.supplierID = new ArrayList<SupplierID>();
        }
        return this.supplierID;
    }

    public B2BShoppingCartItem toB2BShoppingCartItem() {
        B2BShoppingCartItem item = new B2BShoppingCartItem();
        item.setSupplierPartId(this.itemID.getSupplierPartID());
        item.setSupplierPartAuxiliaryId(this.itemID.getSupplierPartAuxiliaryID());
        item.setDescription(this.itemDetail.getDescription().getValue());
        item.setQuantity(this.quantity.toString());
        item.setManufacturerName(this.itemDetail.getManufacturerName());
        item.setManufacturerPartID(this.itemDetail.getManufacturerPartID());
        item.setUnitOfMeasure(this.itemDetail.getUnitOfMeasure());
        item.setUnitPrice(this.itemDetail.getUnitPrice().getMoney().getValue().toPlainString());
        item.setUnitPriceCurrency(this.itemDetail.getUnitPrice().getMoney().getValue().toPlainString());
        this.itemDetail.getClassificationList().forEach(classification -> item.addClassification(classification.getDomain(), classification.getValue()));
        this.itemDetail.getExtrinsicList().forEach(extrinsic -> item.addExtrinsic(extrinsic.getName(), extrinsic.getValue()));
        this.supplierID.forEach(supplier -> item.setSupplier(supplier.getDomain(), supplier.getValue()));
        return item;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"supplierPartID", "supplierPartAuxiliaryID"})
    @XmlRootElement(name="ItemID", namespace="http://www.kuali.org/kfs/purap/b2bPunchOutOrder")
    public static class ItemID {
        @XmlElement(name="SupplierPartAuxiliaryID", namespace="http://www.kuali.org/kfs/purap/b2bPunchOutOrder")
        private String supplierPartAuxiliaryID;
        @XmlElement(name="SupplierPartID", namespace="http://www.kuali.org/kfs/purap/b2bPunchOutOrder", required=true)
        private String supplierPartID;

        public ItemID() {
        }

        public ItemID(String supplierPartID, String supplierPartAuxiliaryID) {
            this.supplierPartID = supplierPartID;
            this.supplierPartAuxiliaryID = supplierPartAuxiliaryID;
        }

        public String getSupplierPartAuxiliaryID() {
            return this.supplierPartAuxiliaryID;
        }

        public void setSupplierPartAuxiliaryID(String supplierPartAuxiliaryID) {
            this.supplierPartAuxiliaryID = supplierPartAuxiliaryID;
        }

        public String getSupplierPartID() {
            return this.supplierPartID;
        }

        public void setSupplierPartID(String supplierPartID) {
            this.supplierPartID = supplierPartID;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"value"})
    public static class SupplierID {
        @XmlAttribute(name="domain")
        private String domain;
        @XmlValue
        private String value;

        public SupplierID() {
        }

        public SupplierID(String domain, String value) {
            this.domain = domain;
            this.value = value;
        }

        public String getDomain() {
            return this.domain;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

