/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.businessobject.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceItem;
import org.kuali.kfs.module.purap.businessobject.jaxb.Comments;
import org.kuali.kfs.module.purap.businessobject.jaxb.Extrinsic;
import org.kuali.kfs.module.purap.businessobject.jaxb.GrossAmount;
import org.kuali.kfs.module.purap.businessobject.jaxb.InvoiceDetailDiscount;
import org.kuali.kfs.module.purap.businessobject.jaxb.InvoiceDetailServiceItemReference;
import org.kuali.kfs.module.purap.businessobject.jaxb.NetAmount;
import org.kuali.kfs.module.purap.businessobject.jaxb.SubtotalAmount;
import org.kuali.kfs.module.purap.businessobject.jaxb.Tax;
import org.kuali.kfs.module.purap.businessobject.jaxb.UnitPrice;
import org.kuali.kfs.module.purap.businessobject.jaxb.UnitRate;
import org.kuali.kfs.module.purap.util.cxml.CxmlExtrinsic;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"invoiceDetailServiceItemReference", "subtotalAmount", "unitRate", "unitOfMeasure", "unitPrice", "tax", "grossAmount", "invoiceDetailDiscount", "netAmount", "comments", "extrinsic"})
@XmlRootElement(name="InvoiceDetailServiceItem", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
public class InvoiceDetailServiceItem {
    @XmlElement(name="InvoiceDetailServiceItemReference", namespace="http://www.kuali.org/kfs/purap/electronicInvoice", required=true)
    protected InvoiceDetailServiceItemReference invoiceDetailServiceItemReference;
    @XmlElement(name="SubtotalAmount", namespace="http://www.kuali.org/kfs/purap/electronicInvoice", required=true)
    protected SubtotalAmount subtotalAmount;
    @XmlElement(name="UnitRate", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
    protected UnitRate unitRate;
    @XmlElement(name="UnitOfMeasure", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
    protected String unitOfMeasure;
    @XmlElement(name="UnitPrice", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
    protected UnitPrice unitPrice;
    @XmlElement(name="Tax", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
    protected Tax tax;
    @XmlElement(name="GrossAmount", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
    protected GrossAmount grossAmount;
    @XmlElement(name="InvoiceDetailDiscount", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
    protected InvoiceDetailDiscount invoiceDetailDiscount;
    @XmlElement(name="NetAmount", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
    protected NetAmount netAmount;
    @XmlElement(name="Comments", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
    protected Comments comments;
    @XmlElement(name="Extrinsic", namespace="http://www.kuali.org/kfs/purap/electronicInvoice")
    protected List<Extrinsic> extrinsic;
    @XmlAttribute(name="invoiceLineNumber", required=true)
    @XmlSchemaType(name="unsignedByte")
    protected short invoiceLineNumber;
    @XmlAttribute(name="quantity")
    @XmlSchemaType(name="unsignedByte")
    protected Short quantity;
    @XmlAttribute(name="referenceDate")
    @XmlSchemaType(name="date")
    protected XMLGregorianCalendar referenceDate;
    @XmlAttribute(name="inspectionDate")
    @XmlSchemaType(name="date")
    protected XMLGregorianCalendar inspectionDate;

    public InvoiceDetailServiceItemReference getInvoiceDetailServiceItemReference() {
        return this.invoiceDetailServiceItemReference;
    }

    public void setInvoiceDetailServiceItemReference(InvoiceDetailServiceItemReference invoiceDetailServiceItemReference) {
        this.invoiceDetailServiceItemReference = invoiceDetailServiceItemReference;
    }

    public SubtotalAmount getSubtotalAmount() {
        return this.subtotalAmount;
    }

    public void setSubtotalAmount(SubtotalAmount subtotalAmount) {
        this.subtotalAmount = subtotalAmount;
    }

    public UnitRate getUnitRate() {
        return this.unitRate;
    }

    public void setUnitRate(UnitRate unitRate) {
        this.unitRate = unitRate;
    }

    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public UnitPrice getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(UnitPrice unitPrice) {
        this.unitPrice = unitPrice;
    }

    public Tax getTax() {
        return this.tax;
    }

    public void setTax(Tax tax) {
        this.tax = tax;
    }

    public GrossAmount getGrossAmount() {
        return this.grossAmount;
    }

    public void setGrossAmount(GrossAmount grossAmount) {
        this.grossAmount = grossAmount;
    }

    public InvoiceDetailDiscount getInvoiceDetailDiscount() {
        return this.invoiceDetailDiscount;
    }

    public void setInvoiceDetailDiscount(InvoiceDetailDiscount invoiceDetailDiscount) {
        this.invoiceDetailDiscount = invoiceDetailDiscount;
    }

    public NetAmount getNetAmount() {
        return this.netAmount;
    }

    public void setNetAmount(NetAmount netAmount) {
        this.netAmount = netAmount;
    }

    public Comments getComments() {
        return this.comments;
    }

    public void setComments(Comments comments) {
        this.comments = comments;
    }

    public List<Extrinsic> getExtrinsic() {
        if (this.extrinsic == null) {
            this.extrinsic = new ArrayList<Extrinsic>();
        }
        return this.extrinsic;
    }

    public short getInvoiceLineNumber() {
        return this.invoiceLineNumber;
    }

    public void setInvoiceLineNumber(short invoiceLineNumber) {
        this.invoiceLineNumber = invoiceLineNumber;
    }

    public Short getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Short quantity) {
        this.quantity = quantity;
    }

    public XMLGregorianCalendar getReferenceDate() {
        return this.referenceDate;
    }

    public void setReferenceDate(XMLGregorianCalendar referenceDate) {
        this.referenceDate = referenceDate;
    }

    public XMLGregorianCalendar getInspectionDate() {
        return this.inspectionDate;
    }

    public void setInspectionDate(XMLGregorianCalendar inspectionDate) {
        this.inspectionDate = inspectionDate;
    }

    ElectronicInvoiceItem toElectronicInvoiceItem() {
        ElectronicInvoiceItem item = new ElectronicInvoiceItem();
        item.setInvoiceLineNumber(String.valueOf(this.invoiceLineNumber));
        item.setQuantity(String.valueOf(this.quantity));
        item.setUnitOfMeasure(this.unitOfMeasure);
        item.setUnitPrice(this.unitPrice.getMoney().getValue());
        item.setUnitPriceCurrency(this.unitPrice.getMoney().getCurrency());
        if (this.invoiceDetailDiscount != null) {
            item.setInvoiceLineDiscountAmount(this.invoiceDetailDiscount.getMoney().getValue());
            item.setInvoiceLineDiscountAmountCurrency(this.invoiceDetailDiscount.getMoney().getCurrency());
            item.setInvoiceLineDiscountPercentageRate(this.invoiceDetailDiscount.getPercentageRate().toPlainString());
        }
        if (this.grossAmount != null) {
            item.setInvoiceLineGrossAmount(this.grossAmount.getMoney().getValue());
            item.setInvoiceLineGrossAmountCurrency(this.grossAmount.getMoney().getCurrency());
        }
        if (this.netAmount != null) {
            item.setInvoiceLineNetAmount(this.netAmount.getMoney().getValue());
            item.setInvoiceLineNetAmountCurrency(this.netAmount.getMoney().getCurrency());
        }
        if (this.subtotalAmount != null) {
            item.setSubTotalAmount(this.subtotalAmount.getMoney().getValue());
            item.setSubTotalAmountCurrency(this.subtotalAmount.getMoney().getCurrency());
        }
        if (this.tax != null) {
            item.setTaxAmount(this.tax.getMoney().getValue());
            item.setTaxAmountCurrency(this.tax.getMoney().getCurrency());
            item.setTaxDescription(this.tax.getDescription().getValue());
        }
        if (this.invoiceDetailServiceItemReference != null) {
            item.setReferenceDescription(this.invoiceDetailServiceItemReference.getDescription().getValue());
            item.setReferenceItemIDSupplierPartAuxID(this.invoiceDetailServiceItemReference.getItemID().getSupplierPartAuxiliaryID());
            item.setReferenceItemIDSupplierPartID(this.invoiceDetailServiceItemReference.getItemID().getSupplierPartID());
            item.setReferenceLineNumber(String.valueOf(this.invoiceDetailServiceItemReference.getLineNumber()));
        }
        if (this.comments != null) {
            item.addComments(this.comments.getValue());
        }
        if (CollectionUtils.isNotEmpty(this.extrinsic)) {
            item.setExtrinsic(this.extrinsic.stream().map(ex -> new CxmlExtrinsic(ex.getName(), ex.getValue())).collect(Collectors.toList()));
        }
        return item;
    }
}

