/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.kew.api.document.WorkflowDocumentService;
import org.kuali.kfs.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.CreditMemoStatuses;
import org.kuali.kfs.module.purap.businessobject.CreditMemoItem;
import org.kuali.kfs.module.purap.businessobject.CreditMemoItemUseTax;
import org.kuali.kfs.module.purap.document.AccountsPayableDocumentBase;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocumentBase;
import org.kuali.kfs.module.purap.document.service.AccountsPayableDocumentSpecificService;
import org.kuali.kfs.module.purap.document.service.AccountsPayableService;
import org.kuali.kfs.module.purap.document.service.CreditMemoService;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.validation.event.AttributedContinuePurapEvent;
import org.kuali.kfs.module.purap.service.PurapGeneralLedgerService;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.businessobject.PaymentMethod;
import org.kuali.kfs.sys.context.SpringContext;

public class VendorCreditMemoDocument
extends AccountsPayableDocumentBase {
    private static final Logger LOG = LogManager.getLogger();
    protected Integer paymentRequestIdentifier;
    protected String creditMemoNumber;
    protected Date creditMemoDate;
    protected KualiDecimal creditMemoAmount;
    protected Timestamp creditMemoPaidTimestamp;
    protected String itemMiscellaneousCreditDescription;
    protected Date purchaseOrderEndDate;
    protected String vendorAttentionName;
    private String paymentMethodCode;
    protected PaymentRequestDocument paymentRequestDocument;
    private PaymentMethod paymentMethod;

    public boolean isSourceDocumentPaymentRequest() {
        return this.getPaymentRequestIdentifier() != null;
    }

    public boolean isSourceDocumentPurchaseOrder() {
        return !this.isSourceDocumentPaymentRequest() && this.getPurchaseOrderIdentifier() != null;
    }

    public boolean isSourceVendor() {
        return !this.isSourceDocumentPaymentRequest() && !this.isSourceDocumentPurchaseOrder();
    }

    @Override
    public boolean isInquiryRendered() {
        return !this.isPostingYearPrior() || !this.getApplicationDocumentStatus().equals("Complete") && !this.getApplicationDocumentStatus().equals("Cancelled") && !this.getApplicationDocumentStatus().equals("Cancelled In Process");
    }

    public void initiateDocument() {
        LOG.debug("initiateDocument() started");
        this.updateAndSaveAppDocStatus("Initiated");
        Person currentUser = GlobalVariables.getUserSession().getPerson();
        this.setAccountsPayableProcessorIdentifier(currentUser.getPrincipalId());
        this.setProcessingCampusCode(currentUser.getCampusCode());
    }

    public void clearInitFields() {
        LOG.debug("clearDocument() started");
        this.getDocumentHeader().setDocumentDescription(null);
        this.getDocumentHeader().setExplanation(null);
        this.getDocumentHeader().setFinancialDocumentTotalAmount(null);
        this.getDocumentHeader().setOrganizationDocumentNumber(null);
        this.setPurchaseOrderIdentifier(null);
        this.setCreditMemoNumber(null);
        this.setCreditMemoDate(null);
        this.setCreditMemoAmount(null);
        this.setVendorNumber(null);
        this.setPaymentRequestIdentifier(null);
    }

    public String getCreditMemoType() {
        String type = "Vendor";
        if (this.isSourceDocumentPaymentRequest()) {
            type = "PREQ";
        } else if (this.isSourceDocumentPurchaseOrder()) {
            type = "PO";
        }
        return type;
    }

    public boolean isBoNotesSupport() {
        return true;
    }

    public boolean getPurchaseOrderNotes() {
        boolean hasNotes = false;
        if (this.getNotes().size() > 0) {
            hasNotes = true;
        }
        return hasNotes;
    }

    protected String getTitleIndicator() {
        if (this.isHoldIndicator()) {
            return "HOLD";
        }
        return "";
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        LOG.debug("doRouteStatusChange() started");
        super.doRouteStatusChange(statusChangeEvent);
        try {
            Set currentNodes;
            if (this.getDocumentHeader().getWorkflowDocument().isProcessed()) {
                this.updateAndSaveAppDocStatus("Complete");
            } else if (this.getDocumentHeader().getWorkflowDocument().isDisapproved()) {
                String nodeName = ((WorkflowDocumentService)SpringContext.getBean(WorkflowDocumentService.class)).getCurrentRouteLevelName(this.getDocumentHeader().getWorkflowDocument());
                String disapprovalStatus = CreditMemoStatuses.getCreditMemoAppDocDisapproveStatuses().get(nodeName);
                if (StringUtils.isBlank((CharSequence)disapprovalStatus) && ("Initiated".equals(this.getApplicationDocumentStatus()) || "In Process".equals(this.getApplicationDocumentStatus()))) {
                    disapprovalStatus = "Cancelled In Process";
                    this.updateAndSaveAppDocStatus(disapprovalStatus);
                }
                if (StringUtils.isNotBlank((CharSequence)disapprovalStatus)) {
                    ((AccountsPayableService)SpringContext.getBean(AccountsPayableService.class)).cancelAccountsPayableDocument(this, nodeName);
                } else {
                    this.logAndThrowRuntimeException("No status found to set for document being disapproved in node '" + nodeName + "'");
                }
            } else if (this.getDocumentHeader().getWorkflowDocument().isCanceled() && CollectionUtils.isNotEmpty((Collection)(currentNodes = this.getDocumentHeader().getWorkflowDocument().getCurrentNodeNames()))) {
                String currentNodeName = (String)currentNodes.iterator().next();
                ((AccountsPayableService)SpringContext.getBean(AccountsPayableService.class)).cancelAccountsPayableDocument(this, currentNodeName);
            }
        }
        catch (Exception e) {
            this.logAndThrowRuntimeException("Error saving routing data while saving document with id " + this.getDocumentNumber(), e);
        }
    }

    @Override
    public boolean processNodeChange(String newNodeName, String oldNodeName) {
        if ("AdHoc".equals(oldNodeName)) {
            ((AccountsPayableService)SpringContext.getBean(AccountsPayableService.class)).performLogicForFullEntryCompleted(this);
        } else if ("Account".equals(newNodeName) && this.isReopenPurchaseOrderIndicator()) {
            ((PurapService)SpringContext.getBean(PurapService.class)).performLogicForCloseReopenPO(this);
        }
        return true;
    }

    public String getDocumentTitle() {
        if (((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsBoolean(VendorCreditMemoDocument.class, "OVERRIDE_DOCUMENT_TITLE_IND").booleanValue()) {
            return this.getCustomDocumentTitle();
        }
        return super.getDocumentTitle();
    }

    protected String getCustomDocumentTitle() {
        Object popreq = "";
        if (this.isSourceDocumentPurchaseOrder() || this.isSourceDocumentPaymentRequest()) {
            String poNumber = this.getPurchaseOrderIdentifier().toString();
            popreq = "PO: " + poNumber;
        }
        String vendorName = StringUtils.trimToEmpty((String)this.getVendorName());
        String cmAmount = this.getGrandTotal().toString();
        String indicator = this.getTitleIndicator();
        return (String)popreq + " Vendor: " + vendorName + " Amount: " + cmAmount + " " + indicator;
    }

    @Override
    public void saveDocumentFromPostProcessing() {
        ((PurapService)SpringContext.getBean(PurapService.class)).saveDocumentNoValidation((Document)this);
    }

    @Override
    public Class<CreditMemoItem> getItemClass() {
        return CreditMemoItem.class;
    }

    @Override
    public Class getItemUseTaxClass() {
        return CreditMemoItemUseTax.class;
    }

    @Override
    public PurchasingAccountsPayableDocument getPurApSourceDocumentIfPossible() {
        PurchasingAccountsPayableDocumentBase sourceDocument = null;
        if (this.isSourceDocumentPaymentRequest()) {
            sourceDocument = this.getPaymentRequestDocument();
        } else if (this.isSourceDocumentPurchaseOrder()) {
            sourceDocument = this.getPurchaseOrderDocument();
        }
        return sourceDocument;
    }

    @Override
    public String getPurApSourceDocumentLabelIfPossible() {
        PurchasingAccountsPayableDocument document = this.getPurApSourceDocumentIfPossible();
        if (ObjectUtils.isNotNull((Object)document)) {
            return ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDocumentLabelByClass(document.getClass());
        }
        return null;
    }

    public KualiDecimal getLineItemPreTaxTotal() {
        KualiDecimal lineItemPreTaxTotal = KualiDecimal.ZERO;
        for (CreditMemoItem item : this.getItems()) {
            item.refreshReferenceObject("itemType");
            if (!item.getItemType().isLineItemIndicator() || item.getExtendedPrice() == null) continue;
            lineItemPreTaxTotal = (KualiDecimal)lineItemPreTaxTotal.add((AbstractKualiDecimal)item.getExtendedPrice());
        }
        return lineItemPreTaxTotal;
    }

    public KualiDecimal getLineItemTotal() {
        KualiDecimal lineItemTotal = KualiDecimal.ZERO;
        for (CreditMemoItem item : this.getItems()) {
            item.refreshReferenceObject("itemType");
            if (!item.getItemType().isLineItemIndicator() || item.getTotalAmount() == null) continue;
            lineItemTotal = (KualiDecimal)lineItemTotal.add((AbstractKualiDecimal)item.getTotalAmount());
        }
        return lineItemTotal;
    }

    @Override
    public KualiDecimal getGrandTotal() {
        KualiDecimal grandTotal = KualiDecimal.ZERO;
        for (CreditMemoItem item : this.getItems()) {
            item.refreshReferenceObject("itemType");
            if (item.getTotalAmount() == null) continue;
            if (StringUtils.equals((CharSequence)"RSTO", (CharSequence)item.getItemTypeCode())) {
                if (ObjectUtils.isNotNull((Object)item.getExtendedPrice())) {
                    item.setExtendedPrice((KualiDecimal)((KualiDecimal)item.getExtendedPrice().abs()).negated());
                } else {
                    item.setExtendedPrice(KualiDecimal.ZERO);
                }
            }
            grandTotal = (KualiDecimal)grandTotal.add((AbstractKualiDecimal)item.getTotalAmount());
        }
        return grandTotal;
    }

    public KualiDecimal getGrandPreTaxTotal() {
        KualiDecimal grandTotal = KualiDecimal.ZERO;
        for (CreditMemoItem item : this.getItems()) {
            item.refreshReferenceObject("itemType");
            if (item.getExtendedPrice() == null) continue;
            if (StringUtils.equals((CharSequence)"RSTO", (CharSequence)item.getItemTypeCode())) {
                item.setExtendedPrice((KualiDecimal)((KualiDecimal)item.getExtendedPrice().abs()).negated());
            }
            grandTotal = (KualiDecimal)grandTotal.add((AbstractKualiDecimal)item.getExtendedPrice());
        }
        return grandTotal;
    }

    public KualiDecimal getGrandTaxAmount() {
        KualiDecimal grandTotal = KualiDecimal.ZERO;
        for (CreditMemoItem item : this.getItems()) {
            item.refreshReferenceObject("itemType");
            if (item.getItemTaxAmount() == null) continue;
            if (StringUtils.equals((CharSequence)"RSTO", (CharSequence)item.getItemTypeCode())) {
                item.setExtendedPrice((KualiDecimal)((KualiDecimal)item.getItemTaxAmount().abs()).negated());
            }
            grandTotal = (KualiDecimal)grandTotal.add((AbstractKualiDecimal)item.getItemTaxAmount());
        }
        return grandTotal;
    }

    public KualiDecimal getGrandPreTaxTotalExcludingRestockingFee() {
        String[] restockingFeeCode = new String[]{"RSTO"};
        return this.getTotalPreTaxDollarAmountWithExclusions(restockingFeeCode, true);
    }

    public KualiDecimal getGrandTotalExcludingRestockingFee() {
        String[] restockingFeeCode = new String[]{"RSTO"};
        return this.getTotalDollarAmountWithExclusions(restockingFeeCode, true);
    }

    public Integer getPaymentRequestIdentifier() {
        return this.paymentRequestIdentifier;
    }

    public void setPaymentRequestIdentifier(Integer paymentRequestIdentifier) {
        this.paymentRequestIdentifier = paymentRequestIdentifier;
    }

    public String getCreditMemoNumber() {
        return this.creditMemoNumber;
    }

    public void setCreditMemoNumber(String creditMemoNumber) {
        if (creditMemoNumber != null) {
            creditMemoNumber = creditMemoNumber.toUpperCase(Locale.US);
        }
        this.creditMemoNumber = creditMemoNumber;
    }

    public Date getCreditMemoDate() {
        return this.creditMemoDate;
    }

    public void setCreditMemoDate(Date creditMemoDate) {
        this.creditMemoDate = creditMemoDate;
    }

    public KualiDecimal getCreditMemoAmount() {
        return this.creditMemoAmount;
    }

    public void setCreditMemoAmount(KualiDecimal creditMemoAmount) {
        this.creditMemoAmount = creditMemoAmount;
    }

    public String getItemMiscellaneousCreditDescription() {
        return this.itemMiscellaneousCreditDescription;
    }

    public void setItemMiscellaneousCreditDescription(String itemMiscellaneousCreditDescription) {
        this.itemMiscellaneousCreditDescription = itemMiscellaneousCreditDescription;
    }

    public Timestamp getCreditMemoPaidTimestamp() {
        return this.creditMemoPaidTimestamp;
    }

    public void setCreditMemoPaidTimestamp(Timestamp creditMemoPaidTimestamp) {
        this.creditMemoPaidTimestamp = creditMemoPaidTimestamp;
    }

    public PaymentRequestDocument getPaymentRequestDocument() {
        if (ObjectUtils.isNull((Object)this.paymentRequestDocument) && ObjectUtils.isNotNull((Object)this.getPaymentRequestIdentifier())) {
            this.setPaymentRequestDocument(((PaymentRequestService)SpringContext.getBean(PaymentRequestService.class)).getPaymentRequestById(this.getPaymentRequestIdentifier()));
        }
        return this.paymentRequestDocument;
    }

    public void setPaymentRequestDocument(PaymentRequestDocument paymentRequestDocument) {
        if (ObjectUtils.isNull((Object)paymentRequestDocument)) {
            this.paymentRequestDocument = null;
        } else {
            this.setPaymentRequestIdentifier(paymentRequestDocument.getPurapDocumentIdentifier());
            this.paymentRequestDocument = paymentRequestDocument;
        }
    }

    @Deprecated
    public PaymentRequestDocument getPaymentRequest() {
        return this.getPaymentRequestDocument();
    }

    @Deprecated
    public void setPaymentRequest(PaymentRequestDocument paymentRequest) {
        this.setPaymentRequestDocument(paymentRequest);
    }

    @Deprecated
    public PurchaseOrderDocument getPurchaseOrder() {
        return this.getPurchaseOrderDocument();
    }

    @Deprecated
    public void setPurchaseOrder(PurchaseOrderDocument purchaseOrder) {
        this.setPurchaseOrderDocument(purchaseOrder);
    }

    public Date getPurchaseOrderEndDate() {
        return this.purchaseOrderEndDate;
    }

    public void setPurchaseOrderEndDate(Date purchaseOrderEndDate) {
        this.purchaseOrderEndDate = purchaseOrderEndDate;
    }

    @Override
    public String getPoDocumentTypeForAccountsPayableDocumentCancel() {
        return "POC";
    }

    @Override
    public KualiDecimal getInitialAmount() {
        return this.getCreditMemoAmount();
    }

    @Override
    public void prepareForSave(KualiDocumentEvent event) {
        if (event instanceof AttributedContinuePurapEvent) {
            ((CreditMemoService)SpringContext.getBean(CreditMemoService.class)).populateDocumentAfterInit(this);
        }
        super.prepareForSave(event);
    }

    @Override
    protected boolean isAttachmentRequired() {
        return StringUtils.equalsIgnoreCase((CharSequence)"Y", (CharSequence)((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(VendorCreditMemoDocument.class, "REQUIRE_ATTACHMENT_IND"));
    }

    @Override
    public AccountsPayableDocumentSpecificService getDocumentSpecificService() {
        return (AccountsPayableDocumentSpecificService)SpringContext.getBean(CreditMemoService.class);
    }

    public void customizeExplicitGeneralLedgerPendingEntry(GeneralLedgerPendingEntrySourceDetail postable, GeneralLedgerPendingEntry explicitEntry) {
        super.customizeExplicitGeneralLedgerPendingEntry(postable, explicitEntry);
        ((PurapGeneralLedgerService)SpringContext.getBean(PurapGeneralLedgerService.class)).customizeGeneralLedgerPendingEntry(this, (AccountingLine)postable, explicitEntry, this.getPurchaseOrderIdentifier(), this.getDebitCreditCodeForGLEntries(), "CM", this.isGenerateEncumbranceEntries());
        explicitEntry.setFinancialDocumentApprovedCode("A");
    }

    @Override
    public Date getTransactionTaxDate() {
        return this.getCreditMemoDate();
    }

    @Override
    public String getVendorAttentionName() {
        return this.vendorAttentionName;
    }

    @Override
    public void setVendorAttentionName(String vendorAttentionName) {
        this.vendorAttentionName = vendorAttentionName;
    }

    public boolean answerSplitNodeQuestion(String nodeName) throws UnsupportedOperationException {
        if (nodeName.equals("RequiresImageAttachment")) {
            return this.requiresAccountsPayableReviewRouting();
        }
        throw new UnsupportedOperationException("Cannot answer split question for this node you call \"" + nodeName + "\"");
    }

    public String getPaidIndicatorForResult() {
        return this.getCreditMemoPaidTimestamp() != null ? "Yes" : "No";
    }

    @Override
    public boolean documentHasNoImagesAttached() {
        List boNotes = this.getNotes();
        if (ObjectUtils.isNotNull((Object)boNotes)) {
            for (Object obj : boNotes) {
                Note note = (Note)obj;
                note.refreshReferenceObject("attachment");
                if (!ObjectUtils.isNotNull((Object)note.getAttachment()) || !"Credit Memo Image".equals(note.getAttachment().getAttachmentTypeCode())) continue;
                return false;
            }
        }
        return true;
    }

    public String getPaymentMethodCode() {
        return this.paymentMethodCode;
    }

    public void setPaymentMethodCode(String paymentMethodCode) {
        this.paymentMethodCode = paymentMethodCode;
    }

    public PaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }
}

