/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.kuali.kfs.kew.doctype.service.DocumentTypeService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchasingItemBase;
import org.kuali.kfs.module.purap.document.PurchasingDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class PurchasingProcessContainsAtLeastOneItemValidation
extends GenericValidation {
    private DocumentTypeService documentTypeService;

    public boolean validate(AttributedDocumentEvent event) {
        PurchasingDocument purDocument = (PurchasingDocument)event.getDocument();
        for (PurApItem item : purDocument.getItems()) {
            if (((PurchasingItemBase)item).isEmpty() || !item.getItemType().isLineItemIndicator()) continue;
            return true;
        }
        String documentType = this.getDocumentTypeLabel(purDocument.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
        GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.item.required", new String[]{documentType});
        return false;
    }

    protected String getDocumentTypeLabel(String documentTypeName) {
        return this.documentTypeService.getDocumentTypeByName(documentTypeName).getLabel();
    }

    public void setDocumentTypeService(DocumentTypeService documentTypeService) {
        this.documentTypeService = documentTypeService;
    }
}

