/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.purap.document.ContractManagerAssignmentDocument;
import org.kuali.kfs.module.purap.exception.PurapConfigurationException;
import org.kuali.kfs.module.purap.service.ImageService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;

public class ImageServiceImpl
implements ImageService {
    private static final Logger LOG = LogManager.getLogger();
    private ConfigurationService configurationService;
    private ParameterService parameterService;

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    @Override
    public String getPurchasingDirectorImage(String key, String campusCode, String location) {
        LOG.debug("getPurchasingDirectorImage() started");
        String prefix = this.parameterService.getParameterValueAsString(KfsParameterConstants.PURCHASING_DOCUMENT.class, "PDF_DIRECTOR_IMAGE_PREFIX");
        String extension = "." + this.parameterService.getParameterValueAsString(KfsParameterConstants.PURCHASING_DOCUMENT.class, "PDF_DIRECTOR_IMAGE_EXTENSION");
        return this.getFile(prefix, campusCode, key, extension, location);
    }

    @Override
    public String getContractManagerImage(String key, Integer contractManagerId, String location) {
        LOG.debug("getContractManagerImage() started");
        DecimalFormat formatter = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        formatter.applyPattern("00");
        String cm = formatter.format(contractManagerId);
        String prefix = this.parameterService.getParameterValueAsString(ContractManagerAssignmentDocument.class, "PDF_IMAGE_PREFIX");
        String extension = "." + this.parameterService.getParameterValueAsString(ContractManagerAssignmentDocument.class, "PDF_IMAGE_EXTENSION");
        return this.getFile(prefix, cm, key, extension, location);
    }

    @Override
    public String getLogo(String key, String campusCode, String location) {
        LOG.debug("getLogo() started. key is {}. campusCode is {}", (Object)key, (Object)campusCode);
        String prefix = this.parameterService.getParameterValueAsString(KfsParameterConstants.PURCHASING_DOCUMENT.class, "PDF_LOGO_IMAGE_PREFIX");
        String extension = "." + this.parameterService.getParameterValueAsString(KfsParameterConstants.PURCHASING_DOCUMENT.class, "PDF_LOGO_IMAGE_EXTENSION");
        return this.getFile(prefix, campusCode, key, extension, location);
    }

    protected String getFile(String prefix, String fileKey, String key, String extension, String location) {
        LOG.debug("getFile() started");
        String urlpath = this.parameterService.getParameterValueAsString(KfsParameterConstants.PURCHASING_DOCUMENT.class, "PDF_IMAGE_LOCATION_URL");
        if (StringUtils.isEmpty((CharSequence)urlpath)) {
            urlpath = this.configurationService.getPropertyValueAsString("externalizable.images.url");
        }
        if (urlpath == null) {
            throw new PurapConfigurationException("Application Setting externalizable.images.url is missing");
        }
        if (location == null) {
            throw new PurapConfigurationException("Valid location to store temp image files was null");
        }
        String completeUrl = urlpath + prefix + "_" + fileKey.toLowerCase(Locale.US) + extension;
        LOG.debug("getFile() URL = {}", (Object)completeUrl);
        return completeUrl;
    }
}

