/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.authorization;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.document.authorization.PurapAccountingLineAuthorizer;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.document.AccountingDocument;

public class RequisitionAccountingLineAuthorizer
extends PurapAccountingLineAuthorizer {
    protected static final String INITIATOR_NODE = "Initiator";
    protected static final String CONTENT_REVIEW_NODE = "Organization";

    public boolean renderNewLine(AccountingDocument accountingDocument, String accountingGroupProperty) {
        WorkflowDocument workflowDocument = accountingDocument.getDocumentHeader().getWorkflowDocument();
        Set currentNodes = workflowDocument.getCurrentNodeNames();
        if (CollectionUtils.isNotEmpty((Collection)currentNodes) && (currentNodes.contains(INITIATOR_NODE) || currentNodes.contains(CONTENT_REVIEW_NODE))) {
            return true;
        }
        return super.renderNewLine(accountingDocument, accountingGroupProperty);
    }

    @Override
    public Set<String> getUnviewableBlocks(AccountingDocument accountingDocument, AccountingLine accountingLine, boolean newLine, Person currentUser) {
        Set<String> unviewableBlocks = super.getUnviewableBlocks(accountingDocument, accountingLine, newLine, currentUser);
        unviewableBlocks.remove("accountLinePercent");
        unviewableBlocks.remove("amount");
        return unviewableBlocks;
    }

    protected Map<String, String> getRoleQualifiers(AccountingDocument accountingDocument, AccountingLine accountingLine) {
        String purchasingCommodityCode;
        RequisitionItem purApItem;
        Set currentNodes;
        Map roleQualifiers = super.getRoleQualifiers(accountingDocument, accountingLine);
        if (ObjectUtils.isNotNull((Object)accountingLine) && ObjectUtils.isNotNull((Object)accountingDocument.getDocumentHeader()) && ObjectUtils.isNotNull((Object)accountingDocument.getDocumentHeader().getWorkflowDocument()) && (currentNodes = accountingDocument.getDocumentHeader().getWorkflowDocument().getCurrentNodeNames()) != null && currentNodes.contains("Commodity") && ObjectUtils.isNotNull((Object)(purApItem = (RequisitionItem)this.findTheItemForAccountingLine(accountingDocument, accountingLine))) && StringUtils.isNotBlank((CharSequence)(purchasingCommodityCode = purApItem.getPurchasingCommodityCode()))) {
            roleQualifiers.put("purchasingCommodityCode", purchasingCommodityCode);
        }
        return roleQualifiers;
    }
}

