/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.List;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestItem;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.Validation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.impl.AccountingLineAmountPositiveValidation;
import org.kuali.kfs.sys.document.validation.impl.AccountingLineDataDictionaryValidation;
import org.kuali.kfs.sys.document.validation.impl.AccountingLineValuesAllowedValidationHutch;
import org.kuali.kfs.sys.document.validation.impl.BusinessObjectDataDictionaryValidation;
import org.kuali.kfs.sys.document.validation.impl.CompositeValidation;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;

public class PaymentRequestProcessItemValidation
extends GenericValidation {
    private PurapService purapService;
    private PurApItem itemForValidation;
    private AttributedDocumentEvent event;
    private CompositeValidation reviewAccountingLineValidation;
    private PaymentRequestDocument preqDocument;
    private PurApAccountingLine preqAccountingLine;
    private ParameterService parameterService;

    public boolean validate(AttributedDocumentEvent event) {
        this.event = event;
        PaymentRequestDocument paymentRequestDocument = (PaymentRequestDocument)event.getDocument();
        PaymentRequestItem preqItem = (PaymentRequestItem)this.itemForValidation;
        return this.validateEachItem(paymentRequestDocument, preqItem);
    }

    protected boolean validateEachItem(PaymentRequestDocument paymentRequestDocument, PaymentRequestItem item) {
        String identifierString = item.getItemIdentifierString();
        return this.validateItem(paymentRequestDocument, item, identifierString);
    }

    public boolean validateItem(PaymentRequestDocument paymentRequestDocument, PaymentRequestItem item, String identifierString) {
        boolean valid = true;
        if (!this.purapService.isFullDocumentEntryCompleted(paymentRequestDocument)) {
            if (item.getItemType().isLineItemIndicator()) {
                valid = this.validateAboveTheLineItems(item, identifierString, paymentRequestDocument.isReceivingDocumentRequiredIndicator(), paymentRequestDocument);
            }
            valid &= this.validateItemWithoutAccounts(item, identifierString);
        }
        return valid &= this.validateItemAccounts(paymentRequestDocument, item, identifierString);
    }

    protected boolean validateAboveTheLineItems(PaymentRequestItem item, String identifierString, boolean isReceivingDocumentRequiredIndicator, PaymentRequestDocument paymentRequestDocument) {
        boolean valid = true;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        errorMap.clearErrorPath();
        if (ObjectUtils.isNotNull((Object)item.getItemQuantity())) {
            if (item.getItemQuantity().isNegative()) {
                valid = false;
                errorMap.putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.item.amount.belowZero", new String[]{"Qty Invoiced", identifierString});
            }
            if (!isReceivingDocumentRequiredIndicator && item.getPoOutstandingQuantity().isLessThan((AbstractKualiDecimal)item.getItemQuantity())) {
                valid = false;
                errorMap.putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.item.quantity.tooMany", new String[]{"Qty Invoiced", identifierString, "Open Qty"});
            }
        }
        if (ObjectUtils.isNotNull((Object)item.getExtendedPrice()) && item.getExtendedPrice().isPositive() && ObjectUtils.isNotNull((Object)item.getPoOutstandingQuantity()) && item.getPoOutstandingQuantity().isPositive() && (ObjectUtils.isNull((Object)item.getItemQuantity()) || item.getItemQuantity().isZero())) {
            valid = false;
            errorMap.putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.item.quantity.required", new String[]{"Qty Invoiced", identifierString, "Open Qty"});
        }
        if ((ObjectUtils.isNull((Object)paymentRequestDocument.getPurapDocumentIdentifier()) || "In Process".equals(paymentRequestDocument.getApplicationDocumentStatus())) && item.getItemType().isAmountBasedGeneralLedgerIndicator() && item.getExtendedPrice() != null && item.getExtendedPrice().isNonZero() && (item.getPoOutstandingAmount() == null || item.getPoOutstandingAmount().isZero())) {
            valid = false;
            errorMap.putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.item.amount.alreadyPaid", new String[]{identifierString});
        }
        return valid;
    }

    public boolean validateItemWithoutAccounts(PaymentRequestItem item, String identifierString) {
        boolean valid = true;
        if (ObjectUtils.isNotNull((Object)item.getExtendedPrice()) && item.getExtendedPrice().isNonZero() && item.isAccountListEmpty()) {
            valid = false;
            GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.item.accounting.incomplete", new String[]{identifierString});
        }
        return valid;
    }

    public boolean validateItemAccounts(PaymentRequestDocument paymentRequestDocument, PaymentRequestItem item, String identifierString) {
        boolean valid = true;
        List<PurApAccountingLine> accountingLines = item.getSourceAccountingLines();
        KualiDecimal itemTotal = item.getTotalAmount();
        KualiDecimal accountTotal = KualiDecimal.ZERO;
        for (PurApAccountingLine accountingLine : accountingLines) {
            if (accountingLine.getAmount().isZero() && !this.canApproveAccountingLinesWithZeroAmount()) {
                GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.item.accounting.amount.invalid", new String[]{this.itemForValidation.getItemIdentifierString()});
                valid = false;
            }
            valid &= this.reviewAccountingLineValidation(paymentRequestDocument, accountingLine);
            accountTotal = (KualiDecimal)accountTotal.add((AbstractKualiDecimal)accountingLine.getAmount());
        }
        if (this.purapService.isFullDocumentEntryCompleted(paymentRequestDocument) && accountTotal.compareTo((AbstractKualiDecimal)itemTotal) != 0) {
            valid = false;
            GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.item.accounting.amount.total", new String[]{identifierString});
        }
        return valid;
    }

    public CompositeValidation getReviewAccountingLineValidation() {
        return this.reviewAccountingLineValidation;
    }

    public void setReviewAccountingLineValidation(CompositeValidation reviewAccountingLineValidation) {
        this.reviewAccountingLineValidation = reviewAccountingLineValidation;
    }

    public PurapService getPurapService() {
        return this.purapService;
    }

    public void setPurapService(PurapService purapService) {
        this.purapService = purapService;
    }

    public PurApItem getItemForValidation() {
        return this.itemForValidation;
    }

    public void setItemForValidation(PurApItem itemForValidation) {
        this.itemForValidation = itemForValidation;
    }

    protected boolean reviewAccountingLineValidation(PaymentRequestDocument document, PurApAccountingLine accountingLine) {
        this.preqDocument = document;
        this.preqAccountingLine = accountingLine;
        this.createGauntlet(this.reviewAccountingLineValidation);
        return true;
    }

    protected void createGauntlet(CompositeValidation validation) {
        for (Validation val : validation.getValidations()) {
            if (val instanceof CompositeValidation) {
                this.createGauntlet((CompositeValidation)val);
                continue;
            }
            if (val instanceof BusinessObjectDataDictionaryValidation) {
                this.addParametersToValidation((BusinessObjectDataDictionaryValidation)val);
                continue;
            }
            if (val instanceof AccountingLineAmountPositiveValidation) {
                this.addParametersToValidation((AccountingLineAmountPositiveValidation)val);
                continue;
            }
            if (val instanceof AccountingLineDataDictionaryValidation) {
                this.addParametersToValidation((AccountingLineDataDictionaryValidation)val);
                continue;
            }
            if (val instanceof AccountingLineValuesAllowedValidationHutch) {
                this.addParametersToValidation((AccountingLineValuesAllowedValidationHutch)val);
                continue;
            }
            throw new IllegalStateException("Validations in the PaymentRequestProcessItemValidation must contain specific instances of validation");
        }
    }

    public boolean canApproveAccountingLinesWithZeroAmount() {
        String approveZeroAmountLine = this.parameterService.getParameterValueAsString(KfsParameterConstants.PURCHASING_DOCUMENT.class, "APPROVE_ZERO_AMOUNTS_IND");
        return "Y".equalsIgnoreCase(approveZeroAmountLine);
    }

    protected void addParametersToValidation(BusinessObjectDataDictionaryValidation validation) {
        validation.setBusinessObjectForValidation((PersistableBusinessObject)this.preqAccountingLine);
    }

    protected void addParametersToValidation(AccountingLineAmountPositiveValidation validation) {
        validation.setAccountingDocumentForValidation((AccountingDocument)this.preqDocument);
        validation.setAccountingLineForValidation((AccountingLine)this.preqAccountingLine);
    }

    protected void addParametersToValidation(AccountingLineDataDictionaryValidation validation) {
        validation.setAccountingLineForValidation((AccountingLine)this.preqAccountingLine);
    }

    protected void addParametersToValidation(AccountingLineValuesAllowedValidationHutch validation) {
        validation.setAccountingDocumentForValidation((AccountingDocument)this.preqDocument);
        validation.setAccountingLineForValidation((AccountingLine)this.preqAccountingLine);
    }

    protected AttributedDocumentEvent getEvent() {
        return this.event;
    }

    protected void setEvent(AttributedDocumentEvent event) {
        this.event = event;
    }

    protected PaymentRequestDocument getPreqDocument() {
        return this.preqDocument;
    }

    protected void setPreqDocument(PaymentRequestDocument preqDocument) {
        this.preqDocument = preqDocument;
    }

    protected PurApAccountingLine getPreqAccountingLine() {
        return this.preqAccountingLine;
    }

    protected void setPreqAccountingLine(PurApAccountingLine preqAccountingLine) {
        this.preqAccountingLine = preqAccountingLine;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

