/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.SensitiveData;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class PurchaseOrderAssignSensitiveDataValidation
extends GenericValidation {
    private PurchaseOrderDocument accountingDocumentForValidation;
    private String sensitiveDataAssignmentReason;
    private List<SensitiveData> sensitiveDatasAssigned;

    public boolean validate(AttributedDocumentEvent event) {
        boolean valid = true;
        GlobalVariables.getMessageMap().clearErrorPath();
        HashSet<String> sdset = new HashSet<String>();
        if (StringUtils.isEmpty((CharSequence)this.sensitiveDataAssignmentReason)) {
            GlobalVariables.getMessageMap().putError("document.assignSensitiveData", "error.assign.sensitiveData.reason.empty", new String[0]);
            valid = false;
        }
        for (SensitiveData sdobj : this.sensitiveDatasAssigned) {
            SensitiveData sd = sdobj;
            if (!sd.isActive()) {
                GlobalVariables.getMessageMap().putError("document.assignSensitiveData", "error.assign.sensitiveData.inactive", new String[]{sd.getSensitiveDataDescription()});
                valid = false;
                continue;
            }
            if (sdset.add(sd.getSensitiveDataCode())) continue;
            GlobalVariables.getMessageMap().putError("document.assignSensitiveData", "error.assign.sensitiveData.redundant", new String[]{sd.getSensitiveDataDescription()});
            valid = false;
        }
        GlobalVariables.getMessageMap().clearErrorPath();
        return valid;
    }

    public PurchaseOrderDocument getAccountingDocumentForValidation() {
        return this.accountingDocumentForValidation;
    }

    public void setAccountingDocumentForValidation(PurchaseOrderDocument accountingDocumentForValidation) {
        this.accountingDocumentForValidation = accountingDocumentForValidation;
    }

    public String getSensitiveDataAssignmentReason() {
        return this.sensitiveDataAssignmentReason;
    }

    public void setSensitiveDataAssignmentReason(String sensitiveDataAssignmentReason) {
        this.sensitiveDataAssignmentReason = sensitiveDataAssignmentReason;
    }

    public List<SensitiveData> getSensitiveDatasAssigned() {
        return this.sensitiveDatasAssigned;
    }

    public void setSensitiveDatasAssigned(List<SensitiveData> sensitiveDatasAssigned) {
        this.sensitiveDatasAssigned = sensitiveDatasAssigned;
    }
}

