/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.workflow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kew.api.document.DocumentStatusCategory;
import org.kuali.kfs.kew.api.document.attribute.DocumentAttribute;
import org.kuali.kfs.kew.api.document.attribute.DocumentAttributeString;
import org.kuali.kfs.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.kfs.kew.api.document.search.DocumentSearchResult;
import org.kuali.kfs.kew.framework.document.search.DocumentSearchResultValue;
import org.kuali.kfs.kew.framework.document.search.DocumentSearchResultValues;
import org.kuali.kfs.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.kfs.kim.api.permission.PermissionService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.workflow.KFSDocumentSearchCustomizer;

public class KFSPurapDocumentSearchCustomizer
extends KFSDocumentSearchCustomizer {
    private PermissionService permissionService;

    public DocumentSearchResultValues customizeResults(DocumentSearchCriteria documentSearchCriteria, List<DocumentSearchResult> defaultResults) {
        GlobalVariables.getMessageMap().putWarning("documentNumber", "warning.purchaseorder.number.dont.disclose", new String[0]);
        ArrayList<DocumentSearchResultValue> customResultValues = new ArrayList<DocumentSearchResultValue>();
        boolean isAuthorizedToViewPurapDocId = false;
        if (defaultResults.size() > 0) {
            for (DocumentAttribute documentAttribute : defaultResults.get(0).getDocumentAttributes()) {
                if (!"purapDocumentIdentifier".equals(documentAttribute.getName())) continue;
                isAuthorizedToViewPurapDocId = this.isAuthorizedToViewPurapDocId(documentSearchCriteria.getDocSearchUserId());
            }
        }
        for (DocumentSearchResult result : defaultResults) {
            ArrayList<DocumentAttributeString> custAttrBuilders = new ArrayList<DocumentAttributeString>();
            DocumentRouteHeaderValue document = result.getDocument();
            for (DocumentAttribute documentAttribute : result.getDocumentAttributes()) {
                if (!"purapDocumentIdentifier".equals(documentAttribute.getName()) || isAuthorizedToViewPurapDocId || document.getStatus().getCategory().equals((Object)DocumentStatusCategory.SUCCESSFUL)) continue;
                DocumentAttributeString documentAttributeString = new DocumentAttributeString("purapDocumentIdentifier", "********");
                custAttrBuilders.add(documentAttributeString);
                break;
            }
            customResultValues.add(new DocumentSearchResultValue(document.getDocumentId(), custAttrBuilders));
        }
        return new DocumentSearchResultValues(customResultValues);
    }

    public boolean isCustomizeResultsEnabled(String documentTypeName) {
        if ("PO".equalsIgnoreCase(documentTypeName) || "POSP".equalsIgnoreCase(documentTypeName)) {
            return true;
        }
        return super.isCustomizeResultsEnabled(documentTypeName);
    }

    protected boolean isAuthorizedToViewPurapDocId(String principalId) {
        if (StringUtils.isBlank((CharSequence)principalId)) {
            return false;
        }
        String namespaceCode = "KFS-SYS";
        String permissionTemplateName = "Full Unmask Field";
        HashMap roleQualifiers = new HashMap();
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        permissionDetails.put("componentName", "PurchaseOrderDocument");
        permissionDetails.put("propertyName", "purapDocumentIdentifier");
        return this.getPermissionService().isAuthorizedByTemplate(principalId, "KFS-SYS", "Full Unmask Field", permissionDetails, roleQualifiers);
    }

    public PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = (PermissionService)SpringContext.getBean(PermissionService.class);
        }
        return this.permissionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }
}

