/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.identity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.core.api.membership.MemberType;
import org.kuali.kfs.kim.api.KimConstants;
import org.kuali.kfs.kim.api.role.RoleMembership;
import org.kuali.kfs.kim.api.role.RoleService;
import org.kuali.kfs.kns.kim.role.DerivedRoleTypeServiceBase;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.service.PurapService;

public class RelatedDocumentDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase {
    protected static final String SOURCE_DOCUMENT_ROUTER_ROLE_NAME = "Source Document Router";
    protected static final String SENSITIVE_RELATED_DOCUMENT_INITATOR_OR_REVIEWER_ROLE_NAME = "Sensitive Related Document Initiator Or Reviewer";
    private DocumentService documentService;
    private PurapService purapService;
    private RoleService roleService;

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        ArrayList<RoleMembership> members = new ArrayList<RoleMembership>();
        if (qualification != null && !qualification.isEmpty()) {
            if (SOURCE_DOCUMENT_ROUTER_ROLE_NAME.equals(roleName)) {
                PurchasingAccountsPayableDocument sourceDocument;
                PurchasingAccountsPayableDocument document = (PurchasingAccountsPayableDocument)this.documentService.getByDocumentHeaderId(qualification.get("documentNumber"));
                if (document != null && (sourceDocument = document.getPurApSourceDocumentIfPossible()) != null && StringUtils.isNotBlank((CharSequence)sourceDocument.getDocumentHeader().getWorkflowDocument().getRoutedByPrincipalId())) {
                    HashMap<String, String> roleQualifier = new HashMap<String, String>(1);
                    roleQualifier.put("documentNumber", sourceDocument.getDocumentNumber());
                    RoleMembership.Builder roleMember = RoleMembership.Builder.create(null, null, (String)sourceDocument.getDocumentHeader().getWorkflowDocument().getRoutedByPrincipalId(), (MemberType)KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE, roleQualifier);
                    members.add(roleMember.build());
                }
            } else if (SENSITIVE_RELATED_DOCUMENT_INITATOR_OR_REVIEWER_ROLE_NAME.equals(roleName)) {
                for (String documentId : this.purapService.getRelatedDocumentIds(new Integer(qualification.get("accountsPayablePurchasingDocumentLinkIdentifier")))) {
                    HashMap<String, String> tempQualification = new HashMap<String, String>(1);
                    tempQualification.put("documentNumber", documentId);
                    for (String principalId : this.roleService.getRoleMemberPrincipalIds("KFS-WKFLW", "Initiator or Reviewer", tempQualification)) {
                        RoleMembership.Builder roleMember = RoleMembership.Builder.create(null, null, (String)principalId, (MemberType)KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE, tempQualification);
                        members.add(roleMember.build());
                    }
                }
            }
        }
        return members;
    }

    protected DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    protected PurapService getPurapService() {
        return this.purapService;
    }

    public void setPurapService(PurapService purapService) {
        this.purapService = purapService;
    }

    protected RoleService getRoleService() {
        return this.roleService;
    }

    public void setRoleService(RoleService roleService) {
        this.roleService = roleService;
    }
}

