/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.businessobject;

import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.service.SequenceAccessorService;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TravelerType;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;

public class TemProfileTest
extends KualiTestBase {
    private BusinessObjectService businessObjectService;
    private DataDictionaryService dataDictionaryService;
    private SequenceAccessorService sas;

    protected void setUp() throws Exception {
        super.setUp();
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.dataDictionaryService = (DataDictionaryService)SpringContext.getBean(DataDictionaryService.class);
        this.sas = (SequenceAccessorService)SpringContext.getBean(SequenceAccessorService.class);
    }

    @ConfigureContext(shouldCommitTransactions=false)
    public void testOJBConfiguration() throws Exception {
        block2: {
            TemProfile profile = new TemProfile();
            Integer newProfileId = this.sas.getNextAvailableSequenceNumber("TEM_PROFILE_ID_SEQ").intValue();
            profile.setProfileId(newProfileId);
            profile.getTemProfileAddress().setProfileId(newProfileId);
            profile.setCustomerNumber("555555555");
            profile.setPrincipalId("66666666");
            profile.setDateOfBirth(new Date(Date.parse("03/03/1975")));
            profile.setCitizenship("United States");
            profile.setDriversLicenseExpDate(new Date(Date.parse("03/03/2014")));
            profile.setDriversLicenseNumber("B43212345");
            profile.setUpdatedBy("jamey");
            profile.setLastUpdate(new Date(Date.parse("03/03/2011")));
            profile.setGender("M");
            profile.setNonResidentAlien(Boolean.valueOf(false));
            profile.setHomeDeptChartOfAccountsCode("UA");
            profile.setHomeDeptOrgCode("VPIT");
            List travelerTypes = (List)this.businessObjectService.findMatching(TravelerType.class, new HashMap());
            profile.setTravelerType((TravelerType)travelerTypes.get(0));
            profile.setTravelerTypeCode(profile.getTravelerType().getCode());
            this.businessObjectService.save((PersistableBusinessObject)profile);
            HashMap<String, Integer> values = new HashMap<String, Integer>();
            values.put("profileId", profile.getProfileId());
            List profileList = (List)this.businessObjectService.findMatching(TemProfile.class, values);
            try {
                TemProfileTest.assertTrue((boolean)profile.getCustomerNumber().equals(((TemProfile)profileList.get(0)).getCustomerNumber()));
                TemProfileTest.assertTrue((boolean)profile.getPrincipalId().equals(((TemProfile)profileList.get(0)).getPrincipalId()));
                TemProfileTest.assertTrue((boolean)profile.getDateOfBirth().equals(((TemProfile)profileList.get(0)).getDateOfBirth()));
                TemProfileTest.assertTrue((boolean)profile.getCitizenship().equals(((TemProfile)profileList.get(0)).getCitizenship()));
                TemProfileTest.assertTrue((boolean)profile.getDriversLicenseExpDate().equals(((TemProfile)profileList.get(0)).getDriversLicenseExpDate()));
                TemProfileTest.assertTrue((boolean)profile.getDriversLicenseNumber().equals(((TemProfile)profileList.get(0)).getDriversLicenseNumber()));
                TemProfileTest.assertTrue((boolean)profile.getUpdatedBy().equals(((TemProfile)profileList.get(0)).getUpdatedBy()));
                TemProfileTest.assertTrue((boolean)profile.getLastUpdate().equals(((TemProfile)profileList.get(0)).getLastUpdate()));
                TemProfileTest.assertTrue((boolean)profile.getGender().equals(((TemProfile)profileList.get(0)).getGender()));
                TemProfileTest.assertTrue((boolean)profile.getNonResidentAlien().equals(((TemProfile)profileList.get(0)).getNonResidentAlien()));
                TemProfileTest.assertTrue((boolean)profile.getHomeDepartment().equals(((TemProfile)profileList.get(0)).getHomeDepartment()));
            }
            catch (Exception e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }
}

