/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.dataaccess;

import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.module.tem.businessobject.AccountingDocumentRelationship;
import org.kuali.kfs.module.tem.dataaccess.AccountingDocumentRelationshipDao;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;

@ConfigureContext
public class AccountingDocumentRelationshipDaoTest
extends KualiTestBase {
    private AccountingDocumentRelationshipDao dao;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.dao = (AccountingDocumentRelationshipDao)SpringContext.getBean(AccountingDocumentRelationshipDao.class);
        this.dao.save(new AccountingDocumentRelationship("test1", "test2"));
        this.dao.save(new AccountingDocumentRelationship("test2", "test3"));
        this.dao.save(new AccountingDocumentRelationship("test2", "test4"));
    }

    @Test
    public void testSave() {
        AccountingDocumentRelationship adr = new AccountingDocumentRelationship("test1", null);
        this.dao.save(adr);
        AccountingDocumentRelationshipDaoTest.assertNull((Object)adr.getId());
        adr = new AccountingDocumentRelationship("test1", "test2");
        this.dao.save(adr);
        AccountingDocumentRelationshipDaoTest.assertNull((Object)adr.getId());
        adr = new AccountingDocumentRelationship("test4", "test5");
        this.dao.save(adr);
        AccountingDocumentRelationshipDaoTest.assertNotNull((Object)adr.getId());
    }

    @Test
    public void testFindAccountingDocumentRelationshipByDocumentNumber() {
        List adrList = this.dao.findAccountingDocumentRelationshipByDocumentNumber("DOC_NBR", "-1");
        AccountingDocumentRelationshipDaoTest.assertTrue((boolean)adrList.isEmpty());
        adrList = this.dao.findAccountingDocumentRelationshipByDocumentNumber("DOC_NBR", "test1");
        AccountingDocumentRelationshipDaoTest.assertTrue((!adrList.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testFindAccountingDocumentRelationship() {
        AccountingDocumentRelationship adr = new AccountingDocumentRelationship("test2", null);
        List adrList = this.dao.findAccountingDocumentRelationship(adr);
        AccountingDocumentRelationshipDaoTest.assertTrue((adrList.size() == 2 ? 1 : 0) != 0);
        adr.setRelDocumentNumber("test3");
        adrList = this.dao.findAccountingDocumentRelationship(adr);
        AccountingDocumentRelationshipDaoTest.assertTrue((adrList.size() == 1 ? 1 : 0) != 0);
    }
}

