/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.authorization;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TravelerDetail;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.authorization.ReturnToFiscalOfficerAuthorizer;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.service.TemRoleService;
import org.kuali.kfs.module.tem.service.TravelService;
import org.kuali.kfs.module.tem.service.TravelerService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.authorization.AccountingDocumentAuthorizerBase;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.krad.bo.BusinessObject;

public abstract class TravelArrangeableAuthorizer
extends AccountingDocumentAuthorizerBase
implements ReturnToFiscalOfficerAuthorizer {
    private volatile RoleService roleService;
    private volatile BusinessObjectService businessObjectService;

    protected void addRoleQualification(Object dataObject, Map<String, String> qualification) {
        super.addRoleQualification(dataObject, qualification);
        if (dataObject instanceof TravelDocument) {
            TravelDocument document = (TravelDocument)dataObject;
            if (ObjectUtils.isNotNull((Object)document.getProfileId())) {
                qualification.put("profileId", document.getProfileId().toString());
                qualification.put("documentTypeName", document.getDocumentTypeName());
                TemProfile profile = (TemProfile)this.getBusinessObjectService().findBySinglePrimaryKey(TemProfile.class, (Object)document.getProfileId());
                if (profile != null) {
                    if (!qualification.containsKey("chartOfAccountsCode")) {
                        qualification.put("chartOfAccountsCode", profile.getHomeDeptChartOfAccountsCode());
                    }
                    if (!qualification.containsKey("organizationCode")) {
                        qualification.put("organizationCode", profile.getHomeDeptOrgCode());
                    }
                }
            }
            if (ObjectUtils.isNotNull((Object)((Object)document.getTraveler())) && !StringUtils.isBlank((String)document.getTraveler().getPrincipalId())) {
                qualification.put("profilePrincipalId", document.getTraveler().getPrincipalId());
            }
        }
    }

    public boolean canInitiate(String documentTypeName, Person user) {
        String nameSpaceCode = "KR-SYS";
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        HashMap<String, String> qualificationDetails = new HashMap<String, String>();
        qualificationDetails.put("profilePrincipalId", user.getPrincipalId());
        permissionDetails.put("documentTypeName", documentTypeName);
        return TravelArrangeableAuthorizer.getPermissionService().isAuthorizedByTemplate(user.getPrincipalId(), nameSpaceCode, "Initiate Document", permissionDetails, qualificationDetails);
    }

    public boolean canEditDocumentOverview(Document document, Person user) {
        return this.canEditDocument(document, user);
    }

    public boolean canEditDocument(Document document, Person user) {
        return this.isAuthorizedByTemplate((BusinessObject)document, "KR-NS", "Edit Document", user.getPrincipalId());
    }

    public boolean canTaxSelectable(Person user) {
        return TravelArrangeableAuthorizer.getPermissionService().hasPermission(user.getPrincipalId(), "KFS-TEM", "Edit Taxable Indicator");
    }

    @Override
    public boolean canReturnToFisicalOfficer(TravelDocument travelDocument, Person user) {
        if (ObjectUtils.isNull((Object)user)) {
            return false;
        }
        WorkflowDocument workflowDocument = travelDocument.getDocumentHeader().getWorkflowDocument();
        String initiator = workflowDocument.getInitiatorPrincipalId();
        if (initiator.equals(user.getPrincipalId())) {
            return false;
        }
        if (!workflowDocument.isEnroute()) {
            return false;
        }
        Set<String> appDocStatuses = this.getNonReturnToFiscalOfficerDocumentStatuses();
        if (appDocStatuses.contains(travelDocument.getDocumentHeader().getWorkflowDocument().getApplicationDocumentStatus())) {
            return false;
        }
        String nameSpaceCode = "KFS-TEM";
        HashMap<String, String> roleQualifications = new HashMap<String, String>();
        this.addRoleQualification(travelDocument, roleQualifications);
        return TravelArrangeableAuthorizer.getPermissionService().isAuthorized(user.getPrincipalId(), nameSpaceCode, "Return to Fiscal Officer", roleQualifications);
    }

    protected Set<String> getNonReturnToFiscalOfficerDocumentStatuses() {
        HashSet<String> appDocStatuses = new HashSet<String>();
        appDocStatuses.add("In Process");
        appDocStatuses.add("Awaiting Traveler Review");
        appDocStatuses.add("Awaiting Fiscal Officer Review");
        return appDocStatuses;
    }

    protected boolean isFiscalOfficerAuthorizedTo(String permission, String documentTypeName) {
        String fiscalOfficerRoleId = this.getRoleService().getRoleIdByNamespaceCodeAndName("KFS-SYS", "Fiscal Officer");
        List roles = TravelArrangeableAuthorizer.getPermissionService().getRoleIdsForPermission("KFS-TEM", permission);
        return roles != null && roles.size() > 0 && roles.contains(fiscalOfficerRoleId);
    }

    public boolean canCalculate(TravelDocument travelDocument, Person user) {
        return this.canSave((Document)travelDocument, user);
    }

    protected TravelDocumentService getTravelDocumentService() {
        return (TravelDocumentService)SpringContext.getBean(TravelDocumentService.class);
    }

    protected boolean isEmployee(TravelerDetail traveler) {
        return traveler == null ? false : this.getTravelerService().isEmployee(traveler);
    }

    protected TravelerService getTravelerService() {
        return (TravelerService)SpringContext.getBean(TravelerService.class);
    }

    public TravelService getTravelService() {
        return (TravelService)SpringContext.getBean(TravelService.class);
    }

    protected TemRoleService getTemRoleService() {
        return (TemRoleService)SpringContext.getBean(TemRoleService.class);
    }

    protected RoleService getRoleService() {
        if (this.roleService == null) {
            this.roleService = (RoleService)SpringContext.getBean(RoleService.class);
        }
        return this.roleService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }
}

