/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.maintenance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.log4j.Logger;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.batch.service.AgencyDataImportService;
import org.kuali.kfs.module.tem.batch.service.ExpenseImportByTravelerService;
import org.kuali.kfs.module.tem.batch.service.ExpenseImportByTripService;
import org.kuali.kfs.module.tem.businessobject.AgencyStagingData;
import org.kuali.kfs.module.tem.businessobject.CreditCardAgency;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TripAccountingInformation;
import org.kuali.kfs.module.tem.service.CreditCardAgencyService;
import org.kuali.kfs.module.tem.util.MessageUtils;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.FinancialSystemMaintainable;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.principal.Principal;

public class AgencyStagingDataMaintainable
extends FinancialSystemMaintainable {
    static final Logger LOG = Logger.getLogger(AgencyStagingDataMaintainable.class);
    private static volatile AgencyDataImportService agencyDataImportService;
    private static volatile ExpenseImportByTravelerService expenseImportByTravelerService;
    private static volatile ExpenseImportByTripService expenseImportByTripService;
    private static volatile CreditCardAgencyService creditCardAgencyService;
    private static volatile DocumentService documentService;
    private static volatile DataDictionaryService dataDictionaryService;
    private static volatile IdentityService identityService;
    private static volatile NoteService noteService;

    public void processAfterNew(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterNew(document, parameters);
        AgencyStagingData agencyData = (AgencyStagingData)this.getBusinessObject();
        agencyData.setManualCreated(true);
        agencyData.setImportBy("TRP");
        agencyData.setCreationTimestamp(this.getDateTimeService().getCurrentTimestamp());
        agencyData.setProcessingTimestamp(this.getDateTimeService().getCurrentTimestamp());
        agencyData.setErrorCode("OK");
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterCopy(document, parameters);
        AgencyStagingData agencyData = (AgencyStagingData)this.getBusinessObject();
        agencyData.setManualCreated(true);
        agencyData.setCreationTimestamp(this.getDateTimeService().getCurrentTimestamp());
        AgencyStagingDataMaintainable oldMaintainable = (AgencyStagingDataMaintainable)document.getOldMaintainableObject();
        agencyData.setCopiedFromId(((AgencyStagingData)oldMaintainable.getBusinessObject()).getId());
        if (!agencyData.getTripAccountingInformation().isEmpty()) {
            for (TripAccountingInformation account : agencyData.getTripAccountingInformation()) {
                account.setId(null);
                account.setAgencyStagingDataId(null);
            }
        }
    }

    public void doRouteStatusChange(DocumentHeader documentHeader) {
        if (documentHeader.getWorkflowDocument().isProcessed()) {
            AgencyStagingData agencyStaging = (AgencyStagingData)this.getBusinessObject();
            this.updateCreditCardAgency(agencyStaging);
            agencyStaging.setErrorCode("OK");
            List<ErrorMessage> errors = this.getAgencyDataImportService().processAgencyStagingExpense(agencyStaging, this.getGeneralLedgerPendingEntrySequenceHelper());
            LOG.info((Object)("Agency Data Id: " + agencyStaging.getId() + (errors.isEmpty() ? " was" : " was not") + " processed."));
            if (!errors.isEmpty()) {
                try {
                    MaintenanceDocument document = (MaintenanceDocument)this.getDocumentService().getByDocumentHeaderId(documentHeader.getDocumentNumber());
                    this.addNoteAfterProcessingAgencyStagingExpense(document, errors);
                }
                catch (WorkflowException exception) {
                    LOG.error((Object)("Unable to add Note to Document Id: " + documentHeader.getDocumentNumber()), (Throwable)exception);
                    LOG.error((Object)this.getMessageAsString(errors));
                }
            }
        }
        super.doRouteStatusChange(documentHeader);
    }

    protected GeneralLedgerPendingEntrySequenceHelper getGeneralLedgerPendingEntrySequenceHelper() {
        Collection<GeneralLedgerPendingEntry> glpes = this.getAgencyDataImportService().getGeneralLedgerPendingEntriesForDocumentNumber((AgencyStagingData)this.getBusinessObject());
        int maxGLPESequenceValue = 0;
        for (GeneralLedgerPendingEntry glpe : glpes) {
            if (glpe.getTransactionLedgerEntrySequenceNumber() <= maxGLPESequenceValue) continue;
            maxGLPESequenceValue = glpe.getTransactionLedgerEntrySequenceNumber();
        }
        return new GeneralLedgerPendingEntrySequenceHelper(++maxGLPESequenceValue);
    }

    protected void updateCreditCardAgency(AgencyStagingData agencyStaging) {
        CreditCardAgency agency = this.getCreditCardAgencyService().getCreditCardAgencyByCode(agencyStaging.getCreditCardOrAgencyCode());
        if (agency != null) {
            agencyStaging.setCreditCardAgency(agency);
        }
    }

    public void processAfterPost(MaintenanceDocument document, Map<String, String[]> parameters) {
        this.updateCreditCardAgency((AgencyStagingData)document.getNewMaintainableObject().getBusinessObject());
        super.processAfterPost(document, parameters);
    }

    public void processAfterEdit(MaintenanceDocument document, Map<String, String[]> parameters) {
        List<ErrorMessage> errorMessages = null;
        AgencyStagingData agency = (AgencyStagingData)document.getNewMaintainableObject().getBusinessObject();
        if ("TRP".equals(agency.getImportBy())) {
            errorMessages = this.getExpenseImportByTripService().validateAgencyData(agency);
        } else if ("TRV".equals(agency.getImportBy())) {
            errorMessages = this.getExpenseImportByTravelerService().validateAgencyData(agency);
        }
        if (errorMessages.isEmpty()) {
            agency.setErrorCode("OK");
        }
        MessageMap messageMap = GlobalVariables.getMessageMap();
        for (ErrorMessage message : errorMessages) {
            messageMap.putError("GLOBAL_ERRORS", message.getErrorKey(), message.getMessageParameters());
        }
        this.updateCreditCardAgency((AgencyStagingData)document.getNewMaintainableObject().getBusinessObject());
        super.processAfterEdit(document, parameters);
    }

    public void saveBusinessObject() {
        AgencyStagingData agencyStaging = (AgencyStagingData)this.getBusinessObject();
        if (agencyStaging.isActive() && !agencyStaging.getErrorCode().equals("HIS")) {
            agencyStaging.setErrorCode("OK");
        }
        super.saveBusinessObject();
    }

    public void refresh(String refreshCaller, Map fieldValues, MaintenanceDocument document) {
        this.addProfileReferenceToRefresh(refreshCaller, fieldValues);
        super.refresh(refreshCaller, fieldValues, document);
        this.updateFieldsFromProfileRefresh(refreshCaller, fieldValues, document);
    }

    protected void addProfileReferenceToRefresh(String refreshCaller, Map fieldValues) {
        if (StringUtils.isNotEmpty((String)refreshCaller) && refreshCaller.equals("temProfileLookupable")) {
            String referencesToRefresh = "" + fieldValues.get("referencesToRefresh") + "," + "profile";
            fieldValues.put("referencesToRefresh", referencesToRefresh);
        }
    }

    protected void updateFieldsFromProfileRefresh(String refreshCaller, Map fieldValues, MaintenanceDocument document) {
        AgencyStagingDataMaintainable newMaintainable;
        AgencyStagingData agencyData;
        TemProfile profile;
        if (StringUtils.isNotEmpty((String)refreshCaller) && refreshCaller.equals("temProfileLookupable") && ObjectUtils.isNotNull((Object)((Object)(profile = (agencyData = (AgencyStagingData)(newMaintainable = (AgencyStagingDataMaintainable)document.getNewMaintainableObject()).getBusinessObject()).getProfile())))) {
            if (StringUtils.isNotEmpty((String)profile.getEmployeeId())) {
                agencyData.setTravelerId(profile.getEmployeeId());
            } else if (StringUtils.isNotEmpty((String)profile.getCustomerNumber())) {
                agencyData.setTravelerId(profile.getCustomerNumber());
            } else {
                agencyData.setTravelerId("");
            }
            agencyData.setTravelerName(profile.getFirstName() + " " + profile.getLastName());
            if (ObjectUtils.isNotNull((Object)profile.getPrincipal())) {
                agencyData.setTravelerNetworkId(profile.getPrincipal().getPrincipalName());
            } else {
                agencyData.setTravelerNetworkId("");
            }
        }
    }

    protected String trimDescription(String descriptionText) {
        return StringUtils.substring((String)descriptionText, (int)0, (int)39);
    }

    protected void addNoteAfterProcessingAgencyStagingExpense(MaintenanceDocument document, List<ErrorMessage> errors) {
        Principal kfsSystemUser = this.getIdentityService().getPrincipalByPrincipalName("kfs");
        String errorText = this.getMessageAsString(errors);
        if (!StringUtils.isEmpty((String)errorText)) {
            Integer maxLength = this.getDataDictionaryService().getAttributeMaxLength(Note.class, "noteText");
            if (errorText.length() > maxLength) {
                LOG.warn((Object)"Adding a truncated error text to Note due to space limitations. Original text:");
                LOG.warn((Object)errorText);
                errorText = errorText.substring(0, maxLength);
            }
            Note newNote = this.getDocumentService().createNoteFromDocument((Document)document, errorText);
            newNote.setAuthorUniversalIdentifier(kfsSystemUser.getPrincipalId());
            document.addNote(newNote);
            this.getNoteService().save(newNote);
        }
    }

    protected String getMessageAsString(List<ErrorMessage> errorMessages) {
        ArrayList<String> messageList = new ArrayList<String>();
        for (ErrorMessage error : errorMessages) {
            messageList.add(MessageUtils.getErrorMessage(error));
        }
        StrBuilder builder = new StrBuilder();
        builder.appendWithSeparators(messageList, "\n");
        return builder.toString();
    }

    public DateTimeService getDateTimeService() {
        return (DateTimeService)SpringContext.getBean(DateTimeService.class);
    }

    public AgencyDataImportService getAgencyDataImportService() {
        if (agencyDataImportService == null) {
            agencyDataImportService = (AgencyDataImportService)SpringContext.getBean(AgencyDataImportService.class);
        }
        return agencyDataImportService;
    }

    public ExpenseImportByTravelerService getExpenseImportByTravelerService() {
        if (expenseImportByTravelerService == null) {
            expenseImportByTravelerService = (ExpenseImportByTravelerService)SpringContext.getBean(ExpenseImportByTravelerService.class);
        }
        return expenseImportByTravelerService;
    }

    public ExpenseImportByTripService getExpenseImportByTripService() {
        if (expenseImportByTripService == null) {
            expenseImportByTripService = (ExpenseImportByTripService)SpringContext.getBean(ExpenseImportByTripService.class);
        }
        return expenseImportByTripService;
    }

    public CreditCardAgencyService getCreditCardAgencyService() {
        if (creditCardAgencyService == null) {
            creditCardAgencyService = (CreditCardAgencyService)SpringContext.getBean(CreditCardAgencyService.class);
        }
        return creditCardAgencyService;
    }

    public DocumentService getDocumentService() {
        if (documentService == null) {
            documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        }
        return documentService;
    }

    public DataDictionaryService getDataDictionaryService() {
        if (dataDictionaryService == null) {
            dataDictionaryService = (DataDictionaryService)SpringContext.getBean(DataDictionaryService.class);
        }
        return dataDictionaryService;
    }

    public IdentityService getIdentityService() {
        if (identityService == null) {
            identityService = (IdentityService)SpringContext.getBean(IdentityService.class);
        }
        return identityService;
    }

    public NoteService getNoteService() {
        if (noteService == null) {
            noteService = (NoteService)SpringContext.getBean(NoteService.class);
        }
        return noteService;
    }
}

