/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import java.util.List;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.tem.document.TravelAuthorizationAmendmentDocument;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.TravelReimbursementDocument;
import org.kuali.kfs.module.tem.document.service.TravelAuthorizationService;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.document.DocumentStatus;

public class TravelAuthAmendmentValidation
extends GenericValidation {
    TravelAuthorizationService travelAuthorizationService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean validated = true;
        TravelDocument document = (TravelDocument)event.getDocument();
        if (document instanceof TravelAuthorizationAmendmentDocument) {
            List errorPath = GlobalVariables.getMessageMap().getErrorPath();
            GlobalVariables.getMessageMap().clearErrorPath();
            validated &= this.validateSubmissionWithoutEnrouteReimbursement((TravelAuthorizationDocument)document);
            GlobalVariables.getMessageMap().clearErrorPath();
            GlobalVariables.getMessageMap().getErrorPath().addAll(errorPath);
        }
        return validated;
    }

    public boolean validateSubmissionWithoutEnrouteReimbursement(TravelAuthorizationDocument authorization) {
        boolean validated = true;
        TravelReimbursementDocument reimbursement = this.travelAuthorizationService.findEnrouteOrProcessedTravelReimbursement(authorization);
        if (reimbursement != null) {
            validated = false;
            DocumentStatus status = reimbursement.getDocumentHeader().getWorkflowDocument().getStatus();
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.travel.authorization.amendment.enroute.reimbursement", new String[]{reimbursement.getDocumentNumber(), (String)KewApiConstants.DOCUMENT_STATUSES.get(status)});
        }
        return validated;
    }

    public void setTravelAuthorizationService(TravelAuthorizationService travelAuthorizationService) {
        this.travelAuthorizationService = travelAuthorizationService;
    }
}

