/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TemProfileArranger;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.service.TravelArrangerDocumentService;
import org.kuali.kfs.module.tem.service.TemRoleService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class TemRoleServiceImpl
implements TemRoleService {
    public static Logger LOG = Logger.getLogger(TemRoleServiceImpl.class);
    protected RoleService roleService;
    protected BusinessObjectService businessObjectService;
    protected TravelArrangerDocumentService arrangerDocumentService;

    @Override
    public boolean canAccessTravelDocument(TravelDocument travelDocument, Person currentUser) {
        TemProfile profile;
        boolean canAccess = false;
        String initiatorId = travelDocument.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId();
        if (initiatorId.equals(currentUser.getPrincipalId())) {
            canAccess = true;
        } else if (ObjectUtils.isNotNull((Object)travelDocument.getTemProfileId()) && ObjectUtils.isNotNull((Object)((Object)(profile = (TemProfile)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findBySinglePrimaryKey(TemProfile.class, (Object)travelDocument.getTemProfileId()))))) {
            if (currentUser.getPrincipalId().equals(profile.getPrincipalId())) {
                canAccess = true;
            } else {
                String profileId = travelDocument.getTemProfileId().toString();
                String documentType = travelDocument.getDocumentTypeName();
                if (this.isTravelArranger(currentUser, profile.getHomeDepartment(), profileId, documentType)) {
                    canAccess = true;
                }
            }
        }
        return canAccess;
    }

    @Override
    public boolean isArrangerForProfile(String principalId, int profileId) {
        boolean isArranger = false;
        if (ObjectUtils.isNotNull((Object)profileId) && ObjectUtils.isNotNull((Object)principalId)) {
            isArranger = ObjectUtils.isNotNull((Object)((Object)this.arrangerDocumentService.findTemProfileArranger(principalId, profileId)));
        }
        return isArranger;
    }

    @Override
    public boolean isTravelDocumentArrangerForProfile(String documentType, String principalId, Integer profileId) {
        boolean isTravelArranger = false;
        TemProfileArranger arranger = this.arrangerDocumentService.findTemProfileArranger(principalId, profileId);
        if (arranger != null) {
            if (TemConstants.TravelDocTypes.getAuthorizationDocTypes().contains(documentType)) {
                isTravelArranger = arranger.getTaInd();
            } else if (TemConstants.TravelDocTypes.getReimbursementDocTypes().contains(documentType)) {
                isTravelArranger = arranger.getTrInd();
            }
        }
        return isTravelArranger;
    }

    @Override
    public boolean isProfileArranger(String arrangerId) {
        boolean isProfileArranger = false;
        if (StringUtils.isNotBlank((String)arrangerId)) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("principalId", arrangerId);
            ArrayList profileArrangers = new ArrayList(this.businessObjectService.findMatching(TemProfileArranger.class, fieldValues));
            isProfileArranger = ObjectUtils.isNotNull(profileArrangers) && !profileArrangers.isEmpty();
        }
        return isProfileArranger;
    }

    @Override
    public boolean isProfileAdmin(Person currentUser, String homeDepartment) {
        boolean hasAdminRole = this.checkUserRole(currentUser, "TEM Profile Administrator", "KFS-TEM", null);
        boolean hasOrgRole = this.checkOrganizationRole(currentUser, "TEM Profile Administrator", "KFS-TEM", homeDepartment);
        return hasAdminRole && hasOrgRole;
    }

    @Override
    public boolean isTravelArranger(Person user, String primaryDepartmentCode, String profileId, String documentType) {
        HashMap<String, String> qualification = new HashMap<String, String>();
        if (this.isProfileAlsoUser(user, profileId)) {
            qualification.put("profilePrincipalId", user.getPrincipalId());
        } else {
            qualification.put("profileId", profileId);
        }
        qualification.put("documentTypeName", documentType);
        boolean checkProfileAssignedRole = this.checkUserRole(user, "TEM Assigned Profile Arranger", "KFS-TEM", qualification);
        boolean checkOrgRole = this.checkOrganizationRole(user, "TEM Organization Profile Arranger", "KFS-TEM", primaryDepartmentCode);
        return checkProfileAssignedRole || checkOrgRole;
    }

    protected boolean isProfileAlsoUser(Person user, String profileId) {
        TemProfile profile = this.getProfile(profileId);
        return profile != null && StringUtils.equals((String)profile.getPrincipalId(), (String)user.getPrincipalId());
    }

    protected TemProfile getProfile(String profileId) {
        TemProfile profile;
        if (!StringUtils.isBlank((String)profileId) && (profile = (TemProfile)this.businessObjectService.findBySinglePrimaryKey(TemProfile.class, (Object)profileId)) != null && profile.isActive()) {
            return profile;
        }
        return null;
    }

    @Override
    public boolean isTravelArranger(Person user) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("principalId", user.getPrincipalId());
        fieldValues.put("active", "Y");
        int count = this.businessObjectService.countMatching(TemProfileArranger.class, fieldValues);
        boolean isArranger = count > 0;
        boolean checkOrgRole = this.checkOrganizationRole(user, "TEM Organization Profile Arranger", "KFS-TEM", null);
        return isArranger || checkOrgRole;
    }

    @Override
    public boolean isTravelManager(Person user) {
        return this.checkUserRole(user, "Travel Manager", "KFS-SYS", null);
    }

    @Override
    public boolean checkUserRole(Person user, String role, String parameterNamespace, Map<String, String> qualification) {
        try {
            ArrayList<String> roleIds = new ArrayList<String>();
            roleIds.add(this.roleService.getRoleIdByNamespaceCodeAndName(parameterNamespace, role));
            return this.roleService.principalHasRole(user.getPrincipalId(), roleIds, qualification);
        }
        catch (NullPointerException e) {
            LOG.error((Object)e);
            return false;
        }
    }

    @Override
    public boolean checkOrganizationRole(Person user, String role, String parameterNamespace, String primaryDepartmentCode) {
        try {
            String[] split;
            ArrayList<String> roleIds = new ArrayList<String>();
            roleIds.add(this.roleService.getRoleIdByNamespaceCodeAndName(parameterNamespace, role));
            HashMap<String, String> qualification = null;
            String organizationCode = null;
            if (StringUtils.isNotEmpty((String)primaryDepartmentCode) && (split = primaryDepartmentCode.split("-")) != null) {
                String chartOfAccounts = split[0];
                qualification = new HashMap<String, String>();
                qualification.put("chartOfAccountsCode", chartOfAccounts);
                qualification.put("performQualifierMatch", "True");
                if (split.length == 2) {
                    organizationCode = split[1];
                    qualification.put("organizationCode", organizationCode);
                }
            }
            if (this.roleService.principalHasRole(user.getPrincipalId(), roleIds, qualification)) {
                return true;
            }
        }
        catch (NullPointerException e) {
            LOG.error((Object)e);
        }
        return false;
    }

    @Override
    public Collection<RoleMembership> getTravelArrangers(String chartCode, String orgCode) {
        HashMap<String, String> qualification = new HashMap<String, String>();
        qualification.put("chartOfAccountsCode", chartCode);
        qualification.put("organizationCode", orgCode);
        qualification.put("descendHierarchy", "Y");
        RoleService roleService = KimApiServiceLocator.getRoleService();
        String roleId = roleService.getRoleIdByNamespaceCodeAndName("KFS-TEM", "TEM Organization Profile Arranger");
        List roleMemberships = roleService.getRoleMembers(Collections.singletonList(roleId), qualification);
        return roleMemberships;
    }

    public void setRoleService(RoleService roleService) {
        this.roleService = roleService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setArrangerDocumentService(TravelArrangerDocumentService travelArrangerDocumentService) {
        this.arrangerDocumentService = travelArrangerDocumentService;
    }
}

