/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.web;

import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kfs.krad.keyvalues.KeyValuesFinder;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.tem.businessobject.AccountingDocumentRelationship;
import org.kuali.kfs.module.tem.document.service.AccountingDocumentRelationshipService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public final class JstlFunctions {
    protected static final String SETTING_PARAMS_PROLOG = "Setting params ";
    protected static final String PROPERTY_SETTING_EXC_PROLOG = "Could not set property ";
    protected static final String IN_PREPOSITION = " in ";
    protected static final String VALUES_FINDER_CLASS_EXC_PROLOG = "Could not find valuesFinder class ";
    protected static final Log LOG = LogFactory.getLog(JstlFunctions.class);

    private JstlFunctions() {
    }

    public static List getOptionList(String valuesFinderClassName, Map params) {
        return JstlFunctions.setupValuesFinder(valuesFinderClassName, params).getKeyValues();
    }

    private static KeyValuesFinder setupValuesFinder(String valuesFinderClassName, Map<String, Object> params) {
        KeyValuesFinder retval = JstlFunctions.getKeyFinder(valuesFinderClassName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(SETTING_PARAMS_PROLOG + params));
        }
        JstlFunctions.addParametersToFinder(params, retval);
        return retval;
    }

    private static void addParametersToFinder(Map<String, Object> params, KeyValuesFinder finder) {
        if (finder != null && params != null) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                try {
                    BeanUtils.setProperty((Object)finder, (String)entry.getKey(), (Object)entry.getValue());
                }
                catch (Exception e) {
                    JstlFunctions.warn(PROPERTY_SETTING_EXC_PROLOG + entry.getKey(), e);
                    e.printStackTrace();
                }
            }
        }
    }

    private static KeyValuesFinder getKeyFinder(String valuesFinderClassName) {
        KeyValuesFinder retval = null;
        try {
            retval = (KeyValuesFinder)Class.forName(valuesFinderClassName).newInstance();
        }
        catch (ClassNotFoundException e) {
            JstlFunctions.warnAboutValueFinderClassExceptions(valuesFinderClassName, e);
        }
        catch (InstantiationException e) {
            JstlFunctions.warnAboutValueFinderClassExceptions(valuesFinderClassName, e);
        }
        catch (IllegalAccessException e) {
            JstlFunctions.warnAboutValueFinderClassExceptions(valuesFinderClassName, e);
        }
        return retval;
    }

    private static void warnAboutValueFinderClassExceptions(String valuesFinderClassName, Exception e) {
        JstlFunctions.warn(VALUES_FINDER_CLASS_EXC_PROLOG + valuesFinderClassName, e);
    }

    private static void warn(String message, Exception e) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)new StringBuilder(message).append(IN_PREPOSITION).append(JstlFunctions.buildTraceMessage(e)));
        }
    }

    private static String buildTraceMessage(Throwable thrownObj) {
        StackTraceElement stackTraceElement = thrownObj.getStackTrace()[0];
        return stackTraceElement.getClassName() + "#" + stackTraceElement.getMethodName() + ":" + stackTraceElement.getLineNumber() + " " + thrownObj.getClass().getSimpleName() + "\n" + thrownObj.getMessage();
    }

    public static Boolean canDeleteDocumentRelationship(String documentNumber, String relDocumentNumber) {
        AccountingDocumentRelationshipService accountingDocumentRelationshipService = (AccountingDocumentRelationshipService)SpringContext.getBean(AccountingDocumentRelationshipService.class);
        List<AccountingDocumentRelationship> adrList = accountingDocumentRelationshipService.find(new AccountingDocumentRelationship(documentNumber, relDocumentNumber));
        if (adrList != null && adrList.size() == 1) {
            return adrList.get(0).getPrincipalId().equals(GlobalVariables.getUserSession().getPerson().getPrincipalId());
        }
        return false;
    }

    public static KualiDecimal add(Object a, Object b) {
        KualiDecimal tempA = new KualiDecimal(0);
        KualiDecimal tempB = new KualiDecimal(0);
        if (a instanceof Double) {
            tempA = new KualiDecimal(((Double)a).doubleValue());
        } else if (a instanceof Integer) {
            tempA = new KualiDecimal(((Integer)a).intValue());
        } else if (a instanceof String) {
            tempA = new KualiDecimal((String)a);
        } else if (a instanceof KualiDecimal) {
            tempA = (KualiDecimal)a;
        }
        if (b instanceof Double) {
            tempB = new KualiDecimal(((Double)b).doubleValue());
        } else if (b instanceof Integer) {
            tempB = new KualiDecimal(((Integer)b).intValue());
        } else if (a instanceof String) {
            tempB = new KualiDecimal((String)b);
        } else if (b instanceof KualiDecimal) {
            tempB = (KualiDecimal)b;
        }
        return (KualiDecimal)tempA.add((AbstractKualiDecimal)tempB);
    }
}

