/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.service.impl;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TemProfileAccount;
import org.kuali.kfs.module.tem.businessobject.TemProfileAddress;
import org.kuali.kfs.module.tem.service.TemProfileService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kim.api.identity.Person;

public class MockTemProfileServiceImpl
implements TemProfileService {
    protected TemProfileService realTemProfileService;
    protected DateTimeService dateTimeService;
    public static final int VALID_TEM_PROFILE_ID = 37;

    public TemProfile findTemProfileByEmployeeId(String employeeId) {
        if (StringUtils.equals((String)employeeId, (String)"987654321") || StringUtils.equals((String)employeeId, (String)"ABC1234")) {
            return null;
        }
        return this.createTemProfileForEmployee(employeeId);
    }

    public TemProfile findTemProfileByCustomerNumber(String customerNumber) {
        if (StringUtils.equals((String)customerNumber, (String)"987654321")) {
            return null;
        }
        return this.createTemProfileForCustomer(customerNumber);
    }

    protected TemProfile createTemProfileForEmployee(String employeeId) {
        TemProfile profile = new TemProfile();
        profile.setProfileId(Integer.valueOf(37));
        profile.getTemProfileAddress().setProfileId(Integer.valueOf(37));
        profile.setEmployeeId(employeeId);
        profile.setDefaultChartCode("BL");
        profile.setDefaultAccount("1031400");
        profile.setDefaultSubAccount("ADV");
        profile.setDefaultProjectCode("KUL");
        profile.setDateOfBirth(this.dateTimeService.getCurrentSqlDate());
        profile.setGender("M");
        profile.setHomeDeptOrgCode("BL");
        profile.setHomeDeptChartOfAccountsCode("BL");
        return profile;
    }

    protected TemProfile createTemProfileForCustomer(String customerNumber) {
        TemProfile profile = new TemProfile();
        profile.setProfileId(Integer.valueOf(37));
        profile.getTemProfileAddress().setProfileId(Integer.valueOf(37));
        profile.setCustomerNumber(customerNumber);
        profile.setDefaultChartCode("BL");
        profile.setDefaultAccount("1031400");
        profile.setDefaultSubAccount("ADV");
        profile.setDefaultProjectCode("KUL");
        profile.setDateOfBirth(this.dateTimeService.getCurrentSqlDate());
        profile.setGender("M");
        profile.setHomeDeptOrgCode("BL");
        profile.setHomeDeptChartOfAccountsCode("BL");
        return profile;
    }

    public void setProfileService(TemProfileService temProfileService) {
        this.realTemProfileService = temProfileService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public TemProfileAddress createTemProfileAddressFromPerson(Person person, Integer profileId, TemProfileAddress defaultAddress) {
        return this.realTemProfileService.createTemProfileAddressFromPerson(person, profileId, defaultAddress);
    }

    public TemProfile findTemProfile(Map<String, String> criteria) {
        return this.realTemProfileService.findTemProfile(criteria);
    }

    public TemProfile findTemProfileById(Integer profileId) {
        return this.realTemProfileService.findTemProfileById(profileId);
    }

    public TemProfile findTemProfileByPrincipalId(String principalId) {
        return this.realTemProfileService.findTemProfileByPrincipalId(principalId);
    }

    public TemProfileAddress getAddressFromProfile(TemProfile profile, TemProfileAddress defaultAddress) {
        return this.realTemProfileService.getAddressFromProfile(profile, defaultAddress);
    }

    public List<TemProfile> getAllActiveTemProfile() {
        return this.realTemProfileService.getAllActiveTemProfile();
    }

    public void updateACHAccountInfo(TemProfile profile) {
        this.realTemProfileService.updateACHAccountInfo(profile);
    }

    public boolean hasActiveArrangers(TemProfile profile) {
        return this.realTemProfileService.hasActiveArrangers(profile);
    }

    public boolean isProfileNonEmploye(TemProfile profile) {
        return this.realTemProfileService.isProfileNonEmploye(profile);
    }

    public List<KeyValue> getGenderKeyValues() {
        return this.realTemProfileService.getGenderKeyValues();
    }

    public boolean doesProfileAccountExist(TemProfileAccount account, TemProfile skipProfile) {
        return this.realTemProfileService.doesProfileAccountExist(account, skipProfile);
    }
}

