/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.batch;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.module.tem.batch.businessobject.PerDiemForLoad;
import org.kuali.kfs.module.tem.batch.service.PerDiemLoadService;
import org.kuali.kfs.module.tem.batch.service.PerDiemLoadValidationService;
import org.kuali.kfs.sys.batch.XmlBatchInputFileTypeBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.exception.ParseException;
import org.kuali.kfs.sys.exception.XmlErrorHandler;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.springframework.core.io.UrlResource;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class PerDiemXmlInputFileType
extends XmlBatchInputFileTypeBase {
    private static Logger LOG = Logger.getLogger(PerDiemXmlInputFileType.class);
    private DateTimeService dateTimeService;
    private String fileNamePrefix;

    public String getFileName(String principalName, Object parsedFileContents, String fileUserIdentifier) {
        StringBuilder fileName = new StringBuilder();
        fileUserIdentifier = StringUtils.deleteWhitespace((String)fileUserIdentifier);
        fileUserIdentifier = StringUtils.remove((String)fileUserIdentifier, (String)"_");
        fileName.append(this.getFileNamePrefix()).append("_");
        fileName.append(principalName).append("_");
        fileName.append(fileUserIdentifier).append("_");
        fileName.append(this.dateTimeService.toDateTimeStringForFilename(this.dateTimeService.getCurrentDate()));
        return fileName.toString();
    }

    public String getFileTypeIdentifer() {
        return "perDiemXmlInputFileType";
    }

    public Object parse(byte[] fileByteContent) throws ParseException {
        List<PerDiemForLoad> perDiemList = (List<PerDiemForLoad>)super.parse(fileByteContent);
        PerDiemLoadService perDiemLoadService = (PerDiemLoadService)SpringContext.getBean(PerDiemLoadService.class);
        perDiemList = perDiemLoadService.updatePerDiem(perDiemList);
        return perDiemList;
    }

    public boolean validate(Object parsedFileContents) {
        PerDiemLoadValidationService perDiemLoadValidationService = (PerDiemLoadValidationService)SpringContext.getBean(PerDiemLoadValidationService.class);
        List perDiemList = (List)parsedFileContents;
        return perDiemLoadValidationService.validate(perDiemList);
    }

    public String getAuthorPrincipalName(File file) {
        return StringUtils.substringBetween((String)file.getName(), (String)this.getFileNamePrefix(), (String)"_");
    }

    public String getTitleKey() {
        return "message.batchUpload.title.per.diem.xml.file";
    }

    protected void validateContentsAgainstSchema(String schemaLocation, InputStream fileContents) throws ParseException {
        try {
            UrlResource schemaResource = new UrlResource(schemaLocation);
            StreamSource schemaSource = new StreamSource(schemaResource.getInputStream());
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = factory.newSchema(schemaSource);
            Validator validator = schema.newValidator();
            validator.setErrorHandler((ErrorHandler)new XmlErrorHandler());
            Source source = this.transform(fileContents);
            validator.validate(source);
        }
        catch (MalformedURLException e2) {
            LOG.error((Object)("error getting schema url: " + e2.getMessage()));
            throw new RuntimeException("error getting schema url:  " + e2.getMessage(), e2);
        }
        catch (SAXException e) {
            LOG.error((Object)("error encountered while parsing xml " + e.getMessage()));
            throw new ParseException("Schema validation error occured while processing file: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e1) {
            LOG.error((Object)("error occured while validating file contents: " + e1.getMessage()));
            throw new RuntimeException("error occurred while validating file contents: " + e1.getMessage(), e1);
        }
    }

    protected Source transform(InputStream fileContents) {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(fileContents);
            document.getDocumentElement().setAttribute("xmlns", "http://www.kuali.org/kfs/tem/perDiem");
            DOMSource domSource = new DOMSource(document);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            StreamResult streamResult = new StreamResult(outputStream);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(domSource, streamResult);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            return new StreamSource(inputStream);
        }
        catch (TransformerConfigurationException ex) {
            LOG.error((Object)("error occurred while validating file contents: " + ex.getMessage()));
            throw new RuntimeException("error occurred while validating file contents: " + ex.getMessage(), ex);
        }
        catch (TransformerException ex) {
            LOG.error((Object)("error occurred while validating file contents: " + ex.getMessage()));
            throw new RuntimeException("error occurred while validating file contents: " + ex.getMessage(), ex);
        }
        catch (SAXException e) {
            LOG.error((Object)("error encountered while parsing xml " + e.getMessage()));
            throw new ParseException("Schema validation error occured while processing file: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e1) {
            LOG.error((Object)("error occured while validating file contents: " + e1.getMessage()));
            throw new RuntimeException("error occurred while validating file contents: " + e1.getMessage(), e1);
        }
        catch (ParserConfigurationException ex) {
            LOG.error((Object)("error occurred while validating file contents: " + ex.getMessage()));
            throw new RuntimeException("error occurred while validating file contents: " + ex.getMessage(), ex);
        }
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public String getFileNamePrefix() {
        return this.fileNamePrefix;
    }

    public void setFileNamePrefix(String fileNamePrefix) {
        this.fileNamePrefix = fileNamePrefix;
    }
}

