/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.dataaccess.impl;

import java.util.List;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.kuali.kfs.krad.util.OjbCollectionAware;
import org.kuali.kfs.module.tem.businessobject.AccountingDocumentRelationship;
import org.kuali.kfs.module.tem.dataaccess.AccountingDocumentRelationshipDao;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class AccountingDocumentRelationshipDaoOjb
extends PlatformAwareDaoBaseOjb
implements AccountingDocumentRelationshipDao,
OjbCollectionAware {
    private static final Logger LOG = Logger.getLogger(AccountingDocumentRelationshipDaoOjb.class);

    @Override
    public List<AccountingDocumentRelationship> findAccountingDocumentRelationshipByDocumentNumber(String value) {
        return this.findAccountingDocumentRelationshipByDocumentNumber(null, value);
    }

    @Override
    public List<AccountingDocumentRelationship> findAccountingDocumentRelationshipByDocumentNumber(String attribute, String value) {
        if (value != null) {
            Criteria c = new Criteria();
            if (attribute != null) {
                c.addEqualTo(attribute, (Object)value);
            } else {
                c.addEqualTo("DOC_NBR", (Object)value);
                Criteria c2 = new Criteria();
                c2.addEqualTo("REL_DOC_NBR", (Object)value);
                c.addOrCriteria(c2);
            }
            return this.find(c);
        }
        return null;
    }

    @Override
    public List<AccountingDocumentRelationship> findAccountingDocumentRelationship(AccountingDocumentRelationship adr) {
        if (adr != null) {
            Criteria c = new Criteria();
            if (adr.getId() != null) {
                c.addEqualTo("ID", (Object)adr.getId());
            }
            if (adr.getDocumentNumber() != null) {
                c.addEqualTo("DOC_NBR", (Object)adr.getDocumentNumber());
            }
            if (adr.getRelDocumentNumber() != null) {
                c.addEqualTo("REL_DOC_NBR", (Object)adr.getRelDocumentNumber());
            }
            return this.find(c);
        }
        return null;
    }

    private List<AccountingDocumentRelationship> find(Criteria c) {
        LOG.debug((Object)("Creating query for type AccountingDocumentRelationship.class using criteria " + c));
        QueryByCriteria query = QueryFactory.newQuery(AccountingDocumentRelationship.class, (Criteria)c);
        List results = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        return results;
    }

    @Override
    public void save(AccountingDocumentRelationship accountingDocumentRelationship) {
        if (accountingDocumentRelationship.getDocumentNumber() != null && accountingDocumentRelationship.getRelDocumentNumber() != null && !accountingDocumentRelationship.getDocumentNumber().equals(accountingDocumentRelationship.getRelDocumentNumber())) {
            accountingDocumentRelationship.refresh();
            List<AccountingDocumentRelationship> adrList = this.findAccountingDocumentRelationship(accountingDocumentRelationship);
            if (!adrList.isEmpty()) {
                if (adrList.size() > 1) {
                    LOG.error((Object)"Found multiple AccountingDocumentRelationships with the same data. This should never happen.");
                }
                return;
            }
            adrList = this.findAccountingDocumentRelationship(new AccountingDocumentRelationship(accountingDocumentRelationship.getRelDocumentNumber(), accountingDocumentRelationship.getDocumentNumber()));
            if (!adrList.isEmpty()) {
                if (adrList.size() > 1) {
                    LOG.error((Object)"Found multiple AccountingDocumentRelationships with the same data. This should never happen.");
                }
                return;
            }
            this.getPersistenceBrokerTemplate().store((Object)accountingDocumentRelationship);
        } else {
            LOG.warn((Object)("Bad accountingDocumentRelationship. " + accountingDocumentRelationship.toStringMapper_RICE20_REFACTORME()));
        }
    }

    @Override
    public void delete(AccountingDocumentRelationship accountingDocumentRelationship) {
        accountingDocumentRelationship.refresh();
        this.getPersistenceBrokerTemplate().delete((Object)accountingDocumentRelationship);
    }
}

