/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document;

import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.module.tem.businessobject.CreditCardAgency;
import org.kuali.kfs.module.tem.businessobject.TemProfileAccount;
import org.kuali.kfs.module.tem.document.CardApplicationDocument;
import org.kuali.kfs.module.tem.document.CardApplicationDocumentBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.web.format.DateFormatter;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;

public class TemCTSCardApplicationDocument
extends CardApplicationDocumentBase
implements CardApplicationDocument {
    protected static Logger LOG = Logger.getLogger(TemCTSCardApplicationDocument.class);
    private java.sql.Date bankAppliedDate;
    private java.sql.Date bankApprovedDate;

    public java.sql.Date getBankAppliedDate() {
        return this.bankAppliedDate;
    }

    public void setBankAppliedDate(java.sql.Date bankAppliedDate) {
        this.bankAppliedDate = bankAppliedDate;
    }

    public java.sql.Date getBankApprovedDate() {
        return this.bankApprovedDate;
    }

    public void setBankApprovedDate(java.sql.Date bankApprovedDate) {
        this.bankApprovedDate = bankApprovedDate;
    }

    @Override
    public void applyToBank() {
        Calendar cal = Calendar.getInstance();
        this.setBankAppliedDate(new java.sql.Date(cal.getTimeInMillis()));
    }

    @Override
    public void approvedByBank() {
        Calendar cal = Calendar.getInstance();
        this.setBankApprovedDate(new java.sql.Date(cal.getTimeInMillis()));
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        DocumentStatus status = this.getDocumentHeader().getWorkflowDocument().getStatus();
        if (status.equals((Object)DocumentStatus.PROCESSED)) {
            TemProfileAccount profileAccount = new TemProfileAccount();
            Calendar cal = Calendar.getInstance();
            profileAccount.setEffectiveDate(new java.sql.Date(cal.getTimeInMillis()));
            String code = this.getParameterService().getParameterValueAsString(TemCTSCardApplicationDocument.class, "CENTRAL_TRAVEL_SYSTEM_CARD_CODE");
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("creditCardOrAgencyCode", code);
            List creditCardAgencyList = (List)this.getBusinessObjectService().findMatching(CreditCardAgency.class, fieldValues);
            CreditCardAgency creditCardAgency = (CreditCardAgency)((Object)creditCardAgencyList.get(0));
            profileAccount.setCreditCardAgency(creditCardAgency);
            profileAccount.setCreditCardOrAgencyCode(creditCardAgency.getCreditCardOrAgencyCode());
            profileAccount.setName(creditCardAgency.getCreditCardOrAgencyName());
            profileAccount.setActive(true);
            profileAccount.setAccountNumber(this.temProfile.getEmployeeId());
            String text = this.getConfigurationService().getPropertyValueAsString("message.tem.card.note.text");
            DateFormatter formatter = new DateFormatter();
            String note = MessageFormat.format(text, formatter.format((Object)new Date()), this.getDocumentHeader().getDocumentNumber());
            profileAccount.setNote(note);
            this.getTemProfile().getAccounts().add(profileAccount);
            this.getBusinessObjectService().save((PersistableBusinessObject)this.temProfile);
        }
    }

    @Override
    public String getUserAgreementText() {
        return ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("message.tem.cts.card.document.user.agreement");
    }
}

