/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.service;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kuali.kfs.integration.ar.AccountsReceivableOrganizationOptions;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.uif.field.LinkField;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.businessobject.ExpenseTypeAware;
import org.kuali.kfs.module.tem.businessobject.GroupTraveler;
import org.kuali.kfs.module.tem.businessobject.PerDiem;
import org.kuali.kfs.module.tem.businessobject.PerDiemExpense;
import org.kuali.kfs.module.tem.businessobject.SpecialCircumstances;
import org.kuali.kfs.module.tem.businessobject.TemExpense;
import org.kuali.kfs.module.tem.businessobject.TemSourceAccountingLine;
import org.kuali.kfs.module.tem.businessobject.TransportationModeDetail;
import org.kuali.kfs.module.tem.businessobject.TravelAdvance;
import org.kuali.kfs.module.tem.businessobject.TripType;
import org.kuali.kfs.module.tem.document.TEMReimbursementDocument;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.TravelReimbursementDocument;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;

public interface TravelDocumentService {
    public String getMessageFrom(String var1, String ... var2);

    public List<SpecialCircumstances> findActiveSpecialCircumstances(String var1, String var2);

    public List<TravelAuthorizationDocument> findAuthorizationDocuments(String var1);

    public List<String> findAuthorizationDocumentNumbers(String var1);

    public List<TravelReimbursementDocument> findReimbursementDocuments(String var1);

    public void updatePerDiemItemsFor(TravelDocument var1, List<PerDiemExpense> var2, Integer var3, Timestamp var4, Timestamp var5);

    public Map<String, List<Document>> getDocumentsRelatedTo(TravelDocument var1) throws WorkflowException;

    public Map<String, List<Document>> getDocumentsRelatedTo(String var1) throws WorkflowException;

    public List<Document> getDocumentsRelatedTo(TravelDocument var1, String ... var2);

    @Deprecated
    public void addAdHocFYIRecipient(Document var1);

    public void addAdHocFYIRecipient(Document var1, String var2);

    public void addAdHocRecipient(Document var1, String var2, String var3);

    public void routeToFiscalOfficer(TravelDocument var1, String var2) throws WorkflowException, Exception;

    public PerDiemExpense copyPerDiemExpense(PerDiemExpense var1);

    public KualiDecimal calculateMileage(ActualExpense var1);

    public void handleNewActualExpense(ActualExpense var1);

    public Map<String, KualiDecimal> calculateDailyTotal(PerDiemExpense var1);

    public List<Map<String, KualiDecimal>> calculateDailyTotals(List<PerDiemExpense> var1);

    public void copyDownPerDiemExpense(TravelDocument var1, int var2, List<PerDiemExpense> var3);

    public boolean isHostedMeal(ExpenseTypeAware var1);

    public boolean isTravelManager(Person var1);

    public Integer calculateProratePercentage(PerDiemExpense var1, String var2, Timestamp var3);

    public boolean isOpen(TravelDocument var1);

    public boolean isProcessed(TravelDocument var1);

    public boolean isFinal(TravelDocument var1);

    public boolean isTravelAuthorizationProcessed(TravelAuthorizationDocument var1);

    public boolean isTravelAuthorizationOpened(TravelAuthorizationDocument var1);

    public boolean isUnsuccessful(TravelDocument var1);

    public Integer calculatePerDiemPercentageFromTimestamp(PerDiemExpense var1, Timestamp var2);

    public KualiDecimal getAmountDueFromInvoice(String var1, KualiDecimal var2);

    public TravelAuthorizationDocument findCurrentTravelAuthorization(TravelDocument var1);

    public TravelDocument findRootForTravelReimbursement(String var1);

    public KualiDecimal getTotalCumulativeReimbursements(TravelDocument var1);

    public KualiDecimal getTotalAuthorizedEncumbrance(TravelDocument var1);

    public boolean isResponsibleForAccountsOn(TravelDocument var1, String var2);

    public boolean checkNonEmployeeTravelerTypeCode(String var1);

    public String getAllStates(String var1);

    public List<GroupTraveler> copyGroupTravelers(List<GroupTraveler> var1, String var2);

    public List<? extends TemExpense> copyActualExpenses(List<? extends TemExpense> var1, String var2);

    public List<PerDiemExpense> copyPerDiemExpenses(List<PerDiemExpense> var1, String var2);

    public List<TravelAdvance> copyTravelAdvances(List<TravelAdvance> var1, String var2);

    public List<SpecialCircumstances> copySpecialCircumstances(List<SpecialCircumstances> var1, String var2);

    public List<TransportationModeDetail> copyTransportationModeDetails(List<TransportationModeDetail> var1, String var2);

    public void showNoTravelAuthorizationError(TravelReimbursementDocument var1);

    public KualiDecimal getAdvancesTotalFor(TravelDocument var1);

    public List<TravelAdvance> getOutstandingTravelAdvanceByInvoice(Set<String> var1);

    public String retrieveAddressFromLocationCode(String var1);

    public void detachImportedExpenses(TravelDocument var1);

    public void attachImportedExpenses(TravelDocument var1);

    public boolean checkHoldGLPEs(TravelDocument var1);

    public void revertOriginalDocument(TravelDocument var1, String var2);

    public Date findLatestTaxableRamificationNotificationDate();

    public boolean validateSourceAccountingLines(TravelDocument var1, boolean var2);

    public String getDocumentType(TravelDocument var1);

    public List<KeyValue> getMileageRateKeyValues(Date var1);

    public List<GroupTraveler> importGroupTravelers(TravelDocument var1, String var2) throws Exception;

    public <T> List<T> importFile(String var1, Class<T> var2, String[] var3, Map<String, List<String>> var4, Integer[] var5, String var6);

    public List<TravelAdvance> getTravelAdvancesForTrip(String var1);

    public AccountsReceivableOrganizationOptions getOrgOptions();

    public void disableDuplicateExpenses(TravelDocument var1, ActualExpense var2);

    public void setPerDiemMealsAndIncidentals(PerDiemExpense var1, PerDiem var2, TripType var3, Timestamp var4, boolean var5);

    public TravelDocument getParentTravelDocument(String var1);

    public TravelDocument getRootTravelDocumentWithoutWorkflowDocument(String var1);

    public Collection<String> getApprovedTravelDocumentNumbersByTrip(String var1);

    public boolean isDocumentStatusValidForReconcilingCharges(TravelDocument var1);

    public List<String> findMatchingTrips(TravelDocument var1);

    public void restorePerDiemProperty(TravelDocument var1, String var2);

    public List<TemSourceAccountingLine> smooshAccountingLinesToSubAccount(List<TemSourceAccountingLine> var1);

    public List<LinkField> getAgencyLinks(TravelDocument var1);

    public String customizeAgencyLink(TravelDocument var1, String var2, String var3);

    public boolean requiresTravelerApproval(TEMReimbursementDocument var1);

    public boolean requiresTravelerApproval(TravelAuthorizationDocument var1);

    public boolean isInitiatorTraveler(TravelDocument var1);
}

