/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.service.impl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.kuali.kfs.kns.web.ui.Column;
import org.kuali.kfs.krad.comparator.NumericValueComparator;
import org.kuali.kfs.krad.comparator.StringValueComparator;
import org.kuali.kfs.krad.comparator.TemporalValueComparator;
import org.kuali.kfs.module.tem.businessobject.AgencyEntryFull;
import org.kuali.kfs.module.tem.document.TemCorrectionProcessDocument;
import org.kuali.kfs.module.tem.document.service.TemCorrectionDocumentService;
import org.kuali.kfs.module.tem.document.web.struts.TemCorrectionForm;

public class TemCorrectionDocumentServiceImpl
implements TemCorrectionDocumentService {
    private List<Column> cachedColumns = null;
    protected String batchFileDirectoryName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Column> getTableRenderColumnMetadata(String docId) {
        TemCorrectionDocumentServiceImpl temCorrectionDocumentServiceImpl = this;
        synchronized (temCorrectionDocumentServiceImpl) {
            if (this.cachedColumns == null) {
                this.cachedColumns = new ArrayList<Column>();
                Column columnToAdd = new Column();
                columnToAdd.setColumnTitle("Agency Code");
                columnToAdd.setPropertyName("creditCardOrAgencyCode");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Agency");
                columnToAdd.setPropertyName("agency");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Merchant Name");
                columnToAdd.setPropertyName("merchantName");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Trip Invoice #");
                columnToAdd.setPropertyName("tripInvoiceNumber");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Traveler Name");
                columnToAdd.setPropertyName("travelerName");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Traveler ID");
                columnToAdd.setPropertyName("travelerId");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Expense Amount");
                columnToAdd.setPropertyName("tripExpenseAmount");
                columnToAdd.setValueComparator((Comparator)NumericValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Arranger Name");
                columnToAdd.setPropertyName("tripArrangerName");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Departure Date");
                columnToAdd.setPropertyName("tripDepartureDate");
                columnToAdd.setValueComparator((Comparator)TemporalValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Air Book Date");
                columnToAdd.setPropertyName("airBookDate");
                columnToAdd.setValueComparator((Comparator)TemporalValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Air Carrier Code");
                columnToAdd.setPropertyName("airCarrierCode");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Air Ticket Number");
                columnToAdd.setPropertyName("airTicketNumber");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("PNR Number");
                columnToAdd.setPropertyName("pnrNumber");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Unique Id");
                columnToAdd.setPropertyName("transactionUniqueId");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Posting Date");
                columnToAdd.setPropertyName("transactionPostingDate");
                columnToAdd.setValueComparator((Comparator)TemporalValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                this.cachedColumns = Collections.unmodifiableList(this.cachedColumns);
            }
        }
        return this.cachedColumns;
    }

    @Override
    public void persistAgencyEntryGroupsForDocumentSave(TemCorrectionProcessDocument document, TemCorrectionForm correctionForm) {
        try {
            FileWriter out = new FileWriter(this.getBatchFileDirectoryName() + File.separator + correctionForm.getInputGroupId());
            XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
            XMLStreamWriter writer = xmlOutputFactory.createXMLStreamWriter(out);
            writer.writeStartDocument();
            writer.writeStartElement("agencyData");
            for (AgencyEntryFull agency : correctionForm.getAllEntries()) {
                writer.writeStartElement("record");
                writer.writeStartElement("creditCardOrAgencyCode");
                writer.writeCharacters(agency.getCreditCardOrAgencyCode());
                writer.writeEndElement();
                writer.writeStartElement("agency");
                writer.writeCharacters(agency.getAgency());
                writer.writeEndElement();
                writer.writeStartElement("agencyFileName");
                writer.writeCharacters(agency.getAgencyFileName());
                writer.writeEndElement();
                writer.writeStartElement("merchantName");
                writer.writeCharacters(agency.getMerchantName());
                writer.writeEndElement();
                writer.writeStartElement("tripInvoiceNumber");
                writer.writeCharacters(agency.getTripInvoiceNumber());
                writer.writeEndElement();
                writer.writeStartElement("travelerName");
                writer.writeCharacters(agency.getTravelerName());
                writer.writeEndElement();
                writer.writeStartElement("travelerId");
                writer.writeCharacters(agency.getTravelerId());
                writer.writeEndElement();
                writer.writeStartElement("tripExpenseAmount");
                writer.writeCharacters(agency.getTripExpenseAmount().toString());
                writer.writeEndElement();
                writer.writeStartElement("tripArrangerName");
                writer.writeCharacters(agency.getTripArrangerName());
                writer.writeEndElement();
                writer.writeStartElement("tripDepartureDate");
                writer.writeCharacters(agency.getTripDepartureDate().toString());
                writer.writeEndElement();
                writer.writeStartElement("airBookDate");
                writer.writeCharacters(agency.getAirBookDate().toString());
                writer.writeEndElement();
                writer.writeStartElement("airCarrierCode");
                writer.writeCharacters(agency.getAirCarrierCode());
                writer.writeEndElement();
                writer.writeStartElement("airTicketNumber");
                writer.writeCharacters(agency.getAirTicketNumber());
                writer.writeEndElement();
                writer.writeStartElement("pnrNumber");
                writer.writeCharacters(agency.getPnrNumber());
                writer.writeEndElement();
                writer.writeStartElement("transactionUniqueId");
                writer.writeCharacters(agency.getTransactionUniqueId());
                writer.writeEndElement();
                writer.writeStartElement("transactionPostingDate");
                writer.writeCharacters(agency.getTransactionPostingDate().toString());
                writer.writeEndElement();
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.close();
            out.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not write XML for agency groups", ioe);
        }
        catch (XMLStreamException xmlse) {
            throw new RuntimeException("Could not write XML for agency groups", xmlse);
        }
    }

    @Override
    public String getBatchFileDirectoryName() {
        return this.batchFileDirectoryName;
    }

    public void setBatchFileDirectoryName(String batchFileDirectoryName) {
        this.batchFileDirectoryName = batchFileDirectoryName;
    }
}

