/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.businessobject.ImportedExpense;
import org.kuali.kfs.module.tem.businessobject.TemExpense;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class TemExpenseTotalsValidation
extends GenericValidation {
    public boolean validate(AttributedDocumentEvent event) {
        KualiDecimal total;
        String property;
        boolean rulePassed = true;
        TravelDocument travelDocument = (TravelDocument)event.getDocument();
        GlobalVariables.getMessageMap().addToErrorPath("document");
        int counter = 0;
        for (ActualExpense actualExpense : travelDocument.getActualExpenses()) {
            property = "actualExpenses[" + counter + "]";
            total = actualExpense.getTotalDetailExpenseAmount();
            if (!total.isZero()) {
                if (total.isGreaterThan((AbstractKualiDecimal)actualExpense.getExpenseAmount())) {
                    GlobalVariables.getMessageMap().putError(property + "." + "expenseAmount", "error.document.detail.greater.than.expense", new String[0]);
                    rulePassed = false;
                } else if (total.isLessThan((AbstractKualiDecimal)actualExpense.getExpenseAmount())) {
                    GlobalVariables.getMessageMap().putError(property + "." + "expenseAmount", "error.document.detail.less.than.expense", new String[0]);
                    rulePassed = false;
                }
            }
            ++counter;
        }
        counter = 0;
        for (ImportedExpense importedExpense : travelDocument.getImportedExpenses()) {
            property = "importedExpenses[" + counter + "]";
            total = KualiDecimal.ZERO;
            for (TemExpense temExpense : importedExpense.getExpenseDetails()) {
                total = (KualiDecimal)total.add((AbstractKualiDecimal)temExpense.getExpenseAmount());
            }
            if (!total.isZero()) {
                if (total.isGreaterThan((AbstractKualiDecimal)importedExpense.getExpenseAmount())) {
                    GlobalVariables.getMessageMap().putError(property + "." + "expenseAmount", "error.document.detail.greater.than.expense", new String[0]);
                    rulePassed = false;
                } else if (total.isLessThan((AbstractKualiDecimal)importedExpense.getExpenseAmount())) {
                    GlobalVariables.getMessageMap().putError(property + "." + "expenseAmount", "error.document.detail.less.than.expense", new String[0]);
                    rulePassed = false;
                }
            }
            ++counter;
        }
        GlobalVariables.getMessageMap().clearErrorPath();
        return rulePassed;
    }
}

