/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.TemSourceAccountingLine;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.document.service.DebitDeterminerService;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class TravelAdvanceAccountingTotalsValidation
extends GenericValidation {
    protected DebitDeterminerService debitDeterminerService;

    public boolean validate(AttributedDocumentEvent event) {
        KualiDecimal accountingLineTotal;
        TravelAuthorizationDocument documentForValidation = (TravelAuthorizationDocument)event.getDocument();
        boolean success = true;
        if (!ObjectUtils.isNull((Object)((Object)documentForValidation.getTravelAdvance())) && documentForValidation.getTravelAdvance().isAtLeastPartiallyFilledIn() && !(accountingLineTotal = this.calculateAdvanceAccountingLineTotal(documentForValidation)).equals((Object)documentForValidation.getTravelAdvance().getTravelAdvanceRequested())) {
            GlobalVariables.getMessageMap().putError("advanceAccountingLines[0].amount", "error.travelAuthorization.advanceAccountingLines.travelAdvanceRequested.notEqual", new String[]{documentForValidation.getTravelAdvance().getTravelAdvanceRequested().toString(), accountingLineTotal.toString()});
            success = false;
        }
        return success;
    }

    protected KualiDecimal calculateAdvanceAccountingLineTotal(TravelAuthorizationDocument document) {
        KualiDecimal accountingLineTotal = KualiDecimal.ZERO;
        for (TemSourceAccountingLine advanceAccountingLine : document.getAdvanceAccountingLines()) {
            if (document.isDebit((GeneralLedgerPendingEntrySourceDetail)advanceAccountingLine)) {
                accountingLineTotal = (KualiDecimal)accountingLineTotal.add((AbstractKualiDecimal)advanceAccountingLine.getAmount());
                continue;
            }
            accountingLineTotal = (KualiDecimal)accountingLineTotal.subtract((AbstractKualiDecimal)advanceAccountingLine.getAmount());
        }
        return accountingLineTotal;
    }

    public DebitDeterminerService getDebitDeterminerService() {
        return this.debitDeterminerService;
    }

    public void setDebitDeterminerService(DebitDeterminerService debitDeterminerService) {
        this.debitDeterminerService = debitDeterminerService;
    }
}

