/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.web.struts;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.AgencyStagingData;
import org.kuali.kfs.module.tem.businessobject.ExpenseType;
import org.kuali.kfs.module.tem.businessobject.ExpenseTypeObjectCode;
import org.kuali.kfs.module.tem.businessobject.HistoricalTravelExpense;
import org.kuali.kfs.module.tem.businessobject.ImportedExpense;
import org.kuali.kfs.module.tem.businessobject.TemSourceAccountingLine;
import org.kuali.kfs.module.tem.businessobject.TripAccountingInformation;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.document.validation.event.AddImportedExpenseLineEvent;
import org.kuali.kfs.module.tem.document.web.bean.TravelMvcWrapperBean;
import org.kuali.kfs.module.tem.service.AccountingDistributionService;
import org.kuali.kfs.module.tem.service.TravelExpenseService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class AddImportedExpenseEvent
implements Observer {
    protected volatile TravelExpenseService travelExpenseService;

    @Override
    public void update(Observable arg0, Object arg1) {
        if (!(arg1 instanceof TravelMvcWrapperBean)) {
            return;
        }
        TravelMvcWrapperBean wrapper = (TravelMvcWrapperBean)arg1;
        TravelDocument document = wrapper.getTravelDocument();
        ImportedExpense newImportedExpenseLine = wrapper.getNewImportedExpenseLine();
        boolean rulePassed = true;
        if (rulePassed &= this.getRuleService().applyRules(new AddImportedExpenseLineEvent<ImportedExpense>("newImportedExpenseLine", (Document)document, newImportedExpenseLine))) {
            if (newImportedExpenseLine != null) {
                document.addExpense(newImportedExpenseLine);
            }
            ImportedExpense newExpense = new ImportedExpense();
            try {
                BeanUtils.copyProperties((Object)newExpense, (Object)newImportedExpenseLine);
                newExpense.setConvertedAmount(null);
                newExpense.setExpenseParentId(newExpense.getId());
                newExpense.setId(null);
                newExpense.setNotes(null);
                newExpense.setExpenseLineTypeCode(null);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Could not copy properties to imported line detail", ex);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException("Could not copy properties to imported line detail", ex);
            }
            wrapper.setNewImportedExpenseLine(new ImportedExpense());
            wrapper.getNewImportedExpenseLines().add(newExpense);
            wrapper.setDistribution(this.getAccountingDistributionService().buildDistributionFrom(document));
            if (newImportedExpenseLine.getCardType() != null && newImportedExpenseLine.getCardType().equals("CTS")) {
                HistoricalTravelExpense historicalTravelExpense = (HistoricalTravelExpense)this.getBusinessObjectService().findBySinglePrimaryKey(HistoricalTravelExpense.class, (Object)newImportedExpenseLine.getHistoricalTravelExpenseId());
                historicalTravelExpense.refreshReferenceObject("agencyStagingData");
                ArrayList<TripAccountingInformation> tripAccountInfoList = historicalTravelExpense.getAgencyStagingData().getTripAccountingInformation();
                ExpenseTypeObjectCode expenseTypeObjectCode = this.findExpenseTypeObjectCodeForAgencyStagingData(document, historicalTravelExpense.getAgencyStagingData());
                for (TripAccountingInformation tripAccountingInformation : tripAccountInfoList) {
                    TemSourceAccountingLine importedLine = new TemSourceAccountingLine();
                    importedLine.setAmount(ObjectUtils.isNotNull((Object)tripAccountingInformation.getAmount()) ? tripAccountingInformation.getAmount() : (KualiDecimal)historicalTravelExpense.getAmount().divide((AbstractKualiDecimal)new KualiDecimal(tripAccountInfoList.size())));
                    importedLine.setChartOfAccountsCode(tripAccountingInformation.getTripChartCode());
                    importedLine.setAccountNumber(tripAccountingInformation.getTripAccountNumber());
                    importedLine.setSubAccountNumber(tripAccountingInformation.getTripSubAccountNumber());
                    if (expenseTypeObjectCode != null) {
                        importedLine.setFinancialObjectCode(expenseTypeObjectCode.getFinancialObjectCode());
                    }
                    importedLine.setFinancialSubObjectCode(tripAccountingInformation.getSubObjectCode());
                    importedLine.setProjectCode(tripAccountingInformation.getProjectCode());
                    importedLine.setOrganizationReferenceId(tripAccountingInformation.getOrganizationReference());
                    importedLine.setCardType("CTS");
                    importedLine.getPostingYear();
                    importedLine.refresh();
                    document.addSourceAccountingLine(importedLine);
                }
            }
        }
    }

    protected ExpenseTypeObjectCode findExpenseTypeObjectCodeForAgencyStagingData(TravelDocument document, AgencyStagingData agencyStagingData) {
        String documentType = document.getDocumentTypeName();
        String tripType = StringUtils.isBlank((String)document.getTripTypeCode()) ? "All" : document.getTripTypeCode();
        String travelerType = ObjectUtils.isNull((Object)((Object)document.getTraveler())) || StringUtils.isBlank((String)document.getTraveler().getTravelerTypeCode()) ? "All" : document.getTraveler().getTravelerTypeCode();
        ExpenseType expenseType = this.getTravelExpenseService().getDefaultExpenseTypeForCategory(agencyStagingData.getExpenseTypeCategory());
        if (expenseType == null) {
            return null;
        }
        ExpenseTypeObjectCode expenseTypeObjectCode = this.getTravelExpenseService().getExpenseType(expenseType.getCode(), documentType, tripType, travelerType);
        return expenseTypeObjectCode;
    }

    protected TravelDocumentService getTravelDocumentService() {
        return (TravelDocumentService)SpringContext.getBean(TravelDocumentService.class);
    }

    protected BusinessObjectService getBusinessObjectService() {
        return (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
    }

    protected KualiRuleService getRuleService() {
        return (KualiRuleService)SpringContext.getBean(KualiRuleService.class);
    }

    protected AccountingDistributionService getAccountingDistributionService() {
        return (AccountingDistributionService)SpringContext.getBean(AccountingDistributionService.class);
    }

    protected TravelExpenseService getTravelExpenseService() {
        if (this.travelExpenseService == null) {
            this.travelExpenseService = (TravelExpenseService)SpringContext.getBean(TravelExpenseService.class);
        }
        return this.travelExpenseService;
    }
}

