/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.web.struts;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForward;
import org.kuali.kfs.krad.bo.AdHocRoutePerson;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.dao.DocumentDao;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.document.web.struts.Inquisitive;
import org.kuali.kfs.module.tem.document.web.struts.QuestionHandler;
import org.kuali.kfs.module.tem.document.web.struts.StrutsInquisitor;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class HoldQuestionHandler
implements QuestionHandler<TravelDocument> {
    protected ConfigurationService ConfigurationService;
    protected DataDictionaryService dataDictionaryService;
    protected TravelDocumentService travelDocumentService;
    protected DocumentService documentService;
    protected DocumentDao documentDao;
    protected NoteService noteService;

    @Override
    public <T> T handleResponse(Inquisitive<TravelDocument, ?> asker) throws Exception {
        if (asker.denied("HoldTa")) {
            return (T)asker.back();
        }
        if (asker.confirmed("ConfirmHold")) {
            return (T)asker.end();
        }
        String introNoteMessage = "Note entered while placing Travel Authorization on hold :  ";
        StringBuilder noteText = new StringBuilder(introNoteMessage + asker.getReason());
        int noteTextLength = noteText.length();
        int noteTextMaxLength = this.getDataDictionaryService().getAttributeMaxLength(Note.class, "noteText");
        if (StringUtils.isBlank((String)asker.getReason()) || noteTextLength > noteTextMaxLength) {
            int reasonLimit = noteTextMaxLength - noteTextLength;
            reasonLimit = reasonLimit < 0 ? reasonLimit * -1 : reasonLimit;
            String message = this.getMessageFrom("travelAuthorization.question.text");
            String question = StringUtils.replace((String)message, (String)"{0}", (String)"Hold");
            if (StringUtils.isBlank((String)asker.getReason())) {
                return (T)asker.confirm("HoldTa", question, true, "error.travelAuthorization.reasonRequired", "reason", "Hold");
            }
            return (T)asker.confirm("HoldTa", question, true, "error.travelAuthorization.reason.pastLimit", "reason", new Integer(reasonLimit).toString());
        }
        String messageType = "travelAuthorization.route.message.hold.text";
        TravelDocument document = asker.getDocument();
        ActionForward returnActionForward = ((StrutsInquisitor)asker).getMapping().findForward("basic");
        Note newNote = this.getDocumentService().createNoteFromDocument((Document)document, noteText.toString());
        document.addNote(newNote);
        this.getNoteService().save(newNote);
        document.updateAndSaveAppDocStatus("Reimbursement On Hold");
        TravelAuthorizationDocument authorization = (TravelAuthorizationDocument)document;
        String principalId = GlobalVariables.getUserSession().getPrincipalId();
        authorization.setHoldRequestorprincipalId(principalId);
        this.getDocumentDao().save((Document)document);
        this.getTravelDocumentService().addAdHocFYIRecipient((Document)document, document.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId());
        this.getTravelDocumentService().addAdHocFYIRecipient((Document)document, document.getTraveler().getPrincipalId());
        ((WorkflowDocumentService)SpringContext.getBean(WorkflowDocumentService.class)).sendWorkflowNotification(document.getDocumentHeader().getWorkflowDocument(), null, new ArrayList(document.getAdHocRoutePersons()));
        if (ObjectUtils.isNotNull((Object)returnActionForward)) {
            return (T)returnActionForward;
        }
        return (T)asker.confirm("ConfirmHold", this.getMessageFrom("travelAuthorization.route.message.hold.text"), true, "temSingleConfirmationQuestion", "HoldTa", "");
    }

    @Override
    public <T> T askQuestion(Inquisitive<TravelDocument, ?> asker) throws Exception {
        String reason = asker.getReason();
        String key = this.getMessageFrom("travelAuthorization.question.text");
        String question = StringUtils.replace((String)key, (String)"{0}", (String)"Hold");
        Object retval = asker.confirm("HoldTa", question, true, new String[0]);
        return (T)retval;
    }

    public String getMessageFrom(String messageType) {
        return this.getConfigurationService().getPropertyValueAsString(messageType);
    }

    public void setConfigurationService(ConfigurationService ConfigurationService2) {
        this.ConfigurationService = ConfigurationService2;
    }

    protected ConfigurationService getConfigurationService() {
        return this.ConfigurationService;
    }

    public void setTravelDocumentService(TravelDocumentService travelDocumentService) {
        this.travelDocumentService = travelDocumentService;
    }

    protected TravelDocumentService getTravelDocumentService() {
        return this.travelDocumentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    protected DocumentService getDocumentService() {
        return (DocumentService)SpringContext.getBean(DocumentService.class);
    }

    public void setDocumentDao(DocumentDao documentDao) {
        this.documentDao = documentDao;
    }

    protected DocumentDao getDocumentDao() {
        return this.documentDao;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    protected DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public NoteService getNoteService() {
        return this.noteService;
    }

    public void setNoteService(NoteService noteService) {
        this.noteService = noteService;
    }

    protected AdHocRoutePerson buildFyiRecipient(String userName) {
        AdHocRoutePerson adHocRoutePerson = new AdHocRoutePerson();
        adHocRoutePerson.setActionRequested("F");
        adHocRoutePerson.setId(userName);
        return adHocRoutePerson;
    }
}

