/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.web.struts;

import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.document.web.bean.TravelMvcWrapperBean;
import org.kuali.kfs.module.tem.service.AccountingDistributionService;
import org.kuali.kfs.module.tem.util.ExpenseUtils;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class RemoveActualExpenseDetailEvent
implements Observer {
    public static Logger LOG = Logger.getLogger(RemoveActualExpenseDetailEvent.class);
    private static final int WRAPPER_ARG_IDX = 0;
    private static final int SELECTED_LINE_ARG_IDX = 1;
    private static final int SELECTED_DETAIL_LINE_ARG_IDX = 2;

    @Override
    public void update(Observable arg0, Object arg1) {
        if (!(arg1 instanceof Object[])) {
            return;
        }
        Object[] args = (Object[])arg1;
        LOG.debug(args[0]);
        if (!(args[0] instanceof TravelMvcWrapperBean)) {
            return;
        }
        TravelMvcWrapperBean wrapper = (TravelMvcWrapperBean)args[0];
        TravelDocument document = wrapper.getTravelDocument();
        Integer deleteIndex = (Integer)args[1];
        Integer deleteDetailIndex = (Integer)args[2];
        ActualExpense line = document.getActualExpenses().get(deleteIndex);
        document.removeExpenseDetail(line, deleteDetailIndex);
        List<ActualExpense> actualExpenses = wrapper.getNewActualExpenseLines();
        KualiDecimal detailTotal = line.getTotalDetailExpenseAmount();
        if (detailTotal.isLessThan((AbstractKualiDecimal)line.getExpenseAmount())) {
            KualiDecimal remainderExpense = (KualiDecimal)line.getExpenseAmount().subtract((AbstractKualiDecimal)detailTotal);
            KualiDecimal remainderConverted = (KualiDecimal)line.getConvertedAmount().subtract((AbstractKualiDecimal)new KualiDecimal(detailTotal.bigDecimalValue().multiply(line.getCurrencyRate())));
            wrapper.getNewActualExpenseLines().get(deleteIndex).setExpenseAmount(remainderExpense);
            wrapper.getNewActualExpenseLines().get(deleteIndex).setConvertedAmount(remainderConverted);
        }
        ExpenseUtils.calculateMileage(document, document.getActualExpenses());
        for (String disabledProperty : document.getDisabledProperties().keySet()) {
            this.getTravelDocumentService().restorePerDiemProperty(document, disabledProperty);
        }
        wrapper.setDistribution(this.getAccountingDistributionService().buildDistributionFrom(document));
        document.getDisabledProperties().clear();
    }

    protected TravelDocumentService getTravelDocumentService() {
        return (TravelDocumentService)SpringContext.getBean(TravelDocumentService.class);
    }

    protected KualiRuleService getRuleService() {
        return (KualiRuleService)SpringContext.getBean(KualiRuleService.class);
    }

    protected AccountingDistributionService getAccountingDistributionService() {
        return (AccountingDistributionService)SpringContext.getBean(AccountingDistributionService.class);
    }
}

