/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.identity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.kns.kim.role.DerivedRoleTypeServiceBase;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.businessobject.TemProfileArranger;
import org.kuali.kfs.module.tem.document.service.TravelArrangerDocumentService;
import org.kuali.rice.kim.api.role.RoleMembership;

public class ArrangerDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase {
    protected TravelArrangerDocumentService arrangerDocumentService;

    public boolean hasDerivedRole(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        if (qualification != null && !qualification.isEmpty()) {
            String profileId = qualification.get("profileId");
            String documentType = qualification.get("documentTypeName");
            if (!StringUtils.isBlank((String)profileId)) {
                Integer profIdAsInt = new Integer(profileId);
                TemProfileArranger arranger = this.getArrangerDocumentService().findTemProfileArranger(principalId, profIdAsInt);
                if (arranger != null) {
                    if (!StringUtils.isBlank((String)documentType)) {
                        if (TemConstants.TravelDocTypes.getAuthorizationDocTypes().contains(documentType)) {
                            return arranger.getTaInd();
                        }
                        if (TemConstants.TravelDocTypes.getReimbursementDocTypes().contains(documentType)) {
                            return arranger.getTrInd();
                        }
                        if (documentType.equals("TTP") && arranger.getPrincipalId().equals(principalId)) {
                            return true;
                        }
                    } else if (arranger.getPrincipalId().equals(principalId)) {
                        return true;
                    }
                }
            } else {
                String profilePrincipalId = qualification.get("profilePrincipalId");
                if (!StringUtils.isBlank((String)profilePrincipalId)) {
                    return this.getArrangerDocumentService().hasArrangees(profilePrincipalId);
                }
            }
        }
        if (StringUtils.isNotBlank((String)principalId) && (qualification == null || !qualification.containsKey("profileId") || qualification.get("profileId") == null)) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("principalId", principalId);
            fieldValues.put("active", "Y");
            Collection arrangers = this.getBusinessObjectService().findMatching(TemProfileArranger.class, fieldValues);
            return ObjectUtils.isNotNull((Object)arrangers) && !arrangers.isEmpty();
        }
        return false;
    }

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        this.validateRequiredAttributesAgainstReceived(qualification);
        ArrayList<RoleMembership> members = new ArrayList<RoleMembership>(1);
        return members;
    }

    public TravelArrangerDocumentService getArrangerDocumentService() {
        return this.arrangerDocumentService;
    }

    public void setArrangerDocumentService(TravelArrangerDocumentService arrangerDocumentService) {
        this.arrangerDocumentService = arrangerDocumentService;
    }
}

