/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.service.impl;

import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.AccountingDistribution;
import org.kuali.kfs.module.tem.businessobject.TemExpense;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.service.TemExpenseService;
import org.kuali.kfs.module.tem.service.impl.ExpenseServiceBase;
import org.kuali.kfs.module.tem.util.ExpenseUtils;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class ActualExpenseServiceImpl
extends ExpenseServiceBase
implements TemExpenseService {
    public static Logger LOG = Logger.getLogger(ActualExpenseServiceImpl.class);

    @Override
    public void calculateDistributionTotals(TravelDocument document, Map<String, AccountingDistribution> distributionMap, List<? extends TemExpense> expenses) {
        for (TemExpense temExpense : expenses) {
            ObjectCode objCode;
            if (temExpense.getExpenseDetails() != null && temExpense.getExpenseDetails().size() > 0) {
                this.calculateDistributionTotals(document, distributionMap, temExpense.getExpenseDetails());
                continue;
            }
            if (ObjectUtils.isNull((Object)((Object)temExpense.getExpenseTypeObjectCode())) || temExpense.getExpenseTypeObjectCode().getExpenseType().isPrepaidExpense() || temExpense.getNonReimbursable().booleanValue()) continue;
            boolean skipDistribution = false;
            String financialObjectCode = null;
            if (document.isTravelAuthorizationDoc()) {
                if (((TravelAuthorizationDocument)document).isTripGenerateEncumbrance()) {
                    financialObjectCode = document.getTripType().getEncumbranceObjCode();
                } else {
                    skipDistribution = true;
                }
            } else {
                String string = financialObjectCode = !ObjectUtils.isNull((Object)((Object)temExpense.getExpenseTypeObjectCode())) ? temExpense.getExpenseTypeObjectCode().getFinancialObjectCode() : null;
            }
            if ((objCode = this.getObjectCodeService().getByPrimaryIdForCurrentYear(ExpenseUtils.getDefaultChartCode(document), financialObjectCode)) == null || skipDistribution) continue;
            AccountingDistribution distribution = null;
            String key = objCode.getCode() + "-" + document.getDefaultCardTypeCode();
            if (distributionMap.containsKey(key)) {
                distributionMap.get(key).setSubTotal((KualiDecimal)distributionMap.get(key).getSubTotal().add((AbstractKualiDecimal)temExpense.getConvertedAmount()));
                distributionMap.get(key).setRemainingAmount((KualiDecimal)distributionMap.get(key).getRemainingAmount().add((AbstractKualiDecimal)temExpense.getConvertedAmount()));
                continue;
            }
            distribution = new AccountingDistribution();
            distribution.setObjectCode(objCode.getCode());
            distribution.setObjectCodeName(objCode.getName());
            distribution.setCardType(document.getDefaultCardTypeCode());
            distribution.setRemainingAmount(temExpense.getConvertedAmount());
            distribution.setSubTotal(temExpense.getConvertedAmount());
            distributionMap.put(key, distribution);
            LOG.debug((Object)("Subtotal distribution " + distribution.getSubTotal()));
        }
    }

    @Override
    public List<? extends TemExpense> getExpenseDetails(TravelDocument document) {
        return document.getActualExpenses();
    }

    @Override
    public void processExpense(TravelDocument travelDocument, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
    }

    @Override
    public void updateExpense(TravelDocument travelDocument) {
    }
}

