/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.businessobject;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.module.tem.businessobject.AgencyStagingData;
import org.kuali.kfs.module.tem.businessobject.TripAccountingInformation;
import org.kuali.kfs.module.tem.businessobject.defaultvalue.NextAgencyStagingDataIdFinder;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class AgencyStagingDataTest
extends KualiTestBase {
    private BusinessObjectService businessObjectService;
    private DataDictionaryService dataDictionaryService;
    private DateTimeService dateTimeService;
    private NextAgencyStagingDataIdFinder idFinder;

    protected void setUp() throws Exception {
        super.setUp();
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.dataDictionaryService = (DataDictionaryService)SpringContext.getBean(DataDictionaryService.class);
        this.dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
        this.idFinder = new NextAgencyStagingDataIdFinder();
    }

    @ConfigureContext(shouldCommitTransactions=false)
    public void testOJBConfiguration() throws Exception {
        block4: {
            Date date = this.dateTimeService.getCurrentSqlDate();
            Timestamp time = this.dateTimeService.getCurrentTimestamp();
            KualiDecimal amount = new KualiDecimal(1234.56);
            KualiDecimal maxAmount = new KualiDecimal(999999.99);
            String longText = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec id egestas lorem. Integer tempor sed.";
            ArrayList<TripAccountingInformation> tripAccountingInformation = new ArrayList<TripAccountingInformation>();
            for (int i = 0; i < 3; ++i) {
                TripAccountingInformation accountInfo = new TripAccountingInformation();
                accountInfo.setTripAccountNumber("1234567");
                accountInfo.setTripSubAccountNumber("12345");
                accountInfo.setObjectCode("1234");
                accountInfo.setSubObjectCode("123");
                accountInfo.setProjectCode("1234567890");
                accountInfo.setOrganizationReference("12345678");
                tripAccountingInformation.add(accountInfo);
            }
            AgencyStagingData agency = new AgencyStagingData();
            agency.setId(Integer.valueOf(this.idFinder.getValue()));
            agency.setErrorCode("errorcode");
            agency.setAgencyDataId(Integer.valueOf(123456789));
            agency.setCreditCardOrAgencyCode("abcd");
            agency.setAgency("agency");
            agency.setOtherCompanyName("other company name");
            agency.setAgencyFileName("FL Name");
            agency.setMerchantName("merchant name");
            agency.setBillingCycleDate(date);
            agency.setTripId("abcdef123456");
            agency.setTripInvoiceNumber("invoice1234");
            agency.setTripTravelerTypeId("1");
            agency.setOtherAmount(amount);
            agency.setTravelerName("Traveler Name");
            agency.setTravelerId("1");
            agency.setTravelerNetworkId("123456789");
            agency.setTripExpenseAmount(maxAmount);
            agency.setAlternateTripId(null);
            agency.setTripArrangerName("Arranger Name");
            agency.setTripAccountingInformation(tripAccountingInformation);
            agency.setGroupObjectCode("Group Obj Code");
            agency.setDistributionCode("Code");
            agency.setTripDepartureDate(date);
            agency.setTripReturnDate(date);
            agency.setFareSaverCode("C");
            agency.setAirBookDate(date);
            agency.setAirCarrierCode("SWA");
            agency.setAirTicketNumber("air 1234");
            agency.setPnrNumber("PNR-1234567890");
            agency.setAirTicketClass("class 1");
            agency.setAirTransactionAmount(amount);
            agency.setAirBaseFareAmount(maxAmount);
            agency.setAirTaxAmount(amount);
            agency.setAirLowFareAmount(maxAmount);
            agency.setAirReasonCode("R");
            agency.setAirSegmentId(longText);
            agency.setAirDestinationCode("LIH");
            agency.setAirServiceFeeNumber("12345678901234567890");
            agency.setAirServiceFeeAmount(amount);
            agency.setTransactionUniqueId("unique#98765");
            agency.setLodgingItineraryNumber("L123456");
            agency.setLodgingPrepayDate(date);
            agency.setLodgingAmount(maxAmount);
            agency.setLodgingPrepayDaysNumber("365");
            agency.setLodgingPropertyName("St. Regis Princeville Resort");
            agency.setTripLodgingArrivalDate(date);
            agency.setLodgingDepartureDate(date);
            agency.setLodgingBookingDate(date);
            agency.setLodgingPropertyCityName("Princeville");
            agency.setLodgingPropertyStateCode("HI");
            agency.setLodgingCountryName("US");
            agency.setRentalCarItineraryNumber("rentalCar1234");
            agency.setRentalCarAmount(amount);
            agency.setRentalCarNumberOfDays("365");
            agency.setRentalCarCompanyName("Hertz");
            agency.setRentalCarOpenDate(date);
            agency.setRentalCarCloseDate(date);
            agency.setRentalCarFuelAmount(maxAmount);
            agency.setRentalCarAdditionalAmount(amount);
            agency.setRentalCarTaxAmount(maxAmount);
            agency.setRentalCarSurchargeAmount(amount);
            agency.setRentalCarGovernmentSurchargeAmount(maxAmount);
            agency.setRentalCarBillAmount(amount);
            agency.setRentalCarDetailText(longText);
            agency.setRegistrationCompanyName("Conference Co.");
            agency.setRegistrationAmount(maxAmount);
            agency.setTransactionPostingDate(date);
            agency.setObjectVerNumber("1");
            agency.setCreationTimestamp(time);
            agency.setProcessingTimestamp(time);
            agency.setMoveToHistoryIndicator(true);
            this.businessObjectService.save((PersistableBusinessObject)agency);
            HashMap<String, Integer> values = new HashMap<String, Integer>();
            values.put("id", agency.getId());
            List agencyDataList = (List)this.businessObjectService.findMatching(AgencyStagingData.class, values);
            try {
                AgencyStagingData data = (AgencyStagingData)agencyDataList.get(0);
                AgencyStagingDataTest.assertTrue((boolean)agency.getErrorCode().equals(data.getErrorCode()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getAgencyDataId().equals(data.getAgencyDataId()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getCreditCardOrAgencyCode().equals(data.getCreditCardOrAgencyCode()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getAgency().equals(data.getAgency()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getOtherCompanyName().equals(data.getOtherCompanyName()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getAgencyFileName().equals(data.getAgencyFileName()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getMerchantName().equals(data.getMerchantName()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getBillingCycleDate().equals(data.getBillingCycleDate()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getTripId().equals(data.getTripId()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getTripInvoiceNumber().equals(data.getTripInvoiceNumber()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getTripTravelerTypeId().equals(data.getTripTravelerTypeId()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getOtherAmount().equals((Object)data.getOtherAmount()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getTravelerName().equals(data.getTravelerName()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getTravelerId().equals(data.getTravelerId()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getTravelerNetworkId().equals(data.getTravelerNetworkId()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getTripExpenseAmount().equals((Object)data.getTripExpenseAmount()));
                AgencyStagingDataTest.assertTrue((boolean)StringUtils.equals((String)agency.getAlternateTripId(), (String)data.getAlternateTripId()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getTripArrangerName().equals(data.getTripArrangerName()));
                ArrayList accountingInfo = data.getTripAccountingInformation();
                AgencyStagingDataTest.assertTrue((boolean)agency.getTripAccountingInformation().equals(accountingInfo));
                for (TripAccountingInformation account : accountingInfo) {
                    AgencyStagingDataTest.assertTrue((boolean)agency.getId().equals(account.getAgencyStagingDataId()));
                }
                AgencyStagingDataTest.assertTrue((boolean)agency.getGroupObjectCode().equals(data.getGroupObjectCode()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getDistributionCode().equals(data.getDistributionCode()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getTripDepartureDate().equals(data.getTripDepartureDate()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getTripReturnDate().equals(data.getTripReturnDate()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getFareSaverCode().equals(data.getFareSaverCode()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getAirBookDate().equals(data.getAirBookDate()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getAirCarrierCode().equals(data.getAirCarrierCode()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getAirTicketNumber().equals(data.getAirTicketNumber()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getPnrNumber().equals(data.getPnrNumber()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getAirTicketClass().equals(data.getAirTicketClass()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getAirTransactionAmount().equals((Object)data.getAirTransactionAmount()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getAirBaseFareAmount().equals((Object)data.getAirBaseFareAmount()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getAirTaxAmount().equals((Object)data.getAirTaxAmount()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getAirLowFareAmount().equals((Object)data.getAirLowFareAmount()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getAirReasonCode().equals(data.getAirReasonCode()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getAirSegmentId().equals(data.getAirSegmentId()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getAirDestinationCode().equals(data.getAirDestinationCode()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getAirServiceFeeNumber().equals(data.getAirServiceFeeNumber()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getAirServiceFeeAmount().equals((Object)data.getAirServiceFeeAmount()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getTransactionUniqueId().equals(data.getTransactionUniqueId()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getLodgingItineraryNumber().equals(data.getLodgingItineraryNumber()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getLodgingPrepayDate().equals(data.getLodgingPrepayDate()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getLodgingAmount().equals((Object)data.getLodgingAmount()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getLodgingPrepayDaysNumber().equals(data.getLodgingPrepayDaysNumber()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getLodgingPropertyName().equals(data.getLodgingPropertyName()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getTripLodgingArrivalDate().equals(data.getTripLodgingArrivalDate()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getLodgingDepartureDate().equals(data.getLodgingDepartureDate()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getLodgingBookingDate().equals(data.getLodgingBookingDate()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getLodgingPropertyCityName().equals(data.getLodgingPropertyCityName()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getLodgingPropertyStateCode().equals(data.getLodgingPropertyStateCode()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getLodgingCountryName().equals(data.getLodgingCountryName()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getRentalCarItineraryNumber().equals(data.getRentalCarItineraryNumber()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getRentalCarAmount().equals((Object)data.getRentalCarAmount()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getRentalCarNumberOfDays().equals(data.getRentalCarNumberOfDays()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getRentalCarCompanyName().equals(data.getRentalCarCompanyName()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getRentalCarOpenDate().equals(data.getRentalCarOpenDate()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getRentalCarCloseDate().equals(data.getRentalCarCloseDate()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getRentalCarFuelAmount().equals((Object)data.getRentalCarFuelAmount()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getRentalCarAdditionalAmount().equals((Object)data.getRentalCarAdditionalAmount()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getRentalCarTaxAmount().equals((Object)data.getRentalCarTaxAmount()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getRentalCarSurchargeAmount().equals((Object)data.getRentalCarSurchargeAmount()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getRentalCarGovernmentSurchargeAmount().equals((Object)data.getRentalCarGovernmentSurchargeAmount()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getRentalCarBillAmount().equals((Object)data.getRentalCarBillAmount()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getRentalCarDetailText().equals(data.getRentalCarDetailText()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getRegistrationCompanyName().equals(data.getRegistrationCompanyName()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getRegistrationAmount().equals((Object)data.getRegistrationAmount()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getTransactionPostingDate().equals(data.getTransactionPostingDate()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getObjectVerNumber().equals(data.getObjectVerNumber()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getCreationTimestamp().equals(data.getCreationTimestamp()));
                AgencyStagingDataTest.assertTrue((boolean)agency.getProcessingTimestamp().equals(data.getProcessingTimestamp()));
                AgencyStagingDataTest.assertTrue((agency.getMoveToHistoryIndicator() && data.getMoveToHistoryIndicator() ? 1 : 0) != 0);
            }
            catch (Exception e) {
                e.printStackTrace();
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }
}

