/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.batch.businessobject;

import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.batch.PerDiemLoadStep;
import org.kuali.kfs.module.tem.batch.businessobject.MealBreakDownStrategy;
import org.kuali.kfs.module.tem.businessobject.PerDiem;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class DefaultMealBreakDownStrategy
implements MealBreakDownStrategy {
    private ParameterService parameterService;

    @Override
    public void breakDown(PerDiem perDiem) {
        KualiDecimal mealsAndIncidentals = perDiem.getMealsAndIncidentals();
        this.breakDown(perDiem, mealsAndIncidentals);
    }

    @Override
    public void breakDown(PerDiem perDiem, KualiDecimal mealsAndIncidentals) {
        if (ObjectUtils.isNull((Object)mealsAndIncidentals) || mealsAndIncidentals.isNegative()) {
            throw new RuntimeException("The given mealsAndIncidentals cannot be null or negative.");
        }
        KualiDecimal breakfastPercent = this.getMealPercentByMealCode(TemConstants.MEAL_CODE.BREAKFAST.mealCode);
        KualiDecimal breakfast = (KualiDecimal)((KualiDecimal)mealsAndIncidentals.multiply((AbstractKualiDecimal)breakfastPercent)).divide((AbstractKualiDecimal)new KualiDecimal(100));
        perDiem.setBreakfast(breakfast);
        KualiDecimal lunchPercent = this.getMealPercentByMealCode(TemConstants.MEAL_CODE.LUNCH.mealCode);
        KualiDecimal lunch = (KualiDecimal)((KualiDecimal)mealsAndIncidentals.multiply((AbstractKualiDecimal)lunchPercent)).divide((AbstractKualiDecimal)new KualiDecimal(100));
        perDiem.setLunch(lunch);
        KualiDecimal dinnerPercent = this.getMealPercentByMealCode(TemConstants.MEAL_CODE.DINNER.mealCode);
        KualiDecimal dinner = (KualiDecimal)((KualiDecimal)mealsAndIncidentals.multiply((AbstractKualiDecimal)dinnerPercent)).divide((AbstractKualiDecimal)new KualiDecimal(100));
        perDiem.setDinner(dinner);
        KualiDecimal meals = (KualiDecimal)((KualiDecimal)breakfast.add((AbstractKualiDecimal)lunch)).add((AbstractKualiDecimal)dinner);
        KualiDecimal incidentals = (KualiDecimal)mealsAndIncidentals.subtract((AbstractKualiDecimal)meals);
        perDiem.setIncidentals(incidentals);
    }

    protected KualiDecimal getMealPercentByMealCode(String mealCode) {
        KualiDecimal mealPercent = null;
        try {
            String mealPercentString = this.getMealPercent(mealCode);
            mealPercent = new KualiDecimal(mealPercentString);
        }
        catch (Exception e) {
            String error = this.getParameterName() + "is not setup correctly";
            throw new RuntimeException(error, e);
        }
        return mealPercent;
    }

    protected String getMealPercent(String mealCode) {
        String mealPercentString = this.getParameterService().getSubParameterValueAsString(PerDiemLoadStep.class, this.getParameterName(), mealCode);
        return mealPercentString;
    }

    protected String getParameterName() {
        return "CONUS_MEAL_BREAKDOWN";
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

