/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomer;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.businessobject.GroupTraveler;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.validation.event.AddGroupTravelLineEvent;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

public class TravelAuthGroupTravelRequiredInfoValidation
extends GenericValidation {
    protected PersonService personService;
    protected static volatile AccountsReceivableModuleService arModuleService;

    public boolean validate(AttributedDocumentEvent event) {
        AccountsReceivableCustomer customer;
        boolean valid = true;
        GroupTraveler groupTraveler = ((AddGroupTravelLineEvent)event).getGroupTraveler();
        if (ObjectUtils.isNull((Object)groupTraveler.getGroupTravelerTypeCode())) {
            GlobalVariables.getMessageMap().putError("travelerTypeCode", "error.required", new String[]{"Traveler Type Code"});
            valid = false;
        } else if (StringUtils.isBlank((String)groupTraveler.getGroupTravelerEmpId()) && (groupTraveler.getGroupTravelerTypeCode().equals(TemConstants.GroupTravelerType.EMPLOYEE.getCode()) || groupTraveler.getGroupTravelerTypeCode().equals(TemConstants.GroupTravelerType.STUDENT.getCode()) || groupTraveler.getGroupTravelerTypeCode().equals(TemConstants.GroupTravelerType.CUSTOMER.getCode()))) {
            GlobalVariables.getMessageMap().putError("groupTravelerEmpId", "error.required", new String[]{"Group Traveler Emp Id"});
            valid = false;
        } else if (groupTraveler.getGroupTravelerTypeCode().equals(TemConstants.GroupTravelerType.EMPLOYEE.getCode()) || groupTraveler.getGroupTravelerTypeCode().equals(TemConstants.GroupTravelerType.STUDENT.getCode())) {
            Person person = this.getPersonService().getPerson(groupTraveler.getGroupTravelerEmpId());
            if (person == null) {
                GlobalVariables.getMessageMap().putError("groupTravelerEmpId", "error.document.tem.travel.groupTraveler.employeeNotFound", new String[]{groupTraveler.getGroupTravelerEmpId()});
                valid = false;
            }
        } else if (groupTraveler.getGroupTravelerTypeCode().equals(TemConstants.GroupTravelerType.CUSTOMER.getCode()) && (customer = this.getAccountsReceivableModuleService().findCustomer(groupTraveler.getGroupTravelerEmpId())) == null) {
            GlobalVariables.getMessageMap().putError("groupTravelerEmpId", "error.document.tem.travel.groupTraveler.employeeNotFound", new String[]{groupTraveler.getGroupTravelerEmpId()});
            valid = false;
        }
        if (ObjectUtils.isNull((Object)groupTraveler.getName())) {
            GlobalVariables.getMessageMap().putError("name", "error.required", new String[]{"Name"});
            valid = false;
        } else {
            TravelDocument document = (TravelDocument)event.getDocument();
            List<GroupTraveler> groupTravelers = document.getGroupTravelers();
            for (GroupTraveler gt : groupTravelers) {
                if (!StringUtils.equalsIgnoreCase((String)gt.getName(), (String)groupTraveler.getName()) && !StringUtils.equalsIgnoreCase((String)gt.getGroupTravelerEmpId(), (String)groupTraveler.getGroupTravelerEmpId())) continue;
                GlobalVariables.getMessageMap().putError("name", "error.document.tem.travel.groupTraveler.duplicate", new String[]{"Name"});
                valid = false;
            }
        }
        return valid;
    }

    public PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = (PersonService)SpringContext.getBean(PersonService.class);
        }
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    protected AccountsReceivableModuleService getAccountsReceivableModuleService() {
        if (arModuleService == null) {
            arModuleService = (AccountsReceivableModuleService)SpringContext.getBean(AccountsReceivableModuleService.class);
        }
        return arModuleService;
    }
}

