/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.web.struts;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForward;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.document.TravelAuthorizationCloseDocument;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.service.TravelAuthorizationService;
import org.kuali.kfs.module.tem.document.web.struts.Inquisitive;
import org.kuali.kfs.module.tem.document.web.struts.QuestionHandler;
import org.kuali.kfs.module.tem.document.web.struts.StrutsInquisitor;
import org.kuali.kfs.module.tem.document.web.struts.TravelAuthorizationForm;
import org.kuali.kfs.module.tem.util.MessageUtils;

public class CloseQuestionHandler
implements QuestionHandler<TravelDocument> {
    private DataDictionaryService dataDictionaryService;
    private TravelAuthorizationService travelAuthorizationService;

    @Override
    public <T> T handleResponse(Inquisitive<TravelDocument, ?> asker) throws Exception {
        if (asker.denied("CloseTa")) {
            return (T)asker.back();
        }
        if (asker.confirmed("ConfirmClose")) {
            return (T)asker.end();
        }
        TravelAuthorizationDocument document = (TravelAuthorizationDocument)asker.getDocument();
        ActionForward returnActionForward = ((StrutsInquisitor)asker).getMapping().findForward("basic");
        TravelAuthorizationForm form = (TravelAuthorizationForm)((StrutsInquisitor)asker).getForm();
        TravelAuthorizationCloseDocument tacDocument = this.travelAuthorizationService.closeAuthorization(document, form.getAnnotation(), GlobalVariables.getUserSession().getPrincipalName(), null);
        form.setDocTypeName("TAC");
        form.setDocument((Document)tacDocument);
        if (ObjectUtils.isNotNull((Object)returnActionForward)) {
            return (T)returnActionForward;
        }
        return (T)asker.confirm("CloseTa", MessageUtils.getMessage("When you close this Travel Authorization, remaining encumbrance will be liquidated.", new String[0]), true, "Could not get reimbursement total for travel id ", tacDocument.getTravelDocumentIdentifier().toString(), "", "");
    }

    @Override
    public <T> T askQuestion(Inquisitive<TravelDocument, ?> asker) throws Exception {
        Object retval = asker.confirm("CloseTa", "When you close this Travel Authorization, remaining encumbrance will be liquidated.", false, new String[0]);
        return (T)retval;
    }

    public String getReturnToFiscalOfficerNote(String notePrefix, String reason) {
        String noteText = "";
        String introNoteMessage = notePrefix + " ";
        noteText = introNoteMessage + reason;
        int noteTextLength = noteText.length();
        int noteTextMaxLength = this.dataDictionaryService.getAttributeMaxLength(Note.class, "noteText");
        if (StringUtils.isBlank((String)reason) || noteTextLength > noteTextMaxLength) {
            int reasonLimit = noteTextMaxLength - noteTextLength;
            if (ObjectUtils.isNull((Object)reason)) {
                reason = "";
            }
        }
        return noteText;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public void setTravelAuthorizationService(TravelAuthorizationService travelAuthorizationService) {
        this.travelAuthorizationService = travelAuthorizationService;
    }
}

