/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document;

import java.text.SimpleDateFormat;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.fp.document.DisbursementVoucherDocument;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.businessobject.JobClassification;
import org.kuali.kfs.module.tem.businessobject.RelocationReason;
import org.kuali.kfs.module.tem.document.TEMReimbursementDocument;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.document.AmountTotaling;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;

@Entity
@Table(name="TEM_RELO_DOC_T")
public class TravelRelocationDocument
extends TEMReimbursementDocument
implements AmountTotaling {
    protected static Logger LOG = Logger.getLogger(TravelRelocationDocument.class);
    private String fromAddress1;
    private String fromAddress2;
    private String fromCity;
    private String fromStateCode;
    private String fromCountryCode;
    private String toAddress1;
    private String toAddress2;
    private String toCity;
    private String toStateCode;
    private String toCountryCode;
    private String reasonCode;
    private RelocationReason reason;
    private String jobClsCode;
    private JobClassification jobClassification;
    private String titleCode;
    private String comments;

    public void setFromAddress1(String fromAddress1) {
        this.fromAddress1 = fromAddress1;
    }

    @Column(name="FRM_ADDR_LINE1", length=50, nullable=true)
    public String getFromAddress1() {
        return this.fromAddress1;
    }

    public void setFromAddress2(String fromAddress2) {
        this.fromAddress2 = fromAddress2;
    }

    @Column(name="FRM_ADDR_LINE2", length=50, nullable=true)
    public String getFromAddress2() {
        return this.fromAddress2;
    }

    public void setFromCity(String fromCity) {
        this.fromCity = fromCity;
    }

    @Column(name="FRM_CITY_NM", length=30, nullable=true)
    public String getFromCity() {
        return this.fromCity;
    }

    public void setFromStateCode(String fromStateCode) {
        this.fromStateCode = fromStateCode;
    }

    @Column(name="FRM_STATE_CD", length=40, nullable=true)
    public String getFromStateCode() {
        return this.fromStateCode;
    }

    public void setFromCountryCode(String fromCountryCode) {
        this.fromCountryCode = fromCountryCode;
    }

    @Column(name="FRM_COUNTRY_CD", length=40, nullable=true)
    public String getFromCountryCode() {
        return this.fromCountryCode;
    }

    public void setToAddress1(String toAddress1) {
        this.toAddress1 = toAddress1;
    }

    @Column(name="TO_ADDR_LINE1", length=50, nullable=true)
    public String getToAddress1() {
        return this.toAddress1;
    }

    public void setToAddress2(String toAddress2) {
        this.toAddress2 = toAddress2;
    }

    @Column(name="TO_ADDR_LINE2", length=50, nullable=true)
    public String getToAddress2() {
        return this.toAddress2;
    }

    public void setToCity(String toCity) {
        this.toCity = toCity;
    }

    @Column(name="TO_CITY_NM", length=30, nullable=true)
    public String getToCity() {
        return this.toCity;
    }

    public void setToStateCode(String toStateCode) {
        this.toStateCode = toStateCode;
    }

    @Column(name="TO_STATE_CD", length=40, nullable=true)
    public String getToStateCode() {
        return this.toStateCode;
    }

    public void setToCountryCode(String toCountryCode) {
        this.toCountryCode = toCountryCode;
    }

    @Column(name="TO_COUNTRY_CD", length=40, nullable=true)
    public String getToCountryCode() {
        return this.toCountryCode;
    }

    public void setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
    }

    @Column(name="REASON_CD", length=255, nullable=true)
    public String getReasonCode() {
        return this.reasonCode;
    }

    public void setReason(RelocationReason reason) {
        this.reason = reason;
    }

    @JoinColumn(name="REASON_CD", nullable=true)
    public RelocationReason getReason() {
        return this.reason;
    }

    public void setJobClsCode(String jobClsCode) {
        this.jobClsCode = jobClsCode;
    }

    @Column(name="JOB_CLS_CD", length=255, nullable=true)
    public String getJobClsCode() {
        return this.jobClsCode;
    }

    public void setJobClassification(JobClassification jobClassification) {
        this.jobClassification = jobClassification;
    }

    @JoinColumn(name="JOB_CLS_CD", nullable=true)
    public JobClassification getJobClassification() {
        return this.jobClassification;
    }

    public void setTitleCode(String titleCode) {
        this.titleCode = titleCode;
    }

    @Column(name="TITLE_CD", length=3, nullable=true)
    public String getTitleCode() {
        return this.titleCode;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    @Column(name="COMMENTS", length=255, nullable=true)
    public String getComments() {
        return this.comments;
    }

    @Override
    public void prepareForSave(KualiDocumentEvent event) {
        if (this.getFromCity() != null) {
            this.getPrimaryDestination().setPrimaryDestinationName(this.getFromCity());
        }
        super.prepareForSave(event);
        this.getTravelPayment().setCheckStubText(this.getTravelDocumentIdentifier() + " " + StringUtils.defaultString((String)this.getTripDescription()) + " " + this.getTripBegin());
    }

    @Override
    public void initiateDocument() {
        super.initiateDocument();
        this.setTripBegin(null);
        this.setTripEnd(null);
        this.setApplicationDocumentStatus("In Process");
        this.getTravelPayment().setDocumentationLocationCode(this.getParameterService().getParameterValueAsString(TravelRelocationDocument.class, "DOCUMENTATION_LOCATION_CODE", this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "DOCUMENTATION_LOCATION_CODE")));
    }

    @Override
    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        if (DocumentStatus.PROCESSED.getCode().equals(statusChangeEvent.getNewRouteStatus())) {
            LOG.debug((Object)("New route status is: " + statusChangeEvent.getNewRouteStatus()));
            try {
                this.updateAndSaveAppDocStatus("Moving And Relocation Manager Approved");
            }
            catch (WorkflowException ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean answerSplitNodeQuestion(String nodeName) throws UnsupportedOperationException {
        if (nodeName.equals("TravelRequiresTravelerApproval")) {
            return this.requiresTravelerApprovalRouting();
        }
        if (nodeName.equals("TravelHasSpecialRequest")) {
            return this.requiresSpecialRequestReviewRouting();
        }
        if (nodeName.equals("TaxManagerApproval")) {
            return this.requiresTaxManagerApprovalRouting();
        }
        if (StringUtils.equals((String)"RequiresBudgetReview", (String)nodeName)) {
            return this.isBudgetReviewRequired();
        }
        if (nodeName.equals("RequiresSeparationOfDuties")) {
            return this.requiresSeparationOfDutiesRouting();
        }
        throw new UnsupportedOperationException("Cannot answer split question for this node you call \"" + nodeName + "\"");
    }

    public String getPreparer() {
        return GlobalVariables.getUserSession().getPerson().getPrincipalName();
    }

    @Override
    public KualiDecimal getTotalFor(String financialObjectCode) {
        KualiDecimal retval = KualiDecimal.ZERO;
        LOG.debug((Object)("Getting total for " + financialObjectCode));
        for (AccountingLine line : this.getSourceAccountingLines()) {
            LOG.debug((Object)("Comparing " + financialObjectCode + " to " + line.getObjectCode().getCode()));
            if (!line.getObjectCode().getCode().equals(financialObjectCode)) continue;
            retval = (KualiDecimal)retval.add((AbstractKualiDecimal)line.getAmount());
        }
        return retval;
    }

    @Override
    public String getReportPurpose() {
        return this.reason != null ? this.reason.getReloReasonName() : null;
    }

    @Override
    public void populateVendorPayment(DisbursementVoucherDocument disbursementVoucherDocument) {
        super.populateVendorPayment(disbursementVoucherDocument);
        String locationCode = this.getParameterService().getParameterValueAsString(TravelRelocationDocument.class, "DOCUMENTATION_LOCATION_CODE", this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "DOCUMENTATION_LOCATION_CODE"));
        String startDate = new SimpleDateFormat("MM/dd/yyyy").format(this.getTripBegin());
        String endDate = new SimpleDateFormat("MM/dd/yyyy").format(this.getTripEnd());
        String checkStubText = this.getTravelDocumentIdentifier() + ", " + startDate + " - " + endDate + ", " + this.getToCity() + ", " + this.getToStateCode();
        disbursementVoucherDocument.setDisbVchrPaymentMethodCode("P");
        disbursementVoucherDocument.setDisbursementVoucherDocumentationLocationCode(locationCode);
        disbursementVoucherDocument.setDisbVchrCheckStubText(checkStubText);
    }

    @Override
    protected boolean requiresTaxManagerApprovalRouting() {
        boolean requiresTaxManagerApprovalRouting = super.requiresTaxManagerApprovalRouting();
        return requiresTaxManagerApprovalRouting || this.getTraveler().getNonResidentAlien() != false;
    }

    @Override
    public Map<String, String> getDisapprovedAppDocStatusMap() {
        return TemConstants.TravelRelocationStatusCodeKeys.getDisapprovedAppDocStatusMap();
    }

    @Override
    public String getAchCheckDocumentType() {
        return "RECA";
    }

    @Override
    public String getWireTransferOrForeignDraftDocumentType() {
        return "REWF";
    }

    @Override
    protected String getTripIdPrefix() {
        return "R-";
    }

    @Override
    public String getTripTypeCode() {
        return "All";
    }
}

