/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.authorization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.web.struts.form.KualiForm;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.TravelReimbursementDocument;
import org.kuali.kfs.module.tem.document.authorization.DocumentInitiationException;
import org.kuali.kfs.module.tem.document.authorization.TravelDocumentPresentationController;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.document.service.TravelReimbursementService;
import org.kuali.kfs.module.tem.document.web.struts.TravelReimbursementForm;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kim.api.identity.Person;

public class TravelReimbursementDocumentPresentationController
extends TravelDocumentPresentationController {
    public static Logger LOG = Logger.getLogger(TravelReimbursementDocumentPresentationController.class);
    protected static volatile BusinessObjectService businessObjectService;

    @Override
    public Set<String> getEditModes(Document document) {
        Set<String> editModes = super.getEditModes(document);
        this.addFullEntryEditMode(document, editModes);
        editModes.remove("checkAmountEntry");
        editModes.remove("blanketTravelEntry");
        editModes.remove("blanketTravelView");
        Set nodeNames = document.getDocumentHeader().getWorkflowDocument().getNodeNames();
        if (document.getDocumentHeader().getWorkflowDocument().isInitiated() || document.getDocumentHeader().getWorkflowDocument().isSaved() || nodeNames != null && !nodeNames.isEmpty() && (nodeNames.contains("Tax") || nodeNames.contains("Travel"))) {
            editModes.add("expenseTaxableEntry");
        }
        if (document.getDocumentHeader().getWorkflowDocument().isInitiated() || document.getDocumentHeader().getWorkflowDocument().isSaved() || nodeNames != null && !nodeNames.isEmpty() && nodeNames.contains("Travel")) {
            editModes.add("expenseLimitEntry");
        }
        return editModes;
    }

    public Set<String> getDocumentActions(Document document) {
        TravelReimbursementDocument tr = (TravelReimbursementDocument)document;
        TravelAuthorizationDocument ta = null;
        ta = this.getTravelDocumentService().findCurrentTravelAuthorization(tr);
        if (ta != null && ta.getDelinquentAction() != null && ta.getDelinquentAction().equals("S") && !ta.getDelinquentTRException().booleanValue()) {
            throw new DocumentInitiationException("error.authorization.travelReimbursementDelinquent", new String[]{"TR"}, true);
        }
        Set actions = super.getDocumentActions(document);
        if (this.canNewReimbursement(tr)) {
            actions.add("canNewReimbursement");
        }
        return actions;
    }

    public boolean canNewReimbursement(TravelReimbursementDocument document) {
        String documentType = document.getDocumentTypeName();
        String appDocStatus = document.getApplicationDocumentStatus();
        boolean statusCheck = (document.getDocumentHeader().getWorkflowDocument().isProcessed() || document.getDocumentHeader().getWorkflowDocument().isFinal()) && appDocStatus.equals("Department Approved");
        Person user = GlobalVariables.getUserSession().getPerson();
        boolean hasInitAccess = false;
        if (this.getTemRoleService().canAccessTravelDocument(document, user) && !ObjectUtils.isNull((Object)((Object)document.getTraveler())) && document.getTemProfileId() != null && !ObjectUtils.isNull((Object)((Object)document.getTemProfile()))) {
            hasInitAccess = user.getPrincipalId().equals(document.getTraveler().getPrincipalId()) || this.getTemRoleService().isTravelDocumentArrangerForProfile(documentType, user.getPrincipalId(), document.getTemProfileId()) || this.getTemRoleService().isTravelArranger(user, document.getTemProfile().getHomeDepartment(), document.getTemProfileId().toString(), documentType);
        }
        boolean checkRelatedDocs = true;
        boolean originalDocumentCheck = true;
        boolean initiateReimbursementWithoutAuthorization = true;
        if (documentType.equals("TR")) {
            List<Document> docs = this.getTravelDocumentService().getDocumentsRelatedTo(document, documentType);
            for (Document doc : docs) {
                TravelReimbursementDocument trDoc = (TravelReimbursementDocument)doc;
                if (!trDoc.getDocumentHeader().getWorkflowDocument().isEnroute()) continue;
                checkRelatedDocs &= false;
            }
            originalDocumentCheck = document.isTripProgenitor();
            initiateReimbursementWithoutAuthorization = this.getConfigurationService().getPropertyValueAsBoolean("travel.reimbursement.initiatelink.enabled");
            initiateReimbursementWithoutAuthorization &= !this.getTravelReimbursementService().doAllReimbursementTripTypesRequireTravelAuthorization();
        }
        return statusCheck && hasInitAccess && checkRelatedDocs && originalDocumentCheck && initiateReimbursementWithoutAuthorization;
    }

    public boolean canInitiate(String documentTypeName) {
        List<TravelReimbursementDocument> trDocsInTrip;
        TravelReimbursementForm reimbForm;
        boolean initiateReimbursementWithoutAuthorization = this.getConfigurationService().getPropertyValueAsBoolean("travel.reimbursement.initiatelink.enabled");
        if (!(initiateReimbursementWithoutAuthorization &= !this.getTravelReimbursementService().doAllReimbursementTripTypesRequireTravelAuthorization())) {
            throw new DocumentInitiationException("error.document.tem.reimbursement.init.ta.required", new String[0], true);
        }
        KualiForm form = KNSGlobalVariables.getKualiForm();
        if (form instanceof TravelReimbursementForm && !StringUtils.isBlank((String)(reimbForm = (TravelReimbursementForm)form).getTravelDocumentIdentifier()) && !(trDocsInTrip = this.getTravelReimbursementsInTrip(reimbForm.getTravelDocumentIdentifier())).isEmpty()) {
            for (TravelReimbursementDocument trDoc : trDocsInTrip) {
                if (!StringUtils.equals((String)trDoc.getFinancialSystemDocumentHeader().getFinancialDocumentStatusCode(), (String)"R")) continue;
                throw new DocumentInitiationException("error.document.tem.reimbursement.init.enroute.tr", new String[]{reimbForm.getTravelDocumentIdentifier(), trDoc.getDocumentNumber()}, true);
            }
        }
        return super.canInitiate(documentTypeName);
    }

    protected List<TravelReimbursementDocument> getTravelReimbursementsInTrip(String tripId) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("travelDocumentIdentifier", tripId);
        Collection trDocs = this.getBusinessObjectService().findMatching(TravelReimbursementDocument.class, fieldValues);
        ArrayList<TravelReimbursementDocument> trDocsList = new ArrayList<TravelReimbursementDocument>();
        if (!trDocs.isEmpty()) {
            trDocsList.addAll(trDocs);
        }
        return trDocsList;
    }

    public boolean canCopy(Document document) {
        boolean canCopy = super.canCopy(document);
        if (canCopy) {
            boolean bl = canCopy = !this.isDocumentInitiated(document);
        }
        if (canCopy) {
            canCopy = !this.isReimbursementChildOfAuthorization(document);
        }
        return canCopy;
    }

    protected boolean isDocumentInitiated(Document document) {
        return document.getDocumentHeader().getWorkflowDocument().isInitiated();
    }

    protected boolean isReimbursementChildOfAuthorization(Document document) {
        TravelReimbursementDocument tr = (TravelReimbursementDocument)document;
        List<TravelAuthorizationDocument> travelAuthorizations = this.getTravelDocumentService().findAuthorizationDocuments(tr.getTravelDocumentIdentifier());
        return ObjectUtils.isNotNull(travelAuthorizations) && !travelAuthorizations.isEmpty();
    }

    @Override
    protected TravelDocumentService getTravelDocumentService() {
        return (TravelDocumentService)SpringContext.getBean(TravelDocumentService.class);
    }

    protected TravelReimbursementService getTravelReimbursementService() {
        return (TravelReimbursementService)SpringContext.getBean(TravelReimbursementService.class);
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (businessObjectService == null) {
            businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        }
        return businessObjectService;
    }
}

