/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.TemProfileArranger;
import org.kuali.kfs.module.tem.document.TravelArrangerDocument;
import org.kuali.kfs.module.tem.document.service.TravelArrangerDocumentService;

public class TravelArrangerDocumentServiceImpl
implements TravelArrangerDocumentService {
    protected BusinessObjectService businessObjectService;

    @Override
    public void createTravelProfileArranger(TravelArrangerDocument arrangerDoc) {
        Integer profileId = arrangerDoc.getProfileId();
        String arrangerId = arrangerDoc.getArrangerId();
        TemProfileArranger profileArranger = this.findProfileArranger(arrangerId, profileId);
        if (ObjectUtils.isNull((Object)((Object)profileArranger))) {
            profileArranger = this.createNewTravelProfileArranger(arrangerDoc);
        } else {
            profileArranger.setActive(true);
            profileArranger.setPrimary(arrangerDoc.getPrimaryInd());
            profileArranger.setTaInd(arrangerDoc.getTaInd());
            profileArranger.setTrInd(arrangerDoc.getTrInd());
        }
        this.businessObjectService.save((PersistableBusinessObject)profileArranger);
    }

    @Override
    public void inactivateTravelProfileArranger(TravelArrangerDocument arrangerDoc) {
        Integer profileId = arrangerDoc.getProfileId();
        String arrangerId = arrangerDoc.getArrangerId();
        TemProfileArranger profileArranger = this.findTemProfileArranger(arrangerId, profileId);
        if (ObjectUtils.isNotNull((Object)((Object)profileArranger))) {
            profileArranger.setActive(Boolean.FALSE);
            this.businessObjectService.save((PersistableBusinessObject)profileArranger);
        }
    }

    @Override
    public TemProfileArranger findPrimaryTravelProfileArranger(String arrangerId, Integer profileId) {
        HashMap<String, Integer> fieldValues = new HashMap<String, Integer>();
        fieldValues.put("profileId", profileId);
        ArrayList profileArrangers = new ArrayList(this.businessObjectService.findMatching(TemProfileArranger.class, fieldValues));
        for (TemProfileArranger profileArranger : profileArrangers) {
            if (!profileArranger.getPrimary() || profileArranger.getPrincipalId().equals(arrangerId)) continue;
            return profileArranger;
        }
        return null;
    }

    protected TemProfileArranger createNewTravelProfileArranger(TravelArrangerDocument arrangerDoc) {
        TemProfileArranger profileArranger = new TemProfileArranger();
        profileArranger.setActive(true);
        profileArranger.setProfileId(arrangerDoc.getProfileId());
        profileArranger.setPrincipalId(arrangerDoc.getArrangerId());
        profileArranger.setPrimary(arrangerDoc.getPrimaryInd());
        profileArranger.setTaInd(arrangerDoc.getTaInd());
        profileArranger.setTrInd(arrangerDoc.getTrInd());
        return profileArranger;
    }

    protected TemProfileArranger findProfileArranger(String principalId, Integer profileId) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("principalId", principalId);
        fieldValues.put("profileId", profileId);
        ArrayList profileArrangers = new ArrayList(this.businessObjectService.findMatching(TemProfileArranger.class, fieldValues));
        if (profileArrangers.size() == 1) {
            return (TemProfileArranger)((Object)profileArrangers.get(0));
        }
        if (profileArrangers.size() == 0) {
            return null;
        }
        return null;
    }

    @Override
    public TemProfileArranger findTemProfileArranger(String principalId, Integer profileId) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("principalId", principalId);
        fieldValues.put("profileId", profileId);
        fieldValues.put("active", "Y");
        ArrayList profileArrangers = new ArrayList(this.businessObjectService.findMatching(TemProfileArranger.class, fieldValues));
        if (profileArrangers.size() == 1) {
            return (TemProfileArranger)((Object)profileArrangers.get(0));
        }
        if (profileArrangers.size() == 0) {
            return null;
        }
        return null;
    }

    @Override
    public boolean hasArrangees(String principalId) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("principalId", principalId);
        fieldValues.put("active", "Y");
        int arrangeeCount = this.businessObjectService.countMatching(TemProfileArranger.class, fieldValues);
        return arrangeeCount > 0;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

