/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.businessobject.TravelerDetailEmergencyContact;
import org.kuali.kfs.module.tem.businessobject.TripType;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class TravelAuthEmergencyContactRequiredValidation
extends GenericValidation {
    protected ParameterService parameterService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean rulePassed = true;
        TravelAuthorizationDocument taDocument = (TravelAuthorizationDocument)event.getDocument();
        taDocument.refreshReferenceObject("tripType");
        TripType tripType = taDocument.getTripType();
        if (this.getParameterService().getParameterValueAsBoolean(TravelAuthorizationDocument.class, "DISPLAY_EMERGENCY_CONTACT_IND").booleanValue() && ObjectUtils.isNotNull((Object)((Object)tripType))) {
            if (tripType.isContactInfoRequired() && (taDocument.getDocumentHeader().getWorkflowDocument().isInitiated() || taDocument.getDocumentHeader().getWorkflowDocument().isSaved())) {
                rulePassed = this.validEmergencyContact(taDocument);
            }
            if (this.getParameterService().getParameterValuesAsString(TemParameterConstants.TEM_DOCUMENT.class, "INTERNATIONAL_TRIP_TYPES").contains(tripType.getCode())) {
                if (StringUtils.isBlank((String)taDocument.getCellPhoneNumber())) {
                    rulePassed = false;
                    GlobalVariables.getMessageMap().addToErrorPath("document");
                    GlobalVariables.getMessageMap().putError("cellPhoneNumber", "error.required", new String[]{"Traveler's Cell or Other Contact Number During Trip"});
                    GlobalVariables.getMessageMap().removeFromErrorPath("document");
                }
                if (taDocument.getTransportationModes() == null || taDocument.getTransportationModes().size() == 0) {
                    rulePassed = false;
                    GlobalVariables.getMessageMap().addToErrorPath("emergencyContact");
                    GlobalVariables.getMessageMap().putError("modeOfTransportation", "error.document.tem.modeOfTransportRequired", new String[0]);
                    GlobalVariables.getMessageMap().removeFromErrorPath("emergencyContact");
                }
                if (StringUtils.isBlank((String)taDocument.getRegionFamiliarity())) {
                    rulePassed = false;
                    GlobalVariables.getMessageMap().addToErrorPath("document");
                    GlobalVariables.getMessageMap().putError("regionFamiliarity", "error.required", new String[]{"Region Familiarity"});
                    GlobalVariables.getMessageMap().removeFromErrorPath("document");
                }
            }
        }
        return rulePassed;
    }

    private boolean validEmergencyContact(TravelAuthorizationDocument taDocument) {
        boolean validEmergencyContact = false;
        for (TravelerDetailEmergencyContact emergencyContact : taDocument.getTraveler().getEmergencyContacts()) {
            if (emergencyContact == null || StringUtils.isBlank((String)emergencyContact.getContactName())) continue;
            validEmergencyContact = true;
            return validEmergencyContact;
        }
        if (!validEmergencyContact) {
            GlobalVariables.getMessageMap().removeAllErrorMessagesForProperty("emergencyContact.contactName");
            GlobalVariables.getMessageMap().addToErrorPath("emergencyContact");
            GlobalVariables.getMessageMap().putError("contactName", "error.document.tem.emergencyContactRequired", new String[0]);
            GlobalVariables.getMessageMap().removeFromErrorPath("emergencyContact");
        }
        return validEmergencyContact;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

