/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.document.TravelEntertainmentDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class TravelEntertainmentNonEmployeeCertificationAttachmentValidation
extends GenericValidation {
    protected ParameterService parameterService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean valid = true;
        GlobalVariables.getMessageMap().clearErrorPath();
        GlobalVariables.getMessageMap().addToErrorPath("document");
        boolean nonEmployeeCertificationRequired = this.parameterService.getParameterValueAsBoolean(TravelEntertainmentDocument.class, "NON_EMPLOYEE_CERTIFICATION_REQUIRED_IND");
        TravelEntertainmentDocument document = (TravelEntertainmentDocument)event.getDocument();
        boolean nonEmployeeFormAttached = false;
        List notes = document.getNotes();
        for (Note note : notes) {
            if (!ObjectUtils.isNotNull((Object)note.getAttachment()) || !"Non Employee Form".equals(note.getAttachment().getAttachmentTypeCode())) continue;
            nonEmployeeFormAttached = true;
            break;
        }
        if (nonEmployeeCertificationRequired && document.IsHostNonEmployee() && !nonEmployeeFormAttached) {
            valid = false;
            GlobalVariables.getMessageMap().putError("document.fromDocumentNumber", "tem.entertainment.non.employee.certification.required", new String[0]);
            String matchingErrorPath = StringUtils.join((Collection)GlobalVariables.getMessageMap().getErrorPath(), (String)".") + "." + "fromDocumentNumber";
            GlobalVariables.getMessageMap().removeAllWarningMessagesForProperty(matchingErrorPath);
        }
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        return valid;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

