/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.web.struts;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.web.ui.ExtraButton;
import org.kuali.kfs.module.tem.businessobject.TravelAdvance;
import org.kuali.kfs.module.tem.document.TravelReimbursementDocument;
import org.kuali.kfs.module.tem.document.service.TravelAuthorizationService;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.document.service.TravelReimbursementService;
import org.kuali.kfs.module.tem.document.web.bean.TravelReimbursementMvcWrapperBean;
import org.kuali.kfs.module.tem.document.web.struts.TravelFormBase;
import org.kuali.kfs.module.tem.service.TravelService;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.rice.kim.api.identity.PersonService;

public class TravelReimbursementForm
extends TravelFormBase
implements TravelReimbursementMvcWrapperBean {
    private List<Serializable> history;
    private Date startDate;
    private Date endDate;
    private boolean canReturn;
    private boolean canCertify;
    private boolean canUnmask = false;
    private TravelAdvance newTravelAdvanceLine;
    private String travelDocumentIdentifier;

    @Override
    public void populate(HttpServletRequest request) {
        Timestamp startDateIn = this.getTravelReimbursementDocument().getTripBegin();
        Timestamp endDateIn = this.getTravelReimbursementDocument().getTripEnd();
        super.populate(request);
        Timestamp currentStart = this.getTravelReimbursementDocument().getTripBegin();
        Timestamp currentEnd = this.getTravelReimbursementDocument().getTripEnd();
        if (currentStart != null) {
            this.setStartDate(currentStart);
        }
        if (currentEnd != null) {
            this.setEndDate(currentEnd);
        }
    }

    @Override
    public boolean isDefaultOpenPaymentInfoTab() {
        if ("Awaiting Travel Manager Review".equals(this.getDocument().getDocumentHeader().getWorkflowDocument().getApplicationDocumentStatus())) {
            return true;
        }
        return super.isDefaultOpenPaymentInfoTab();
    }

    protected Map<String, ExtraButton> createButtonsMap() {
        HashMap<String, ExtraButton> result = new HashMap<String, ExtraButton>();
        result.putAll(this.createDVExtraButtonMap());
        result.putAll(this.createNewReimbursementButtonMap());
        return result;
    }

    @Override
    public List<ExtraButton> getExtraButtons() {
        super.getExtraButtons();
        Map<String, ExtraButton> buttonsMap = this.createButtonsMap();
        boolean enablePayments = this.getParameterService().getParameterValueAsBoolean(TravelReimbursementDocument.class, "VENDOR_PAYMENT_ALLOWED_BEFORE_FINAL_APPROVAL_IND");
        if (enablePayments && !((TravelDocumentService)SpringContext.getBean(TravelDocumentService.class)).isUnsuccessful(this.getTravelDocument()) && this.getTravelReimbursementDocument().canPayDVToVendor()) {
            this.extraButtons.add(buttonsMap.get("methodToCall.payDVToVendor"));
        }
        if (this.getDocumentActions().keySet().contains("canNewReimbursement")) {
            this.extraButtons.add(buttonsMap.get("methodToCall.newReimbursement"));
        }
        return this.extraButtons;
    }

    @Override
    public boolean canCertify() {
        return this.canCertify;
    }

    @Override
    public boolean getCanCertify() {
        return this.canCertify;
    }

    @Override
    public void setCanCertify(boolean canCertify) {
        this.canCertify = canCertify;
    }

    @Override
    public TravelReimbursementDocument getTravelReimbursementDocument() {
        return (TravelReimbursementDocument)this.getDocument();
    }

    @Override
    protected String getDocumentIdentifierFieldName() {
        return "travelDocumentIdentifier";
    }

    protected String getDefaultDocumentTypeName() {
        return "TR";
    }

    @Override
    public List<Serializable> getHistory() {
        return this.history;
    }

    @Override
    public void setHistory(List<Serializable> history) {
        this.history = history;
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    @Override
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @Override
    public Date getEndDate() {
        return this.endDate;
    }

    @Override
    public void setEndDate(Date endDate) {
        try {
            this.endDate = endDate;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected SourceAccountingLine createNewSourceAccountingLine(AccountingDocument financialDocument) {
        SourceAccountingLine accountingLine = super.createNewSourceAccountingLine(financialDocument);
        accountingLine.setFinancialObjectCode("");
        return accountingLine;
    }

    protected TravelService getTravelService() {
        return (TravelService)SpringContext.getBean(TravelService.class);
    }

    protected TravelReimbursementService getTravelReimbursementService() {
        return (TravelReimbursementService)SpringContext.getBean(TravelReimbursementService.class);
    }

    public PersonService getPersonService() {
        return (PersonService)SpringContext.getBean(PersonService.class);
    }

    protected TravelAuthorizationService getTravelAuthorizationService() {
        return (TravelAuthorizationService)SpringContext.getBean(TravelAuthorizationService.class);
    }

    @Override
    protected ParameterService getParameterService() {
        return (ParameterService)SpringContext.getBean(ParameterService.class);
    }

    public TravelAdvance getNewTravelAdvanceLine() {
        return this.newTravelAdvanceLine;
    }

    public void setNewAdvanceLine(TravelAdvance newTravelAdvanceLine) {
        this.newTravelAdvanceLine = newTravelAdvanceLine;
    }

    public boolean isCanUnmask() {
        return this.canUnmask;
    }

    public void setCanUnmask(boolean canUnmask) {
        this.canUnmask = canUnmask;
    }

    @Override
    public String getTravelPaymentFormAction() {
        return "temTravelReimbursement";
    }

    public String getTravelDocumentIdentifier() {
        return this.travelDocumentIdentifier;
    }

    public void setTravelDocumentIdentifier(String travelDocumentIdentifier) {
        this.travelDocumentIdentifier = travelDocumentIdentifier;
    }
}

