/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.service.impl;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.businessobject.AccountingDistribution;
import org.kuali.kfs.module.tem.businessobject.TemDistributionAccountingLine;
import org.kuali.kfs.module.tem.businessobject.TemSourceAccountingLine;
import org.kuali.kfs.module.tem.businessobject.TravelerDetail;
import org.kuali.kfs.module.tem.businessobject.TripType;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.TravelReimbursementDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.document.web.bean.AccountingLineDistributionKey;
import org.kuali.kfs.module.tem.service.AccountingDistributionService;
import org.kuali.kfs.module.tem.service.TravelExpenseService;
import org.kuali.kfs.module.tem.util.AccountingDistributionComparator;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class AccountingDistributionServiceImpl
implements AccountingDistributionService {
    protected static Logger LOG = Logger.getLogger(AccountingDistributionServiceImpl.class);
    protected BusinessObjectService businessObjectService;
    protected ObjectCodeService objectCodeService;
    protected TravelDocumentService travelDocumentService;
    protected ParameterService parameterService;

    @Override
    public List<TemSourceAccountingLine> distributionToSouceAccountingLines(List<TemDistributionAccountingLine> distributionAccountingLines, List<AccountingDistribution> accountingDistributionList, KualiDecimal sourceAccountingLinesTotal, KualiDecimal expenseLimit) {
        ArrayList<TemSourceAccountingLine> sourceAccountingList = new ArrayList<TemSourceAccountingLine>();
        HashMap distributionMap = new HashMap();
        KualiDecimal total = KualiDecimal.ZERO;
        int distributionTargetCount = 0;
        boolean useExpenseLimit = false;
        for (AccountingDistribution accountDistribution : accountingDistributionList) {
            if (!accountDistribution.getSelected().booleanValue()) continue;
            total = (KualiDecimal)total.add((AbstractKualiDecimal)accountDistribution.getRemainingAmount());
            ++distributionTargetCount;
        }
        if (expenseLimit != null && expenseLimit.isPositive()) {
            KualiDecimal expenseLimitTotal = new KualiDecimal(expenseLimit.bigDecimalValue());
            if (sourceAccountingLinesTotal != null && sourceAccountingLinesTotal.isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
                expenseLimitTotal = (KualiDecimal)expenseLimitTotal.subtract((AbstractKualiDecimal)sourceAccountingLinesTotal);
            }
            if (expenseLimitTotal.isLessThan((AbstractKualiDecimal)total)) {
                total = expenseLimitTotal;
                useExpenseLimit = true;
            }
        }
        if (total.isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
            for (AccountingDistribution accountingDistribution : accountingDistributionList) {
                ArrayList<TemSourceAccountingLine> tempSourceAccountingList = new ArrayList<TemSourceAccountingLine>();
                if (!accountingDistribution.getSelected().booleanValue()) continue;
                for (TemDistributionAccountingLine accountingLine : distributionAccountingLines) {
                    TemSourceAccountingLine newLine = new TemSourceAccountingLine();
                    try {
                        BeanUtils.copyProperties((Object)newLine, (Object)accountingLine);
                    }
                    catch (IllegalAccessException ex) {
                        ex.printStackTrace();
                    }
                    catch (InvocationTargetException ex) {
                        ex.printStackTrace();
                    }
                    BigDecimal distributionAmount = distributionTargetCount > 1 ? accountingDistribution.getRemainingAmount().bigDecimalValue() : total.bigDecimalValue();
                    BigDecimal product = accountingLine.getAccountLinePercent().multiply(distributionAmount);
                    product = product.divide(new BigDecimal(100), 5, RoundingMode.HALF_UP);
                    BigDecimal lineAmount = product.divide(total.bigDecimalValue(), 5, RoundingMode.HALF_UP);
                    newLine.setAmount(new KualiDecimal(product));
                    newLine.setCardType(accountingDistribution.getCardType());
                    HashMap<String, Object> fieldValues = new HashMap<String, Object>();
                    fieldValues.put("financialObjectCode", accountingDistribution.getObjectCode());
                    fieldValues.put("chartOfAccountsCode", newLine.getChartOfAccountsCode());
                    fieldValues.put("universityFiscalYear", ((UniversityDateService)SpringContext.getBean(UniversityDateService.class)).getCurrentFiscalYear());
                    ObjectCode objCode = (ObjectCode)this.getBusinessObjectService().findByPrimaryKey(ObjectCode.class, fieldValues);
                    newLine.setObjectCode(objCode);
                    newLine.setFinancialObjectCode(accountingDistribution.getObjectCode());
                    tempSourceAccountingList.add(newLine);
                }
                if (useExpenseLimit) {
                    sourceAccountingList.addAll(tempSourceAccountingList);
                    continue;
                }
                sourceAccountingList.addAll(this.adjustValues(tempSourceAccountingList, accountingDistribution.getRemainingAmount()));
            }
        }
        return sourceAccountingList;
    }

    protected List<TemSourceAccountingLine> adjustValues(List<TemSourceAccountingLine> sourceAccountingList, KualiDecimal total) {
        KualiDecimal totalAmount = KualiDecimal.ZERO;
        for (TemSourceAccountingLine newLine : sourceAccountingList) {
            totalAmount = (KualiDecimal)totalAmount.add((AbstractKualiDecimal)newLine.getAmount());
        }
        TemSourceAccountingLine line = sourceAccountingList.get(sourceAccountingList.size() - 1);
        KualiDecimal remainderAmount = (KualiDecimal)total.subtract((AbstractKualiDecimal)totalAmount);
        if (remainderAmount.isPositive()) {
            line.setAmount((KualiDecimal)line.getAmount().subtract((AbstractKualiDecimal)remainderAmount));
        } else if (remainderAmount.isNegative()) {
            line.setAmount((KualiDecimal)line.getAmount().add((AbstractKualiDecimal)remainderAmount));
        }
        return sourceAccountingList;
    }

    @Override
    public TemDistributionAccountingLine distributionToDistributionAccountingLine(List<AccountingDistribution> accountingDistributionList) {
        KualiDecimal distributionTotal = KualiDecimal.ZERO;
        for (AccountingDistribution accountingDistribution : accountingDistributionList) {
            if (!accountingDistribution.getSelected().booleanValue()) continue;
            distributionTotal = (KualiDecimal)distributionTotal.add((AbstractKualiDecimal)accountingDistribution.getRemainingAmount());
        }
        TemDistributionAccountingLine newLine = new TemDistributionAccountingLine();
        newLine.setAmount(distributionTotal);
        return newLine;
    }

    @Override
    public List<AccountingDistribution> createDistributions(TravelDocument travelDocument) {
        ArrayList<AccountingDistribution> documentDistribution = new ArrayList<AccountingDistribution>();
        HashMap<String, AccountingDistribution> distributionMap = new HashMap<String, AccountingDistribution>();
        for (TemConstants.ExpenseType expense : EnumSet.allOf(TemConstants.ExpenseType.class)) {
            Map<String, AccountingDistribution> newDistributionMap = this.getTravelExpenseService().getExpenseServiceByType(expense).getAccountingDistribution(travelDocument);
            this.addMergeDistributionMap(distributionMap, newDistributionMap);
        }
        this.subtractMergeDistributionMap(distributionMap, this.accountingLinesToDistributionMap(travelDocument));
        for (String distribution : distributionMap.keySet()) {
            if (((AccountingDistribution)distributionMap.get(distribution)).getSubTotal().equals((Object)KualiDecimal.ZERO)) continue;
            documentDistribution.add((AccountingDistribution)distributionMap.get(distribution));
        }
        Collections.sort(documentDistribution, new AccountingDistributionComparator());
        return documentDistribution;
    }

    protected Map<String, AccountingDistribution> accountingLinesToDistributionMap(TravelDocument travelDocument) {
        HashMap<String, AccountingDistribution> distributionMap = new HashMap<String, AccountingDistribution>();
        for (TemSourceAccountingLine accountingLine : travelDocument.getSourceAccountingLines()) {
            AccountingDistribution distribution = null;
            String key = accountingLine.getObjectCode().getCode() + "-" + accountingLine.getCardType();
            if (distributionMap.containsKey(key)) {
                ((AccountingDistribution)distributionMap.get(key)).setSubTotal((KualiDecimal)((AccountingDistribution)distributionMap.get(key)).getSubTotal().add((AbstractKualiDecimal)accountingLine.getAmount()));
                continue;
            }
            distribution = new AccountingDistribution();
            distribution.setObjectCode(accountingLine.getObjectCode().getCode());
            distribution.setSubTotal(accountingLine.getAmount());
            distributionMap.put(key, distribution);
        }
        return distributionMap;
    }

    protected void addMergeDistributionMap(Map<String, AccountingDistribution> destinationMap, Map<String, AccountingDistribution> originMap) {
        for (String key : originMap.keySet()) {
            if (destinationMap.containsKey(key)) {
                destinationMap.get(key).setSubTotal((KualiDecimal)destinationMap.get(key).getSubTotal().add((AbstractKualiDecimal)originMap.get(key).getSubTotal()));
                destinationMap.get(key).setRemainingAmount((KualiDecimal)destinationMap.get(key).getRemainingAmount().add((AbstractKualiDecimal)originMap.get(key).getRemainingAmount()));
                continue;
            }
            destinationMap.put(key, originMap.get(key));
        }
    }

    protected void subtractMergeDistributionMap(Map<String, AccountingDistribution> destinationMap, Map<String, AccountingDistribution> originMap) {
        for (String key : originMap.keySet()) {
            if (!destinationMap.containsKey(key)) continue;
            destinationMap.get(key).setRemainingAmount((KualiDecimal)destinationMap.get(key).getRemainingAmount().subtract((AbstractKualiDecimal)originMap.get(key).getSubTotal()));
        }
    }

    public String getObjectCodeFrom(TravelDocument travelDocument, String paramName) {
        int searchIdx;
        TripType tripType;
        String parameterValue = this.getParameterService().getParameterValueAsString(TravelReimbursementDocument.class, paramName);
        String paramSearchStr = "";
        TravelerDetail traveler = travelDocument.getTraveler();
        if (traveler != null) {
            paramSearchStr = paramSearchStr + traveler.getTravelerTypeCode() + "=";
        }
        if ((tripType = travelDocument.getTripType()) != null) {
            paramSearchStr = paramSearchStr + tripType.getCode() + "=";
        }
        if ((searchIdx = parameterValue.indexOf(paramSearchStr)) == -1) {
            return null;
        }
        int endIdx = parameterValue.indexOf(";", searchIdx);
        if (endIdx == -1) {
            return parameterValue.substring(searchIdx + paramSearchStr.length());
        }
        return parameterValue.substring(searchIdx + paramSearchStr.length(), endIdx);
    }

    protected AccountingDistribution retrieveDistributionFor(List<AccountingDistribution> distros, ObjectCode objectCode) {
        if (objectCode != null) {
            AccountingDistribution retval = this.retrieveDistributionFor(distros, objectCode.getCode());
            retval.setObjectCode(objectCode.getCode());
            retval.setObjectCodeName(objectCode.getName());
            return retval;
        }
        return new AccountingDistribution();
    }

    protected AccountingDistribution retrieveDistributionFor(List<AccountingDistribution> distros, String code) {
        if (distros != null && code != null) {
            for (AccountingDistribution distribution : distros) {
                LOG.debug((Object)("comparing " + code + " to " + distribution.getObjectCode()));
                if (!distribution.getObjectCode().equals(code)) continue;
                return distribution;
            }
        }
        return new AccountingDistribution();
    }

    @Override
    public List<AccountingDistribution> buildDistributionFrom(TravelDocument travelDocument) {
        List<AccountingDistribution> distributions = this.createDistributions(travelDocument);
        return distributions;
    }

    @Override
    public KualiDecimal getTotalAmount(List<TemDistributionAccountingLine> lines) {
        KualiDecimal total = KualiDecimal.ZERO;
        for (TemDistributionAccountingLine line : lines) {
            total = (KualiDecimal)total.add((AbstractKualiDecimal)line.getAmount());
        }
        return total;
    }

    @Override
    public BigDecimal getTotalPercent(List<TemDistributionAccountingLine> lines) {
        BigDecimal total = new BigDecimal(0);
        for (TemDistributionAccountingLine line : lines) {
            total = total.add(line.getAccountLinePercent());
        }
        return total;
    }

    @Override
    public Map<AccountingLineDistributionKey, KualiDecimal> calculateAccountingLineDistributionPercent(List<SourceAccountingLine> accountingLine) {
        HashMap<AccountingLineDistributionKey, KualiDecimal> distributionMap = new HashMap<AccountingLineDistributionKey, KualiDecimal>();
        KualiDecimal total = KualiDecimal.ZERO;
        for (SourceAccountingLine sourceLine : accountingLine) {
            total = (KualiDecimal)total.add((AbstractKualiDecimal)sourceLine.getAmount());
        }
        for (SourceAccountingLine sourceLine : accountingLine) {
            AccountingLineDistributionKey key = new AccountingLineDistributionKey(sourceLine);
            KualiDecimal factor = (KualiDecimal)sourceLine.getAmount().divide((AbstractKualiDecimal)total);
            if (distributionMap.containsKey(key)) {
                factor = (KualiDecimal)((KualiDecimal)distributionMap.get(key)).add((AbstractKualiDecimal)factor);
            }
            distributionMap.put(key, factor);
        }
        return distributionMap;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setTravelDocumentService(TravelDocumentService travelDocumentService) {
        this.travelDocumentService = travelDocumentService;
    }

    protected TravelDocumentService getTravelDocumentService() {
        return this.travelDocumentService;
    }

    public ObjectCodeService getObjectCodeService() {
        return this.objectCodeService;
    }

    public void setObjectCodeService(ObjectCodeService objectCodeService) {
        this.objectCodeService = objectCodeService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public TravelExpenseService getTravelExpenseService() {
        return (TravelExpenseService)SpringContext.getBean(TravelExpenseService.class);
    }
}

