/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.businessobject.ExpenseTypeObjectCode;
import org.kuali.kfs.module.tem.businessobject.HistoricalTravelExpense;
import org.kuali.kfs.module.tem.businessobject.ImportedExpense;
import org.kuali.kfs.module.tem.businessobject.TemExpense;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.service.TravelExpenseService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class ExpenseUtils {
    private static Logger LOG = Logger.getLogger(ExpenseUtils.class);

    public static List<ImportedExpense> convertHistoricalToImportedExpense(List<HistoricalTravelExpense> historicalTravelExpenses, TravelDocument travelDocument) {
        ArrayList<ImportedExpense> expenses = new ArrayList<ImportedExpense>();
        BusinessObjectService service = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        for (HistoricalTravelExpense historicalTravelExpense : historicalTravelExpenses) {
            boolean i = false;
            historicalTravelExpense.refreshReferenceObject("creditCardAgency");
            historicalTravelExpense.refreshReferenceObject("agencyStagingData");
            historicalTravelExpense.refreshReferenceObject("creditCardStagingData");
            historicalTravelExpense.getCreditCardAgency().refreshReferenceObject("travelCardType");
            historicalTravelExpense.setDocumentNumber(travelDocument.getDocumentNumber());
            ImportedExpense importedExpense = new ImportedExpense();
            importedExpense.setCardType(historicalTravelExpense.getCreditCardAgency().getTravelCardTypeCode());
            importedExpense.setNonReimbursable(historicalTravelExpense.getReimbursable() == false);
            importedExpense.setMissingReceipt(historicalTravelExpense.getMissingReceipt());
            importedExpense.setExpenseDate(historicalTravelExpense.getTransactionPostingDate());
            importedExpense.setCurrencyRate(historicalTravelExpense.getCurrencyRate());
            importedExpense.setConvertedAmount(historicalTravelExpense.getConvertedAmount());
            importedExpense.setExpenseAmount(historicalTravelExpense.getAmount());
            importedExpense.setTravelCompanyCodeName(historicalTravelExpense.getTravelCompany());
            importedExpense.setExpenseTypeCode(historicalTravelExpense.getTravelExpenseTypeCode());
            String travelerTypeCode = ObjectUtils.isNull((Object)((Object)travelDocument.getTraveler())) ? null : travelDocument.getTraveler().getTravelerTypeCode();
            ExpenseTypeObjectCode travelExpenseTypeCode = ((TravelExpenseService)SpringContext.getBean(TravelExpenseService.class)).getExpenseType(importedExpense.getExpenseTypeCode(), travelDocument.getDocumentTypeName(), travelDocument.getTripTypeCode(), travelerTypeCode);
            if (travelExpenseTypeCode != null) {
                historicalTravelExpense.setDescription(travelExpenseTypeCode.getExpenseType().getName());
                importedExpense.setDescription(historicalTravelExpense.getDescription());
                importedExpense.setTravelExpenseTypeCode(travelExpenseTypeCode);
                importedExpense.setExpenseTypeObjectCodeId(travelExpenseTypeCode.getExpenseTypeObjectCodeId());
                importedExpense.setTaxable(travelExpenseTypeCode.isTaxable());
            }
            importedExpense.setHistoricalTravelExpenseId(historicalTravelExpense.getId());
            expenses.add(importedExpense);
            historicalTravelExpense.setAssigned(true);
            historicalTravelExpense.setDocumentType(travelDocument.getFinancialDocumentTypeCode());
        }
        service.save(historicalTravelExpenses);
        return expenses;
    }

    public static String getDefaultChartCode(TravelDocument document) {
        String defaultChartCode = null;
        if (document.getTemProfile() == null && document.getTemProfileId() != null) {
            HashMap<String, String> primaryKeys = new HashMap<String, String>();
            primaryKeys.put("profileId", document.getTemProfileId().toString());
            TemProfile profile = (TemProfile)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(TemProfile.class, primaryKeys);
            defaultChartCode = profile.getDefaultChartCode();
        } else if (document.getTemProfile() != null) {
            defaultChartCode = document.getTemProfile().getDefaultChartCode();
        }
        return defaultChartCode;
    }

    public static void assignExpense(Long historicalTravelExpenseId, String tripId, String documentNumber, String documentType, boolean isAssigned) {
        BusinessObjectService service = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        HistoricalTravelExpense historicalTravelExpense = (HistoricalTravelExpense)service.findBySinglePrimaryKey(HistoricalTravelExpense.class, (Object)historicalTravelExpenseId);
        historicalTravelExpense.setAssigned(isAssigned);
        historicalTravelExpense.setTripId(tripId);
        historicalTravelExpense.setDocumentNumber(documentNumber);
        historicalTravelExpense.setDocumentType(documentType);
        service.save((PersistableBusinessObject)historicalTravelExpense);
    }

    public static void calculateMileage(TravelDocument travelDocument, List<ActualExpense> actualExpenses) {
        for (ActualExpense actualExpense : actualExpenses) {
            if (StringUtils.isBlank((String)actualExpense.getExpenseTypeCode()) || !actualExpense.isMileage()) continue;
            KualiDecimal total = KualiDecimal.ZERO;
            for (TemExpense temExpense : actualExpense.getExpenseDetails()) {
                ActualExpense detailExpense = (ActualExpense)temExpense;
                if (detailExpense.getMileageRate(travelDocument.getEffectiveDateForMileageRate(detailExpense)) == null) continue;
                KualiDecimal mileage = new KualiDecimal(new BigDecimal(detailExpense.getMiles()).multiply(detailExpense.getMileageRate(travelDocument.getEffectiveDateForMileageRate(detailExpense)).getRate()));
                detailExpense.setExpenseAmount(mileage);
                detailExpense.setConvertedAmount(mileage);
                total = (KualiDecimal)total.add((AbstractKualiDecimal)detailExpense.getExpenseAmount());
                detailExpense.setCurrencyRate(actualExpense.getCurrencyRate());
                detailExpense.setExpenseTypeObjectCodeId(actualExpense.getExpenseTypeObjectCodeId());
            }
            actualExpense.setExpenseAmount(total);
        }
    }
}

