/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.businessobject.lookup;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerAddress;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleService;
import org.kuali.kfs.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.kns.web.ui.Field;
import org.kuali.kfs.kns.web.ui.Row;
import org.kuali.kfs.krad.lookup.CollectionIncomplete;
import org.kuali.kfs.krad.util.BeanPropertyComparator;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.TemProfileAddress;
import org.kuali.kfs.module.tem.dataaccess.TravelerDao;
import org.kuali.kfs.module.tem.service.TravelerService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.identity.address.EntityAddressBo;
import org.kuali.rice.krad.bo.BusinessObject;

public class TemProfileAddressLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    public static Logger LOG = Logger.getLogger(TemProfileAddressLookupableHelperServiceImpl.class);
    private static final long serialVersionUID = 5438499177869581678L;
    private TravelerDao travelerDao;
    private TravelerService travelerService;
    private IdentityService identityService;
    private AccountsReceivableModuleService accountsReceivableModuleService;
    private Map<String, String> temProfileAddressToKimAddress;
    private Map<String, String> temProfileAddressToCustomerAddress;

    public Collection performLookup(LookupForm lookupForm, Collection resultTable, boolean bounded) {
        lookupForm.setSuppressActions(false);
        lookupForm.setSupplementalActionsEnabled(true);
        lookupForm.setHideReturnLink(false);
        lookupForm.setShowMaintenanceLinks(true);
        return super.performLookup(lookupForm, resultTable, bounded);
    }

    public void performClear(LookupForm arg0) {
        for (Row row : this.getRows()) {
            for (Field field : row.getFields()) {
                if (field.isSecure()) {
                    field.setSecure(false);
                    field.setDisplayMaskValue(null);
                    field.setEncryptedValue(null);
                }
                if (field.getFieldType().equals("radio") || field.getFieldType().equals("hidden")) continue;
                field.setPropertyValue(field.getDefaultValue());
            }
        }
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        ArrayList<TemProfileAddress> searchResults = new ArrayList<TemProfileAddress>();
        if (fieldValues.containsKey("principalId") && !StringUtils.isEmpty((String)fieldValues.get("principalId"))) {
            Map<String, String> kimFieldsForLookup = this.getPersonFieldValues(fieldValues);
            kimFieldsForLookup.put("active", "Y");
            List addresses = (List)this.getLookupService().findCollectionBySearchHelper(EntityAddressBo.class, kimFieldsForLookup, false);
            for (Object object : addresses) {
            }
        }
        if (searchResults.isEmpty() && fieldValues.containsKey("customerNumber") && !StringUtils.isEmpty((String)fieldValues.get("customerNumber"))) {
            Map<String, String> customerFieldsForLookup = this.getCustomerFieldValues(fieldValues);
            LOG.debug((Object)("Using fieldsForLookup " + customerFieldsForLookup));
            Collection customerAddresses = this.getAccountsReceivableModuleService().searchForCustomerAddresses(customerFieldsForLookup);
            for (AccountsReceivableCustomerAddress customerAddress : customerAddresses) {
                boolean active = true;
                if (ObjectUtils.isNotNull((Object)customerAddress) && ObjectUtils.isNotNull((Object)customerAddress.getCustomerAddressEndDate())) {
                    Timestamp currentDateTimestamp = new Timestamp(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentDate().getTime());
                    Timestamp addressEndDateTimestamp = new Timestamp(customerAddress.getCustomerAddressEndDate().getTime());
                    if (addressEndDateTimestamp.before(currentDateTimestamp)) {
                        active = false;
                    }
                }
                if (!active) continue;
                searchResults.add(this.getTravelerService().convertToTemProfileAddressFromCustomer(customerAddress));
            }
        }
        CollectionIncomplete results = new CollectionIncomplete(searchResults, Long.valueOf(searchResults.size()));
        List defaultSortColumns = this.getDefaultSortColumns();
        if (defaultSortColumns.size() > 0) {
            Collections.sort(results, new BeanPropertyComparator(defaultSortColumns, true));
        }
        return results;
    }

    protected Map<String, String> getCustomerFieldValues(Map<String, String> fieldValues) {
        HashMap<String, String> customerFieldValues = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : fieldValues.entrySet()) {
            if (!this.temProfileAddressToCustomerAddress.containsKey(entry.getKey()) || StringUtils.isEmpty((String)entry.getValue())) continue;
            customerFieldValues.put(this.temProfileAddressToCustomerAddress.get(entry.getKey()), entry.getValue());
        }
        return customerFieldValues;
    }

    protected Map<String, String> getPersonFieldValues(Map<String, String> fieldValues) {
        HashMap<String, String> kimFieldValues = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : fieldValues.entrySet()) {
            if (entry.getKey().equalsIgnoreCase("principalId") && !StringUtils.isEmpty((String)entry.getValue())) {
                Principal principal = this.getIdentityService().getPrincipal(entry.getValue());
                kimFieldValues.put(this.temProfileAddressToKimAddress.get(entry.getKey()), principal.getEntityId());
                continue;
            }
            if (!this.temProfileAddressToKimAddress.containsKey(entry.getKey()) || StringUtils.isEmpty((String)entry.getValue())) continue;
            kimFieldValues.put(this.temProfileAddressToKimAddress.get(entry.getKey()), entry.getValue());
        }
        return kimFieldValues;
    }

    public void setTravelerDao(TravelerDao travelerDao) {
        this.travelerDao = travelerDao;
    }

    public TravelerDao getTravelerDao() {
        return this.travelerDao;
    }

    public void setTravelerService(TravelerService travelerService) {
        this.travelerService = travelerService;
    }

    public TravelerService getTravelerService() {
        return this.travelerService;
    }

    public Map<String, String> getTemProfileAddressToKimAddress() {
        return this.temProfileAddressToKimAddress;
    }

    public void setTemProfileAddressToKimAddress(Map<String, String> temProfileAddressToKimAddress) {
        this.temProfileAddressToKimAddress = temProfileAddressToKimAddress;
    }

    public Map<String, String> getTemProfileAddressToCustomerAddress() {
        return this.temProfileAddressToCustomerAddress;
    }

    public void setTemProfileAddressToCustomerAddress(Map<String, String> temProfileAddressToCustomerAddress) {
        this.temProfileAddressToCustomerAddress = temProfileAddressToCustomerAddress;
    }

    public IdentityService getIdentityService() {
        if (this.identityService == null) {
            this.identityService = KimApiServiceLocator.getIdentityService();
        }
        return this.identityService;
    }

    protected AccountsReceivableModuleService getAccountsReceivableModuleService() {
        if (this.accountsReceivableModuleService == null) {
            this.accountsReceivableModuleService = (AccountsReceivableModuleService)SpringContext.getBean(AccountsReceivableModuleService.class);
        }
        return this.accountsReceivableModuleService;
    }

    public void setAccountsReceivableModuleService(AccountsReceivableModuleService accountsReceivableModuleService) {
        this.accountsReceivableModuleService = accountsReceivableModuleService;
    }
}

